/*
 * Decompiled with CFR 0.152.
 */
package builder.resid.residfp;

final class ExternalFilter {
    private static final double LOWPASS_FREQUENCY = 15915.6;
    private float Vlp;
    private float Vhp;
    private float w0lp;
    private float w0hp;

    protected float clock(float Vi) {
        float out = this.Vlp - this.Vhp;
        this.Vhp += this.w0hp * out;
        this.Vlp += this.w0lp * (Vi - this.Vlp);
        return out;
    }

    protected void zeroDenormals() {
        if (this.Vhp > -1.0E-12f && this.Vhp < 1.0E-12f) {
            this.Vhp = 0.0f;
        }
        if (this.Vlp > -1.0E-12f && this.Vlp < 1.0E-12f) {
            this.Vlp = 0.0f;
        }
    }

    protected ExternalFilter() {
        this.reset();
    }

    protected void setClockFrequency(double frequency) {
        this.w0hp = (float)(100.0 / frequency);
        this.w0lp = (float)(100000.66407494743 / frequency);
    }

    protected void reset() {
        this.Vlp = 0.0f;
        this.Vhp = 0.0f;
    }
}

