/*
 * Decompiled with CFR 0.152.
 */
package libsidplay.components.mos656x;

import libsidplay.common.Event;
import libsidplay.common.EventScheduler;
import libsidplay.components.mos656x.PALEmulation;
import libsidplay.components.mos656x.Sprite;
import libsidplay.components.mos656x.VIC;
import libsidplay.components.pla.PLA;

public final class MOS6569
extends VIC {
    public static final int CYCLES_PER_LINE = 63;
    public static final int MAX_RASTERS = 312;
    private static final int FIRST_DISPLAY_LINE = 15;
    private static final int LAST_DISPLAY_LINE = 300;
    public static final int BORDER_HEIGHT = 285;
    private final Event event = Event.of("MOS6569", event -> {
        if (this.lineCycle == 63) {
            this.lineCycle = 0;
        }
        ++this.lineCycle;
        if (this.graphicsRendering && (this.lineCycle >= 23 || this.lineCycle < 8)) {
            this.drawSpritesAndGraphics();
        } else {
            this.spriteCollisionsOnly();
        }
        this.doPHI1Fetch();
        switch (this.lineCycle) {
            case 1: {
                for (Sprite sprite : this.sprites) {
                    if (!sprite.isEnabled() || sprite.getY() != (this.rasterY & 0xFF)) continue;
                    sprite.beginDMA();
                }
                this.setBA(!this.sprites[0].isDMA());
                break;
            }
            case 2: {
                for (Sprite sprite : this.sprites) {
                    if (sprite.isEnabled() && sprite.getY() == (this.rasterY & 0xFF)) {
                        sprite.beginDMA();
                        sprite.setAllowDisplay(true);
                    } else {
                        sprite.setAllowDisplay(false);
                    }
                    sprite.expandYFlipFlop();
                }
                this.setBA(!this.sprites[0].isDMA());
                break;
            }
            case 3: {
                this.setBA(!this.sprites[0].isDMA() && !this.sprites[1].isDMA());
                break;
            }
            case 4: {
                if (this.rc == 7) {
                    this.vcBase = this.vc;
                    this.isDisplayActive = this.isBadLine;
                }
                if (this.isDisplayActive) {
                    this.rc = this.rc + 1 & 7;
                }
                for (Sprite sprite : this.sprites) {
                    if (sprite.isEnabled() && sprite.getY() == (this.rasterY & 0xFF)) {
                        sprite.setDisplay(true);
                    }
                    if (!sprite.isDMA()) {
                        sprite.setDisplay(false);
                    }
                    sprite.initDmaAccess();
                }
                this.fetchSpritePointer(0);
                break;
            }
            case 5: {
                this.fetchSpriteData(0);
                this.setBA(!this.sprites[0].isDMA() && !this.sprites[1].isDMA() && !this.sprites[2].isDMA());
                break;
            }
            case 6: {
                this.fetchSpritePointer(1);
                this.setBA(!this.sprites[1].isDMA() && !this.sprites[2].isDMA());
                break;
            }
            case 7: {
                this.fetchSpriteData(1);
                this.setBA(!this.sprites[1].isDMA() && !this.sprites[2].isDMA() && !this.sprites[3].isDMA());
                break;
            }
            case 8: {
                this.fetchSpritePointer(2);
                this.setBA(!this.sprites[2].isDMA() && !this.sprites[3].isDMA());
                break;
            }
            case 9: {
                this.fetchSpriteData(2);
                this.setBA(!this.sprites[2].isDMA() && !this.sprites[3].isDMA() && !this.sprites[4].isDMA());
                break;
            }
            case 10: {
                int narrowing;
                if (this.rasterY == 311) {
                    this.vcBase = 0;
                    this.startOfFrame = true;
                } else {
                    ++this.rasterY;
                    this.rasterYIRQEdgeDetector.event();
                }
                if (this.rasterY == 48) {
                    this.areBadLinesEnabled = this.readDEN();
                }
                this.isBadLine = this.evaluateIsBadLine();
                this.isDisplayActive |= this.isBadLine;
                int n = narrowing = this.readRSEL() ? 0 : 4;
                if (this.rasterY == 51 + narrowing && this.readDEN()) {
                    this.showBorderVertical = false;
                }
                if (this.rasterY == 251 - narrowing) {
                    this.showBorderVertical = true;
                }
                this.latchedXscroll = this.xscroll << 2;
                if (this.palEmulation != PALEmulation.NONE) {
                    this.palEmulation.determineCurrentPalette(this.rasterY, this.rasterY == 15);
                }
                if (this.rasterY == 15) {
                    this.graphicsRendering = true;
                }
                if (this.rasterY == 301) {
                    this.graphicsRendering = false;
                    this.videoDriver.accept(this);
                }
                this.fetchSpritePointer(3);
                this.setBA(!this.sprites[3].isDMA() && !this.sprites[4].isDMA());
                break;
            }
            case 11: {
                if (this.startOfFrame) {
                    this.startOfFrame = false;
                    this.rasterY = 0;
                    this.rasterYIRQEdgeDetector.event();
                    this.lpTriggered = false;
                    this.lightpenEdgeDetector();
                }
                this.setBA(!this.sprites[3].isDMA() && !this.sprites[4].isDMA() && !this.sprites[5].isDMA());
                this.fetchSpriteData(3);
                break;
            }
            case 12: {
                this.fetchSpritePointer(4);
                this.setBA(!this.sprites[4].isDMA() && !this.sprites[5].isDMA());
                break;
            }
            case 13: {
                this.fetchSpriteData(4);
                this.setBA(!this.sprites[4].isDMA() && !this.sprites[5].isDMA() && !this.sprites[6].isDMA());
                break;
            }
            case 14: {
                this.fetchSpritePointer(5);
                this.setBA(!this.sprites[5].isDMA() && !this.sprites[6].isDMA());
                break;
            }
            case 15: {
                this.fetchSpriteData(5);
                this.setBA(!this.sprites[5].isDMA() && !this.sprites[6].isDMA() && !this.sprites[7].isDMA());
                break;
            }
            case 16: {
                this.fetchSpritePointer(6);
                this.setBA(!this.sprites[6].isDMA() && !this.sprites[7].isDMA());
                break;
            }
            case 17: {
                this.fetchSpriteData(6);
                break;
            }
            case 18: {
                this.fetchSpritePointer(7);
                this.setBA(!this.sprites[7].isDMA());
                break;
            }
            case 19: {
                this.fetchSpriteData(7);
                break;
            }
            case 20: {
                this.setBA(true);
                break;
            }
            case 21: {
                this.setBA(!this.isBadLine);
                break;
            }
            case 22: {
                break;
            }
            case 23: {
                this.vc = this.vcBase;
                if (!this.isBadLine) break;
                this.rc = 0;
                break;
            }
            case 24: {
                if (!this.isBadLine) break;
                this.doVideoMatrixAccess();
                break;
            }
            case 25: {
                if (this.isBadLine) {
                    this.doVideoMatrixAccess();
                }
                for (Sprite sprite : this.sprites) {
                    if (!sprite.isDMA()) continue;
                    sprite.finishDmaAccess();
                }
                break;
            }
            default: {
                if (!this.isBadLine) break;
                this.doVideoMatrixAccess();
            }
        }
        this.context.schedule((Event)event, 1L);
    });

    public MOS6569(PLA pla, EventScheduler context) {
        super(pla, context, 63, 312);
    }

    protected void doPHI1Fetch() {
        switch (this.lineCycle) {
            case 2: 
            case 3: {
                this.phi1Data = this.vicReadMemoryPHI1(16383);
                return;
            }
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 12: 
            case 14: 
            case 16: 
            case 18: {
                int n = this.lineCycle - 4 >> 1;
                this.phi1Data = this.vicReadMemoryPHI1(this.videoMatrixBase | 0x3F8 | n);
                return;
            }
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 13: 
            case 15: 
            case 17: 
            case 19: {
                int n = this.lineCycle - 5 >> 1;
                if (this.sprites[n].isDMA()) {
                    int address = this.sprites[n].getCurrentByteAddress();
                    this.phi1Data = this.vicReadMemoryPHI1(address);
                } else {
                    this.phi1Data = this.vicReadMemoryPHI1(16383);
                }
                return;
            }
            default: {
                int address = 16383;
                if ((this.registers[17] & 0x40) != 0) {
                    address ^= 0x600;
                }
                if (this.isDisplayActive) {
                    if ((this.registers[17] & 0x20) != 0) {
                        address &= this.bitmapMemBase | this.vc << 3 | this.rc;
                    } else {
                        int n = this.lineCycle == 1 ? 39 : this.lineCycle - 25;
                        address &= this.charMemBase | (this.videoMatrixData[n] & 0xFF) << 3 | this.rc;
                    }
                    this.vc = this.vc + 1 & 0x3FF;
                }
                this.phi1Data = this.vicReadMemoryPHI1(address);
                return;
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
        }
        int n = this.lineCycle - 20;
        int offset = 255 - this.rasterY * 5 - n & 0xFF;
        this.phi1Data = this.vicReadMemoryPHI1(0x3F00 | offset);
    }

    @Override
    public void reset() {
        super.reset();
        if (this.palEmulation != PALEmulation.NONE) {
            this.palEmulation.updatePalette();
        }
        this.lineCycle = 9;
        this.context.schedule(this.event, 0L, Event.Phase.PHI1);
    }

    @Override
    public int getBorderHeight() {
        return 285;
    }

    @Override
    public int getRasterYMax() {
        return 300;
    }
}

