/*
 * Decompiled with CFR 0.152.
 */
package server.restful.servlets.rtmp;

import com.beust.jcommander.Parameters;
import jakarta.servlet.ServletException;
import jakarta.servlet.annotation.WebServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.UUID;
import server.restful.common.JSIDPlay2Servlet;
import server.restful.common.ServletUtil;
import server.restful.common.parameter.ServletParameterParser;
import server.restful.common.parameter.requestparam.VideoRequestParamServletParameters;
import server.restful.common.rtmp.PlayerCleanupTimerTask;
import server.restful.common.rtmp.PlayerWithStatus;

@WebServlet(name="OnPlayServlet", displayName="OnPlayServlet", urlPatterns={"/static/on_play"}, description="Play video stream. Implements RTMP directive on_play configured in nginx.conf")
public class OnPlayServlet
extends JSIDPlay2Servlet {
    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            OnPlayServletParameters servletParameters = new OnPlayServletParameters();
            ServletParameterParser parser = new ServletParameterParser(request, response, servletParameters, true);
            if (servletParameters.getHelp().booleanValue()) {
                parser.usage();
                return;
            }
            if (servletParameters.getUuid() == null) {
                return;
            }
            UUID uuid = servletParameters.getUuid();
            ServletUtil.info(this.getServletContext(), String.format("onPlay: RTMP stream of: %s", uuid), new Thread[0]);
            PlayerCleanupTimerTask.update(uuid, PlayerWithStatus::onPlay);
        }
        catch (Throwable t) {
            response.setStatus(500);
            ServletUtil.error(this.getServletContext(), t, new Thread[0]);
            this.setOutput(response, t);
        }
    }

    @Parameters(resourceBundle="server.restful.servlets.rtmp.OnPlayServletParameters")
    public static class OnPlayServletParameters
    extends VideoRequestParamServletParameters {
    }
}

