/*
 * Decompiled with CFR 0.152.
 */
package ui.entities.config;

import com.fasterxml.jackson.annotation.JsonIgnore;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javax.persistence.Access;
import javax.persistence.AccessType;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.xml.bind.annotation.XmlTransient;
import sidplay.ini.converter.BeanToStringConverter;
import ui.common.properties.ShadowField;
import ui.entities.config.Assembly64ColumnType;

@Entity
@Access(value=AccessType.PROPERTY)
public class Assembly64Column {
    private Integer id;
    private ShadowField<ObjectProperty<Assembly64ColumnType>, Assembly64ColumnType> columnType = new ShadowField<ObjectProperty, Object>(SimpleObjectProperty::new, null);
    private ShadowField<DoubleProperty, Number> width = new ShadowField<DoubleProperty, Integer>(number -> new SimpleDoubleProperty((double)number.floatValue()), 0);

    public Assembly64Column() {
    }

    public Assembly64Column(Assembly64Column assembly64Column) {
        this.setColumnType(assembly64Column.getColumnType());
        this.setWidth(assembly64Column.getWidth());
    }

    public Assembly64Column(Assembly64ColumnType assembly64ColumnType) {
        this.setColumnType(assembly64ColumnType);
        this.setWidth(assembly64ColumnType.getDefaultWidth());
    }

    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE)
    @XmlTransient
    @JsonIgnore
    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    @Enumerated(value=EnumType.STRING)
    public Assembly64ColumnType getColumnType() {
        return this.columnType.get();
    }

    public void setColumnType(Assembly64ColumnType columnType) {
        this.columnType.set(columnType);
    }

    public final ObjectProperty<Assembly64ColumnType> columnTypeProperty() {
        return this.columnType.property();
    }

    public double getWidth() {
        return this.width.get().doubleValue();
    }

    public void setWidth(double width) {
        this.width.set(width);
    }

    public final DoubleProperty widthProperty() {
        return this.width.property();
    }

    public final String toString() {
        return BeanToStringConverter.toString(this);
    }
}

