/*
 * Decompiled with CFR 0.152.
 */
package ui.toolbar;

import builder.jsidblaster.JSIDBlasterBuilder;
import builder.jusbsid.JUSBSIDBuilder;
import builder.netsiddev.NetSIDDevConnection;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Objects;
import java.util.ResourceBundle;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javafx.application.Platform;
import javafx.beans.binding.Bindings;
import javafx.beans.property.Property;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Hyperlink;
import javafx.scene.control.Label;
import javafx.scene.control.ProgressBar;
import javafx.scene.control.RadioButton;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.TextField;
import javafx.scene.control.ToggleGroup;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.VBox;
import javafx.stage.FileChooser;
import javafx.util.StringConverter;
import javafx.util.converter.IntegerStringConverter;
import javax.sound.sampled.Mixer;
import libsidplay.common.CPUClock;
import libsidplay.common.ChipModel;
import libsidplay.common.Engine;
import libsidplay.common.Event;
import libsidplay.common.EventScheduler;
import libsidplay.common.Mixer;
import libsidplay.common.OS;
import libsidplay.common.SamplingMethod;
import libsidplay.common.SamplingRate;
import libsidplay.common.Ultimate64Mode;
import libsidplay.config.ISidPlay2SystemProperties;
import libsidplay.sidtune.MP3Tune;
import libsidplay.sidtune.SidTune;
import libsidplay.sidtune.SidTuneError;
import libsidutils.IOUtils;
import server.restful.JSIDPlay2Server;
import server.restful.common.Connectors;
import sidplay.Player;
import sidplay.audio.Audio;
import sidplay.audio.JavaSound;
import sidplay.ini.IniConfig;
import sidplay.player.State;
import ui.common.C64VBox;
import ui.common.C64Window;
import ui.common.UIPart;
import ui.common.converter.EnumToStringConverter;
import ui.common.converter.HardSIDSlotToIntegerConverter;
import ui.common.converter.MinimumNumberToStringConverter;
import ui.common.converter.MixerInfoToStringConverter;
import ui.common.converter.TimeToStringConverter;
import ui.common.converter.UsbSidSlotToIntegerConverter;
import ui.common.fileextension.MP3TuneFileExtensions;
import ui.common.properties.BindingUtils;
import ui.common.util.DesktopUtil;
import ui.entities.config.AudioSection;
import ui.entities.config.Configuration;
import ui.entities.config.DeviceMapping;
import ui.entities.config.EmulationSection;
import ui.entities.config.SidPlay2Section;
import ui.toolbar.SidBlasterDeviceMapping;

public class ToolBar
extends C64VBox
implements UIPart {
    private StateChangeListener propertyChangeListener;
    private static final String SIDBLASTER_TEST_SID = "/ui/toolbar/sidblaster_test.sid";
    @FXML
    private ComboBox<SamplingMethod> samplingBox;
    @FXML
    private ComboBox<CPUClock> videoStandardBox;
    @FXML
    private ComboBox<Integer> usbsidAudioBox;
    @FXML
    private ComboBox<Integer> hardsid6581Box;
    @FXML
    private ComboBox<Integer> hardsid8580Box;
    @FXML
    private ComboBox<Integer> audioBufferSize;
    @FXML
    private ComboBox<Integer> sidBlasterWriteBufferSize;
    @FXML
    private ComboBox<Short> sidBlasterLatencyTimer;
    @FXML
    private ComboBox<SamplingRate> samplingRateBox;
    @FXML
    private ComboBox<Audio> audioBox;
    @FXML
    private ComboBox<Mixer.Info> devicesBox;
    @FXML
    private ComboBox<Engine> engineBox;
    @FXML
    private ComboBox<Connectors> appServerConnectorsBox;
    @FXML
    private ComboBox<Ultimate64Mode> ultimate64Box;
    @FXML
    private CheckBox sidBlasterRead;
    @FXML
    private CheckBox enableSldb;
    @FXML
    private CheckBox singleSong;
    @FXML
    private TextField bufferSize;
    @FXML
    private TextField defaultPlayLength;
    @FXML
    private TextField hostname;
    @FXML
    private TextField port;
    @FXML
    private TextField ultimate64Hostname;
    @FXML
    private TextField ultimate64Port;
    @FXML
    private TextField ultimate64SyncDelay;
    @FXML
    private TextField appServerPort;
    @FXML
    private TextField appServerSecurePort;
    @FXML
    private TextField appServerKeyStorePassword;
    @FXML
    private TextField appServerKeyAlias;
    @FXML
    private TextField appServerKeyPassword;
    @FXML
    private TextField ultimate64StreamingTarget;
    @FXML
    private TextField ultimate64StreamingAudioPort;
    @FXML
    private TextField ultimate64StreamingVideoPort;
    @FXML
    private TextField videoStreamingUrl;
    @FXML
    private ScrollPane sidBlasterScrollPane;
    @FXML
    private VBox sidBlasterDeviceParent;
    @FXML
    private Button addSidBlaster;
    @FXML
    private Button autodetect;
    @FXML
    private Button volumeButton;
    @FXML
    private Button mp3Browse;
    @FXML
    private Button keystoreBrowse;
    @FXML
    private RadioButton playMP3;
    @FXML
    private RadioButton playEmulation;
    @FXML
    private RadioButton startAppServer;
    @FXML
    private RadioButton stopAppServer;
    @FXML
    private ToggleGroup playSourceGroup;
    @FXML
    private ToggleGroup appServerGroup;
    @FXML
    private ToggleGroup testButtonGroup;
    @FXML
    private Label usbsidAudioLabel;
    @FXML
    private Label hostnameLabel;
    @FXML
    private Label portLabel;
    @FXML
    private Label hardsid6581Label;
    @FXML
    private Label hardsid8580Label;
    @FXML
    private Label appIpAddress;
    @FXML
    private Label appHostname;
    @FXML
    private Label appServerPortLbl;
    @FXML
    private Label appServerSecurePortLbl;
    @FXML
    private Label appServerKeyStorePasswordLbl;
    @FXML
    private Label appServerKeyAliasLbl;
    @FXML
    private Label appServerKeyPasswordLbl;
    @FXML
    private Label sidBlasterWriteBufferSizeLbl;
    @FXML
    private Label sidBlasterLatencyTimerLbl;
    @FXML
    private Label sidBlasterReadLbl;
    @FXML
    private Label streamingIpAddress;
    @FXML
    private Label streamingHostname;
    @FXML
    private Hyperlink appServerUsage;
    @FXML
    private Hyperlink onlinePlayer;
    @FXML
    private Hyperlink sidBlasterDoc;
    @FXML
    private Hyperlink offlinePlayerWasm;
    @FXML
    private Hyperlink offlinePlayerWasmGcSab;
    @FXML
    private Hyperlink offlinePlayerWasmGc;
    @FXML
    private Hyperlink offlinePlayerJs;
    @FXML
    private Hyperlink offlinePlayerJsEm2015;
    @FXML
    private ProgressBar progress;
    private ObservableList<Ultimate64Mode> ultimate64Modes;
    private JSIDPlay2Server jsidplay2Server;
    private Player testPlayer;
    private boolean duringInitialization;
    private boolean duringReplay;

    public ToolBar() {
    }

    public ToolBar(C64Window window, Player player) {
        super(window, player);
    }

    @Override
    @FXML
    protected void initialize() {
        this.duringInitialization = true;
        ResourceBundle bundle = this.util.getBundle();
        Configuration config = this.util.getConfig();
        SidPlay2Section sidplay2Section = config.getSidplay2Section();
        AudioSection audioSection = config.getAudioSection();
        EmulationSection emulationSection = config.getEmulationSection();
        this.jsidplay2Server = JSIDPlay2Server.getInstance(config);
        this.audioBox.setConverter(new EnumToStringConverter(bundle));
        this.audioBox.setItems(FXCollections.observableArrayList(Audio.getLiveAudio()));
        this.audioBox.valueProperty().addListener((obj, o, n) -> {
            this.mp3Browse.setDisable(!Audio.COMPARE_MP3.equals(n));
            this.playMP3.setDisable(!Audio.COMPARE_MP3.equals(n));
            this.playEmulation.setDisable(!Audio.COMPARE_MP3.equals(n));
        });
        this.audioBox.valueProperty().bindBidirectional(audioSection.audioProperty());
        this.devicesBox.setConverter((StringConverter)new MixerInfoToStringConverter(this.util.getBundle(), "NO_AUDIO"));
        this.devicesBox.setItems(FXCollections.observableArrayList(JavaSound.getDeviceInfos()));
        this.devicesBox.getSelectionModel().select(Math.min(audioSection.getDevice(), this.devicesBox.getItems().size() - 1));
        this.samplingBox.setConverter(new EnumToStringConverter(bundle));
        this.samplingBox.setItems(FXCollections.observableArrayList((Object[])SamplingMethod.values()));
        this.samplingBox.valueProperty().bindBidirectional(audioSection.samplingProperty());
        this.samplingRateBox.setConverter(new EnumToStringConverter(bundle));
        this.samplingRateBox.setItems(FXCollections.observableArrayList((Object[])SamplingRate.values()));
        BindingUtils.bindBidirectionalThreadSafe(this.samplingRateBox.valueProperty(), audioSection.samplingRateProperty(), () -> {
            this.duringReplay = this.util.getPlayer().stateProperty().get() == State.RESTART;
        });
        this.videoStandardBox.setConverter(new EnumToStringConverter(bundle));
        this.videoStandardBox.valueProperty().bindBidirectional(emulationSection.userClockSpeedProperty());
        this.videoStandardBox.setItems(FXCollections.observableArrayList((Object[])CPUClock.values()));
        this.usbsidAudioBox.setConverter((StringConverter)new UsbSidSlotToIntegerConverter(this.util.getBundle()));
        this.usbsidAudioBox.valueProperty().bindBidirectional(emulationSection.usbsidAudioProperty());
        this.hardsid6581Box.setConverter((StringConverter)new HardSIDSlotToIntegerConverter(this.util.getBundle()));
        this.hardsid6581Box.valueProperty().bindBidirectional(emulationSection.hardsid6581Property());
        this.hardsid8580Box.setConverter((StringConverter)new HardSIDSlotToIntegerConverter(this.util.getBundle()));
        this.hardsid8580Box.valueProperty().bindBidirectional(emulationSection.hardsid8580Property());
        this.audioBufferSize.valueProperty().bindBidirectional(audioSection.audioBufferSizeProperty());
        this.engineBox.setConverter(new EnumToStringConverter(bundle));
        this.engineBox.setItems(FXCollections.observableArrayList((Object[])new Engine[]{Engine.EMULATION, Engine.NETSID, Engine.HARDSID, Engine.SIDBLASTER, Engine.EXSID, Engine.USBSID, Engine.HARDSID_DLL}));
        this.engineBox.valueProperty().addListener((obj, o, n) -> {
            this.hardsid6581Box.setDisable(!Engine.HARDSID.equals(n) && !Engine.HARDSID_DLL.equals(n));
            this.hardsid8580Box.setDisable(!Engine.HARDSID.equals(n) && !Engine.HARDSID_DLL.equals(n));
            this.hardsid6581Label.setDisable(!Engine.HARDSID.equals(n) && !Engine.HARDSID_DLL.equals(n));
            this.hardsid8580Label.setDisable(!Engine.HARDSID.equals(n) && !Engine.HARDSID_DLL.equals(n));
            this.usbsidAudioBox.setDisable(!Engine.USBSID.equals(n));
            this.usbsidAudioLabel.setDisable(!Engine.USBSID.equals(n));
            this.hostnameLabel.setDisable(!Engine.NETSID.equals(n));
            this.hostname.setDisable(!Engine.NETSID.equals(n));
            this.portLabel.setDisable(!Engine.NETSID.equals(n));
            this.port.setDisable(!Engine.NETSID.equals(n));
            this.audioBox.setDisable(!Engine.EMULATION.equals(n));
            this.devicesBox.setDisable(!Engine.EMULATION.equals(n));
            this.samplingBox.setDisable(!Engine.EMULATION.equals(n));
            this.samplingRateBox.setDisable(!Engine.EMULATION.equals(n));
            this.volumeButton.setDisable(!Engine.EMULATION.equals(n));
            this.disable((Node)this.sidBlasterDeviceParent, !Engine.SIDBLASTER.equals(n));
            this.addSidBlaster.setDisable(!Engine.SIDBLASTER.equals(n));
            this.autodetect.setDisable(!Engine.SIDBLASTER.equals(n));
            this.sidBlasterWriteBufferSizeLbl.setDisable(!Engine.SIDBLASTER.equals(n));
            this.sidBlasterWriteBufferSize.setDisable(!Engine.SIDBLASTER.equals(n));
            this.sidBlasterLatencyTimerLbl.setDisable(!Engine.SIDBLASTER.equals(n));
            this.sidBlasterLatencyTimer.setDisable(!Engine.SIDBLASTER.equals(n));
            this.sidBlasterReadLbl.setDisable(!Engine.SIDBLASTER.equals(n));
            this.sidBlasterRead.setDisable(!Engine.SIDBLASTER.equals(n));
        });
        this.engineBox.valueProperty().bindBidirectional(emulationSection.engineProperty());
        Bindings.bindBidirectional((Property)this.defaultPlayLength.textProperty(), (Property)sidplay2Section.defaultPlayLengthProperty(), (StringConverter)new TimeToStringConverter());
        sidplay2Section.defaultPlayLengthProperty().addListener((obj, o, n) -> this.util.checkTextField(this.defaultPlayLength, () -> n.intValue() != -1, () -> this.util.getPlayer().getTimer().updateEnd(this.util.getPlayer().getTune()), "DEFAULT_LENGTH_TIP", "DEFAULT_LENGTH_FORMAT"));
        Bindings.bindBidirectional((Property)this.bufferSize.textProperty(), (Property)audioSection.bufferSizeProperty(), (StringConverter)new MinimumNumberToStringConverter("#", 2048));
        audioSection.bufferSizeProperty().addListener((obj, o, n) -> this.util.checkTextField(this.bufferSize, () -> n.intValue() >= 2048, () -> {}, "BUFFER_SIZE_TIP", "BUFFER_SIZE_FORMAT"));
        this.sidBlasterWriteBufferSize.valueProperty().bindBidirectional(emulationSection.sidBlasterWriteBufferSizeProperty());
        emulationSection.getSidBlasterDeviceList().stream().forEach(this::addSidBlasterDeviceMapping);
        this.sidBlasterRead.selectedProperty().bindBidirectional((Property)emulationSection.sidBlasterReadProperty());
        this.sidBlasterLatencyTimer.valueProperty().bindBidirectional(emulationSection.sidBlasterLatencyTimerProperty());
        this.hostname.textProperty().bindBidirectional((Property)emulationSection.netSidDevHostProperty());
        Bindings.bindBidirectional((Property)this.port.textProperty(), emulationSection.netSidDevPortProperty(), (StringConverter)new IntegerStringConverter());
        this.ultimate64Modes = FXCollections.observableArrayList((Object[])Ultimate64Mode.values());
        this.ultimate64Box.setConverter(new EnumToStringConverter(bundle));
        this.ultimate64Box.valueProperty().bindBidirectional(emulationSection.ultimate64ModeProperty());
        this.ultimate64Box.setItems(this.ultimate64Modes);
        this.ultimate64Hostname.textProperty().bindBidirectional((Property)emulationSection.ultimate64HostProperty());
        Bindings.bindBidirectional((Property)this.ultimate64Port.textProperty(), emulationSection.ultimate64PortProperty(), (StringConverter)new IntegerStringConverter());
        Bindings.bindBidirectional((Property)this.ultimate64SyncDelay.textProperty(), emulationSection.ultimate64SyncDelayProperty(), (StringConverter)new IntegerStringConverter());
        Bindings.bindBidirectional((Property)this.appServerPort.textProperty(), emulationSection.appServerPortProperty(), (StringConverter)new IntegerStringConverter());
        Bindings.bindBidirectional((Property)this.appServerSecurePort.textProperty(), emulationSection.appServerSecurePortProperty(), (StringConverter)new IntegerStringConverter());
        this.appServerConnectorsBox.setConverter(new EnumToStringConverter(bundle));
        this.appServerConnectorsBox.valueProperty().addListener((obj, o, n) -> {
            switch (n) {
                case HTTP_HTTPS: {
                    for (Node node : Arrays.asList(this.appServerPortLbl, this.appServerSecurePortLbl, this.appServerKeyStorePasswordLbl, this.appServerKeyAliasLbl, this.appServerKeyPasswordLbl, this.appServerPort, this.appServerSecurePort, this.keystoreBrowse, this.appServerKeyStorePassword, this.appServerKeyAlias, this.appServerKeyPassword)) {
                        node.setVisible(true);
                        node.setManaged(true);
                    }
                    break;
                }
                case HTTPS: {
                    for (Node node : Arrays.asList(this.appServerPortLbl, this.appServerPort)) {
                        node.setVisible(false);
                        node.setManaged(false);
                    }
                    for (Node node : Arrays.asList(this.appServerSecurePortLbl, this.appServerKeyStorePasswordLbl, this.appServerKeyAliasLbl, this.appServerKeyPasswordLbl, this.appServerSecurePort, this.keystoreBrowse, this.appServerKeyStorePassword, this.appServerKeyAlias, this.appServerKeyPassword)) {
                        node.setVisible(true);
                        node.setManaged(true);
                    }
                    break;
                }
                default: {
                    for (Node node : Arrays.asList(this.appServerSecurePortLbl, this.appServerKeyStorePasswordLbl, this.appServerKeyAliasLbl, this.appServerKeyPasswordLbl, this.appServerSecurePort, this.keystoreBrowse, this.appServerKeyStorePassword, this.appServerKeyAlias, this.appServerKeyPassword)) {
                        node.setVisible(false);
                        node.setManaged(false);
                    }
                    for (Node node : Arrays.asList(this.appServerPortLbl, this.appServerPort)) {
                        node.setVisible(true);
                        node.setManaged(true);
                    }
                }
            }
        });
        this.appServerConnectorsBox.setItems(FXCollections.observableArrayList((Object[])new Connectors[]{Connectors.HTTP, Connectors.HTTP_HTTPS, Connectors.HTTPS}));
        this.appServerConnectorsBox.valueProperty().bindBidirectional(emulationSection.appServerConnectorsProperty());
        this.appServerKeyStorePassword.textProperty().bindBidirectional((Property)emulationSection.appServerKeystorePasswordProperty());
        this.appServerKeyPassword.textProperty().bindBidirectional((Property)emulationSection.appServerKeyPasswordProperty());
        this.appServerKeyAlias.textProperty().bindBidirectional((Property)emulationSection.appServerKeyAliasProperty());
        this.enableSldb.selectedProperty().bindBidirectional((Property)sidplay2Section.enableDatabaseProperty());
        this.singleSong.selectedProperty().bindBidirectional((Property)sidplay2Section.singleProperty());
        BindingUtils.bindBidirectional(this.playSourceGroup, audioSection.playOriginalProperty());
        this.appHostname.setText(this.getHostname());
        this.appIpAddress.setText(this.util.getBundle().getString("IP") + " " + this.getIpAddresses());
        this.startAppServer.selectedProperty().addListener((observable, oldValue, newValue) -> {
            this.appServerUsage.setDisable(newValue == false);
            this.onlinePlayer.setDisable(newValue == false);
            this.offlinePlayerWasmGcSab.setDisable(newValue == false);
            this.offlinePlayerWasmGc.setDisable(newValue == false);
            this.offlinePlayerWasm.setDisable(newValue == false);
            this.offlinePlayerJs.setDisable(newValue == false);
            this.offlinePlayerJsEm2015.setDisable(newValue == false);
        });
        this.ultimate64StreamingTarget.textProperty().bindBidirectional((Property)emulationSection.ultimate64StreamingTargetProperty());
        this.ultimate64StreamingAudioPort.textProperty().bindBidirectional(emulationSection.ultimate64StreamingAudioPortProperty(), (StringConverter)new IntegerStringConverter());
        this.ultimate64StreamingVideoPort.textProperty().bindBidirectional(emulationSection.ultimate64StreamingVideoPortProperty(), (StringConverter)new IntegerStringConverter());
        this.streamingHostname.setText(this.getHostname());
        this.streamingIpAddress.setText(this.util.getBundle().getString("IP") + " " + this.getIpAddresses());
        this.videoStreamingUrl.textProperty().bindBidirectional((Property)audioSection.videoStreamingUrlProperty());
        this.propertyChangeListener = new StateChangeListener();
        this.util.getPlayer().stateProperty().addListener(this.propertyChangeListener);
        this.duringInitialization = false;
    }

    @FXML
    private void setAudio() {
        this.restart();
    }

    @FXML
    public void setDevice() {
        int deviceIndex = this.devicesBox.getSelectionModel().getSelectedIndex();
        this.util.getConfig().getAudioSection().setDevice(deviceIndex);
        this.restart();
    }

    @FXML
    private void setSampling() {
        this.restart();
    }

    @FXML
    private void setSamplingRate() {
        this.restart();
    }

    @FXML
    private void setEngine() {
        this.restart();
    }

    @FXML
    private void addSidBlaster() {
        EmulationSection emulationSection = this.util.getConfig().getEmulationSection();
        DeviceMapping deviceMapping = new DeviceMapping("", ChipModel.AUTO, true);
        emulationSection.getSidBlasterDeviceList().add(deviceMapping);
        this.addSidBlasterDeviceMapping(deviceMapping);
    }

    @FXML
    private void autodetect() {
        EmulationSection emulationSection = this.util.getConfig().getEmulationSection();
        try {
            if (JSIDBlasterBuilder.getSerialNumbers() == null) {
                this.triggerFetchSerialNumbers();
            }
            emulationSection.getSidBlasterDeviceList().clear();
            this.sidBlasterDeviceParent.getChildren().clear();
            for (int i = 0; i < JSIDBlasterBuilder.getSerialNumbers().length; ++i) {
                String serialNumber = JSIDBlasterBuilder.getSerialNumbers()[i];
                ChipModel chipModel = JSIDBlasterBuilder.getSidType(i).asChipModel();
                DeviceMapping deviceMapping = new DeviceMapping(serialNumber, chipModel, true);
                emulationSection.getSidBlasterDeviceList().add(deviceMapping);
                this.addSidBlasterDeviceMapping(deviceMapping);
            }
        }
        catch (Error error) {
            this.openErrorDialog(error.getMessage());
        }
    }

    @FXML
    private void setSid6581() {
        this.restart();
    }

    @FXML
    private void setSid8580() {
        this.restart();
    }

    @FXML
    private void setUSBSIDAudio() {
        EmulationSection emulationSection = this.util.getConfig().getEmulationSection();
        int usbsidAudio = emulationSection.getUsbSidAudio();
        JUSBSIDBuilder.setAudio(usbsidAudio);
    }

    @FXML
    private void setHostname() {
        NetSIDDevConnection.getInstance().invalidate();
        this.restart();
    }

    @FXML
    private void setPort() {
        NetSIDDevConnection.getInstance().invalidate();
        this.restart();
    }

    @FXML
    private void setUltimate64() {
        this.restart();
    }

    @FXML
    private void setUltimate64Hostname() {
        this.restart();
    }

    @FXML
    private void setUltimate64Port() {
        this.restart();
    }

    @FXML
    private void setUltimate64SyncDelay() {
        this.restart();
    }

    @FXML
    private void setAudioBufferSize() {
        this.restart();
    }

    @FXML
    private void setUltimate64StreamingTarget() {
        this.restart();
    }

    @FXML
    private void setUtimate64StreamingAudioPort() {
        this.restart();
    }

    @FXML
    private void setUtimate64StreamingVideoPort() {
        this.restart();
    }

    @FXML
    private void doKeystoreBrowse() {
        FileChooser fileDialog = new FileChooser();
        FileChooser.ExtensionFilter extFilter = new FileChooser.ExtensionFilter("Keystore file (*.ks)", new String[]{"Keystore file (*.ks)"});
        fileDialog.getExtensionFilters().add((Object)extFilter);
        File file = fileDialog.showOpenDialog(this.getScene().getWindow());
        if (file != null) {
            this.util.getConfig().getEmulationSection().setAppServerKeystoreFile(file);
        }
    }

    @FXML
    private void startAppServer() {
        try {
            this.jsidplay2Server.start();
        }
        catch (Exception e) {
            this.openErrorDialog(e.getMessage());
        }
    }

    @FXML
    private void stopAppServer() {
        try {
            this.jsidplay2Server.stop();
        }
        catch (Exception e) {
            this.openErrorDialog(e.getMessage());
        }
    }

    @FXML
    private void gotoRestApiUsage() {
        EmulationSection emulationSection = this.util.getConfig().getEmulationSection();
        Connectors appServerConnectors = emulationSection.getAppServerConnectors();
        int port = appServerConnectors.getPreferredProtocol().equals("http") ? emulationSection.getAppServerPort() : emulationSection.getAppServerSecurePort();
        DesktopUtil.browse(appServerConnectors.getPreferredProtocol() + "://127.0.0.1:" + port);
    }

    @FXML
    private void onlinePlayer() {
        try {
            EmulationSection emulationSection = this.util.getConfig().getEmulationSection();
            Connectors appServerConnectors = emulationSection.getAppServerConnectors();
            int port = appServerConnectors.getPreferredProtocol().equals("http") ? emulationSection.getAppServerPort() : emulationSection.getAppServerSecurePort();
            URI uri = new URI(this.util.getConfig().getOnlineSection().getOnlinePlayerUrl());
            URI localURI = new URI(appServerConnectors.getPreferredProtocol(), null, "127.0.0.1", port, uri.getPath(), uri.getQuery(), uri.getFragment());
            DesktopUtil.browse(localURI.toString());
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
    }

    @FXML
    private void offlinePlayerWasmGcSab() {
        try {
            EmulationSection emulationSection = this.util.getConfig().getEmulationSection();
            Connectors appServerConnectors = emulationSection.getAppServerConnectors();
            int port = appServerConnectors.getPreferredProtocol().equals("http") ? emulationSection.getAppServerPort() : emulationSection.getAppServerSecurePort();
            URI uri = new URI(this.util.getConfig().getOnlineSection().getOfflinePlayerWasmGcSabUrl());
            URI localURI = new URI(appServerConnectors.getPreferredProtocol(), null, "127.0.0.1", port, uri.getPath(), uri.getQuery(), uri.getFragment());
            DesktopUtil.browse(localURI.toString());
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
    }

    @FXML
    private void offlinePlayerWasmGc() {
        try {
            EmulationSection emulationSection = this.util.getConfig().getEmulationSection();
            Connectors appServerConnectors = emulationSection.getAppServerConnectors();
            int port = appServerConnectors.getPreferredProtocol().equals("http") ? emulationSection.getAppServerPort() : emulationSection.getAppServerSecurePort();
            URI uri = new URI(this.util.getConfig().getOnlineSection().getOfflinePlayerWasmGcUrl());
            URI localURI = new URI(appServerConnectors.getPreferredProtocol(), null, "127.0.0.1", port, uri.getPath(), uri.getQuery(), uri.getFragment());
            DesktopUtil.browse(localURI.toString());
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
    }

    @FXML
    private void offlinePlayerWasm() {
        try {
            EmulationSection emulationSection = this.util.getConfig().getEmulationSection();
            Connectors appServerConnectors = emulationSection.getAppServerConnectors();
            int port = appServerConnectors.getPreferredProtocol().equals("http") ? emulationSection.getAppServerPort() : emulationSection.getAppServerSecurePort();
            URI uri = new URI(this.util.getConfig().getOnlineSection().getOfflinePlayerWasmUrl());
            URI localURI = new URI(appServerConnectors.getPreferredProtocol(), null, "127.0.0.1", port, uri.getPath(), uri.getQuery(), uri.getFragment());
            DesktopUtil.browse(localURI.toString());
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
    }

    @FXML
    private void offlinePlayerJs() {
        try {
            EmulationSection emulationSection = this.util.getConfig().getEmulationSection();
            Connectors appServerConnectors = emulationSection.getAppServerConnectors();
            int port = appServerConnectors.getPreferredProtocol().equals("http") ? emulationSection.getAppServerPort() : emulationSection.getAppServerSecurePort();
            URI uri = new URI(this.util.getConfig().getOnlineSection().getOfflinePlayerJsUrl());
            URI localURI = new URI(appServerConnectors.getPreferredProtocol(), null, "127.0.0.1", port, uri.getPath(), uri.getQuery(), uri.getFragment());
            DesktopUtil.browse(localURI.toString());
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
    }

    @FXML
    private void offlinePlayerJsEm2015() {
        try {
            EmulationSection emulationSection = this.util.getConfig().getEmulationSection();
            Connectors appServerConnectors = emulationSection.getAppServerConnectors();
            int port = appServerConnectors.getPreferredProtocol().equals("http") ? emulationSection.getAppServerPort() : emulationSection.getAppServerSecurePort();
            URI uri = new URI(this.util.getConfig().getOnlineSection().getOfflinePlayerJsEm2015Url());
            URI localURI = new URI(appServerConnectors.getPreferredProtocol(), null, "127.0.0.1", port, uri.getPath(), uri.getQuery(), uri.getFragment());
            DesktopUtil.browse(localURI.toString());
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
    }

    @FXML
    private void gotoSidBlasterDoc() {
        DesktopUtil.browse(this.util.getConfig().getOnlineSection().getSidBlasterDocUrl());
    }

    @FXML
    private void doEnableSldb() {
        EventScheduler ctx = this.util.getPlayer().getC64().getEventScheduler();
        ctx.scheduleThreadSafe(Event.of("Update Play Timer!", event -> this.util.getPlayer().getTimer().updateEnd(this.util.getPlayer().getTune())));
    }

    @FXML
    private void doBrowse() {
        FileChooser fileDialog = new FileChooser();
        FileChooser.ExtensionFilter extFilter = new FileChooser.ExtensionFilter("MP3 Tunes", MP3TuneFileExtensions.EXTENSIONS);
        fileDialog.getExtensionFilters().add((Object)extFilter);
        File file = fileDialog.showOpenDialog(this.getScene().getWindow());
        if (file != null) {
            this.util.getConfig().getAudioSection().setMp3(file);
            if (this.util.getPlayer().getTune() instanceof MP3Tune) {
                this.util.getPlayer().setTune(SidTune.RESET);
            }
            this.restart();
        }
    }

    @FXML
    private void showVolume() {
        OS os = OS.get();
        if (os == OS.WINDOWS) {
            SidPlay2Section section = this.util.getConfig().getSidplay2Section();
            int x = (int)(section.getFrameX() + section.getFrameWidth() / 2.0);
            try {
                Runtime.getRuntime().exec(new String[]{"sndvol", "-f", String.valueOf(x)}, null, null);
            }
            catch (IOException e) {
                String toolTip = "For Windows: sndvol not found!";
                this.volumeButton.setDisable(true);
                this.volumeButton.setTooltip(new Tooltip(toolTip));
                System.err.println(toolTip);
            }
        } else if (os == OS.LINUX) {
            try {
                Runtime.getRuntime().exec(new String[]{"pavucontrol"}, null, null);
            }
            catch (IOException e2) {
                try {
                    Runtime.getRuntime().exec(new String[]{"kmix"}, null, null);
                }
                catch (IOException e3) {
                    String toolTip = "For Linux: pavucontrol(PulseAudio) or kmix(ALSA) not found!";
                    this.volumeButton.setDisable(true);
                    this.volumeButton.setTooltip(new Tooltip(toolTip));
                    System.err.println(toolTip);
                }
            }
        } else if (os == OS.MAC || os == OS.OTHER) {
            String toolTip = "For " + (Object)((Object)os) + ": N.Y.I!";
            this.volumeButton.setDisable(true);
            this.volumeButton.setTooltip(new Tooltip(toolTip));
            System.err.println(toolTip);
        }
    }

    @FXML
    private void setVideoStandard() {
        this.restart();
    }

    @Override
    public void doClose() {
        this.util.getPlayer().stateProperty().removeListener(this.propertyChangeListener);
        this.stopAppServer();
    }

    private void disable(Node n, boolean disable) {
        n.setDisable(disable);
        if (n instanceof Parent) {
            for (Node c : ((Parent)n).getChildrenUnmodifiable()) {
                this.disable(c, disable);
            }
        }
    }

    private void addSidBlasterDeviceMapping(DeviceMapping deviceMapping) {
        SidBlasterDeviceMapping sidBlasterDeviceMapping = new SidBlasterDeviceMapping(this.util.getWindow(), this.util.getPlayer());
        sidBlasterDeviceMapping.init(deviceMapping, this::testSidBlasterDevice, this::removeSidBlasterDeviceMapping, this.testButtonGroup);
        this.sidBlasterDeviceParent.getChildren().add((Object)sidBlasterDeviceMapping);
        Platform.runLater(() -> {
            this.sidBlasterDeviceParent.requestLayout();
            Platform.runLater(() -> this.sidBlasterScrollPane.setVvalue(1.0));
        });
    }

    private void removeSidBlasterDeviceMapping(DeviceMapping deviceMapping) {
        EmulationSection emulationSection = this.util.getConfig().getEmulationSection();
        this.sidBlasterDeviceParent.getChildren().remove(emulationSection.getSidBlasterDeviceList().indexOf(deviceMapping));
        emulationSection.getSidBlasterDeviceList().remove(deviceMapping);
    }

    private void testSidBlasterDevice(DeviceMapping deviceMapping, Boolean isSelected) {
        try {
            if (this.testPlayer == null) {
                this.testPlayer = new Player(new IniConfig());
                this.testPlayer.getConfig().getEmulationSection().setEngine(Engine.SIDBLASTER);
            } else {
                this.testPlayer.stopC64();
            }
            if (JSIDBlasterBuilder.getSerialNumbers() == null) {
                this.triggerFetchSerialNumbers();
            }
            if (isSelected.booleanValue()) {
                this.util.getPlayer().stopC64(true);
                this.setActiveSidBlasterDevice(serial -> Objects.equals(deviceMapping.getSerialNum(), serial));
                this.testPlayer.getConfig().getEmulationSection().setSidBlasterSerialNumber(deviceMapping.getSerialNum());
                this.testPlayer.play(SidTune.load("sidblaster_test.sid", ToolBar.class.getResourceAsStream(SIDBLASTER_TEST_SID)));
            }
        }
        catch (IOException | SidTuneError e) {
            this.openErrorDialog(e.getMessage());
        }
    }

    private void triggerFetchSerialNumbers() {
        new JSIDBlasterBuilder(null, this.util.getConfig(), null);
    }

    private void setActiveSidBlasterDevices(Mixer mixer) {
        ArrayList<String> serialNumbers = new ArrayList<String>();
        if (mixer instanceof JSIDBlasterBuilder) {
            JSIDBlasterBuilder sidBlasterBuilder = (JSIDBlasterBuilder)mixer;
            for (int sidNum = 0; sidNum < ISidPlay2SystemProperties.MAX_SIDS; ++sidNum) {
                serialNumbers.add(sidBlasterBuilder.getDeviceName(sidNum));
            }
        }
        this.setActiveSidBlasterDevice(serialNoOfDevice -> serialNumbers.contains(serialNoOfDevice));
    }

    private void setActiveSidBlasterDevice(Predicate<String> serialNoSelector) {
        for (Node node : this.sidBlasterDeviceParent.getChildren()) {
            SidBlasterDeviceMapping sidBlasterDeviceMapping = (SidBlasterDeviceMapping)node;
            String serialNoOfDevice = sidBlasterDeviceMapping.getSerialNo();
            node.getStyleClass().remove((Object)"active");
            if (!serialNoSelector.test(serialNoOfDevice)) continue;
            node.getStyleClass().add((Object)"active");
        }
    }

    private String getHostname() {
        try {
            Process proc = Runtime.getRuntime().exec(new String[]{"hostname"}, null, null);
            return IOUtils.convertStreamToString(proc.getInputStream(), StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            return "?hostname?";
        }
    }

    private String getIpAddresses() {
        try {
            return Collections.list(NetworkInterface.getNetworkInterfaces()).stream().flatMap(iface -> Collections.list(iface.getInetAddresses()).stream()).filter(address -> !address.isLoopbackAddress() && address.isSiteLocalAddress()).map(address -> address.getHostAddress()).collect(Collectors.joining("\n"));
        }
        catch (SocketException ex) {
            return "?ip?";
        }
    }

    private void openErrorDialog(String msg) {
        Alert alert = new Alert(Alert.AlertType.ERROR, msg, new ButtonType[0]);
        alert.setTitle(this.util.getBundle().getString("ALERT_TITLE"));
        alert.showAndWait();
    }

    private void restart() {
        if (!this.duringInitialization && !this.duringReplay && this.util.getPlayer().stateProperty().get() != State.RESTART) {
            this.util.getPlayer().play(this.util.getPlayer().getTune());
        }
        this.duringReplay = false;
    }

    private class StateChangeListener
    implements PropertyChangeListener {
        private StateChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent event) {
            Platform.runLater(() -> {
                if (event.getNewValue() == State.OPEN) {
                    if (ToolBar.this.testPlayer != null) {
                        ToolBar.this.testPlayer.stopC64();
                    }
                } else if (event.getNewValue() == State.START) {
                    ToolBar.this.util.getPlayer().configureMixer(mixer -> Platform.runLater(() -> ToolBar.this.setActiveSidBlasterDevices(mixer)));
                }
            });
        }
    }
}

