/*
 * Decompiled with CFR 0.152.
 */
package libsidplay.components.mos656x;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import libsidplay.common.VICChipModel;
import libsidplay.components.mos656x.IPALEmulation;
import libsidplay.components.mos656x.IPalette;
import libsidplay.components.mos656x.Palette;

public class PALEmulation
implements IPALEmulation {
    public static final IPALEmulation NONE = null;
    private static final int ALPHA = -16777216;
    private final int[] vicPaletteNoPal = new int[]{0, 0xFFFFFF, 6829867, 7382194, 7290246, 5803331, 3483769, 12109679, 7294757, 4405504, 10119001, 0x444444, 0x6C6C6C, 10146436, 7102133, 0x959595};
    private final int[] combinedLinesEven = new int[65536];
    private final int[] combinedLinesOdd = new int[65536];
    private final byte[] linePaletteEven = new byte[65536];
    private final byte[] linePaletteOdd = new byte[65536];
    private final byte[] previousLineDecodedColor = new byte[520];
    private int[] combinedLinesCurrent;
    private byte[] linePaletteCurrent;
    private int previousLineIndex;
    private int oldGraphicsData;
    private final VICChipModel model;
    private boolean palEmulationEnable;
    private final Palette palette = new Palette();
    protected final ByteBuffer pixels = ByteBuffer.allocate(479232).order(ByteOrder.LITTLE_ENDIAN);

    public PALEmulation(VICChipModel model) {
        this.model = model;
        this.palEmulationEnable = true;
    }

    @Override
    public void setPalEmulationEnable(boolean palEmulationEnable) {
        this.palEmulationEnable = palEmulationEnable;
    }

    @Override
    public void setVicPaletteNoPal(int[] vicPaletteNoPal) {
        assert (vicPaletteNoPal.length == 16);
        System.arraycopy(vicPaletteNoPal, 0, this.vicPaletteNoPal, 0, vicPaletteNoPal.length);
    }

    @Override
    public IPalette getPalette() {
        return this.palette;
    }

    @Override
    public void updatePalette() {
        this.palette.calculatePalette(Palette.buildPaletteVariant(this.model));
        System.arraycopy(this.palette.getEvenLines(), 0, this.combinedLinesEven, 0, this.combinedLinesEven.length);
        System.arraycopy(this.palette.getOddLines(), 0, this.combinedLinesOdd, 0, this.combinedLinesOdd.length);
        System.arraycopy(this.palette.getEvenFiltered(), 0, this.linePaletteEven, 0, this.linePaletteEven.length);
        System.arraycopy(this.palette.getOddFiltered(), 0, this.linePaletteOdd, 0, this.linePaletteOdd.length);
    }

    @Override
    public void determineCurrentPalette(int rasterY, boolean isFrameStart) {
        if (isFrameStart) {
            ((Buffer)this.pixels).clear();
            this.linePaletteCurrent = (rasterY & 1) != 0 ? this.linePaletteEven : this.linePaletteOdd;
            this.combinedLinesCurrent = (rasterY & 1) != 0 ? this.combinedLinesEven : this.combinedLinesOdd;
            for (int i = 0; i < this.previousLineDecodedColor.length; ++i) {
                this.previousLineDecodedColor[i] = this.linePaletteCurrent[0];
            }
        }
        this.linePaletteCurrent = this.linePaletteCurrent == this.linePaletteOdd ? this.linePaletteEven : this.linePaletteOdd;
        this.combinedLinesCurrent = this.combinedLinesCurrent == this.combinedLinesOdd ? this.combinedLinesEven : this.combinedLinesOdd;
        this.oldGraphicsData = 0;
        this.previousLineIndex = 0;
    }

    @Override
    public void drawPixels(int graphicsDataBuffer) {
        for (int j = 0; j < 2; ++j) {
            this.oldGraphicsData |= graphicsDataBuffer >>> 16;
            for (int i = 0; i < 4; ++i) {
                this.oldGraphicsData <<= 4;
                int vicColor = this.oldGraphicsData >>> 16;
                byte lineColor = this.linePaletteCurrent[vicColor];
                byte previousLineColor = this.previousLineDecodedColor[this.previousLineIndex];
                int rgbaColor = this.palEmulationEnable ? 0xFF000000 | this.combinedLinesCurrent[lineColor & 0xFF | previousLineColor << 8 & 0xFF00] : 0xFF000000 | this.vicPaletteNoPal[vicColor & 0xF];
                this.pixels.putInt(rgbaColor);
                this.previousLineDecodedColor[this.previousLineIndex++] = lineColor;
            }
            graphicsDataBuffer <<= 16;
        }
    }

    @Override
    public ByteBuffer getPixels() {
        return this.pixels;
    }

    @Override
    public void reset() {
        ((Buffer)this.pixels).clear();
        for (int i = 0; i < this.pixels.capacity() >> 2; ++i) {
            this.pixels.putInt(-16777216);
        }
        ((Buffer)this.pixels).clear();
    }
}

