/*
 * Decompiled with CFR 0.152.
 */
package kickass.parsing.preprocessor;

import java.util.HashSet;
import java.util.Set;
import java.util.Stack;
import kickass.common.syntaxinfo.SyntaxInfo;
import kickass.common.syntaxinfo.SyntaxType;
import kickass.parsing.preprocessor.IfEntry;
import kickass.parsing.preprocessor.IfState;
import kickass.parsing.sourcelocation.SourceRange;
import kickass.state.EvaluationState;

public class PreprocessorManager {
    private Stack<IfEntry> ifStack = new Stack();
    private Set<String> definedSymbols = new HashSet<String>();
    private EvaluationState state;
    private boolean functionMode = false;

    public PreprocessorManager(EvaluationState evaluationState) {
        this.state = evaluationState;
    }

    public Set<String> getDefinedSymbols() {
        return this.definedSymbols;
    }

    public IfState popState(SourceRange sourceRange) {
        int n;
        int n2;
        boolean bl;
        if (this.ifStack.isEmpty()) {
            return null;
        }
        IfEntry ifEntry = this.ifStack.pop();
        IfState ifState = ifEntry.getState();
        boolean bl2 = bl = ifState.isPassiveState() && !this.isInPassiveState();
        if (bl && (n2 = ifEntry.getDirectiveRange().getStartLineNo() + 1) < (n = sourceRange.getStartLineNo())) {
            SourceRange sourceRange2 = new SourceRange(n2, 0, n, 0, sourceRange.getFileName());
            this.state.syntaxInfoMgr.add(new SyntaxInfo(SyntaxType.ppDisabledCode, sourceRange2));
        }
        return ifState;
    }

    public void pushState(IfState ifState, SourceRange sourceRange) {
        this.ifStack.push(new IfEntry(ifState, sourceRange));
    }

    public boolean isInPassiveState() {
        if (this.ifStack.isEmpty()) {
            return false;
        }
        return this.ifStack.peek().getState().isPassiveState();
    }

    public boolean getFunctionMode() {
        return this.functionMode;
    }

    public void setFunctionMode(boolean bl) {
        this.functionMode = bl;
    }

    public boolean replaceFunctionMode(boolean bl) {
        boolean bl2 = this.functionMode;
        this.functionMode = bl;
        return bl2;
    }
}

