/*
 * Decompiled with CFR 0.152.
 */
package libsidplay.sidtune;

import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import libsidplay.sidtune.Prg;
import libsidplay.sidtune.SidTune;
import libsidplay.sidtune.SidTuneError;
import libsidutils.CBMCodeUtils;
import libsidutils.IOUtils;

public class T64
extends Prg {
    public static final byte BITMASK_FILETYPE = 7;
    public static final byte FILETYPE_PRG = 2;

    protected static SidTune load(String name, byte[] dataBuf) throws SidTuneError {
        if (!IOUtils.getFilenameSuffix(name).equalsIgnoreCase(".t64")) {
            throw new SidTuneError("T64: Bad file extension expected: .t64");
        }
        T64 t64 = new T64();
        T64Entry entry = t64.getEntry(dataBuf, 1);
        t64.program = dataBuf;
        t64.programOffset = entry.programOffset;
        t64.info.loadAddr = entry.loadAddr;
        t64.info.c64dataLen = Math.min(entry.c64dataLen, dataBuf.length - t64.programOffset);
        String credit = CBMCodeUtils.petsciiToIso88591(entry.name);
        t64.info.infoString.add(credit);
        return t64;
    }

    public T64Entry getEntry(byte[] dataBuf, int entryNum) throws SidTuneError {
        int totalEntries = (dataBuf[35] & 0xFF) << 8 | dataBuf[34] & 0xFF;
        if (entryNum < 1 || entryNum > totalEntries) {
            throw new SidTuneError("T64: Illegal T64 entry number: " + entryNum + ", must be 1.." + totalEntries);
        }
        int pos = 32 + 32 * entryNum;
        byte type = dataBuf[pos++];
        byte fileType = dataBuf[pos++];
        if (pos + 32 > dataBuf.length || type != 1 && (fileType & 7) != 2) {
            throw new SidTuneError("T64: Illegal T64 entry type, must be PRG normal tape file");
        }
        T64Entry entry = new T64Entry();
        entry.loadAddr = (dataBuf[pos++] & 0xFF) + ((dataBuf[pos++] & 0xFF) << 8);
        entry.c64dataLen = (dataBuf[pos++] & 0xFF) + ((dataBuf[pos++] & 0xFF) << 8);
        entry.c64dataLen -= entry.loadAddr;
        pos += 2;
        entry.programOffset = 0;
        for (int i = 0; i <= 3; ++i) {
            entry.programOffset += (dataBuf[pos++] & 0xFF) << 8 * i;
        }
        entry.name = new byte[16];
        System.arraycopy(dataBuf, pos += 4, entry.name, 0, entry.name.length);
        return entry;
    }

    public void save(File file, byte[] program, int programOffset, int c64dataLen, int loadAddr) throws IOException {
        try (DataOutputStream dout = new DataOutputStream(new FileOutputStream(file));){
            dout.writeByte(loadAddr & 0xFF);
            dout.writeByte(loadAddr >> 8 & 0xFF);
            dout.write(program, programOffset, c64dataLen);
        }
    }

    public static final class T64Entry {
        public int programOffset;
        public int loadAddr;
        public int c64dataLen;
        public byte[] name;
    }
}

