/*
 * Decompiled with CFR 0.152.
 */
package net.java.truecommons.io;

import edu.umd.cs.findbugs.annotations.DischargesObligation;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.WillCloseWhenClosed;

public abstract class DecoratingInputStream
extends InputStream {
    @Nullable
    @WillCloseWhenClosed
    protected InputStream in;

    protected DecoratingInputStream() {
    }

    protected DecoratingInputStream(@WillCloseWhenClosed InputStream in) {
        this.in = Objects.requireNonNull(in);
    }

    @Override
    public int read() throws IOException {
        return this.in.read();
    }

    @Override
    public final int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        return this.in.read(b, off, len);
    }

    @Override
    public long skip(long n) throws IOException {
        return this.in.skip(n);
    }

    @Override
    public int available() throws IOException {
        return this.in.available();
    }

    @Override
    public void mark(int readlimit) {
        this.in.mark(readlimit);
    }

    @Override
    public void reset() throws IOException {
        this.in.reset();
    }

    @Override
    public boolean markSupported() {
        return this.in.markSupported();
    }

    @Override
    @DischargesObligation
    public void close() throws IOException {
        this.in.close();
    }

    public String toString() {
        return String.format("%s[in=%s]", this.getClass().getName(), this.in);
    }
}

