/*
 * Decompiled with CFR 0.152.
 */
package mpg;

import mpg.DCT64;
import mpg.MPGLib;
import mpg.TabInit;

public class Decode {
    private TabInit tab = new TabInit();
    private DCT64 dct64 = new DCT64();

    private int writeSampleClipped(float sum, int clip, float[] out, int outPos) {
        if ((double)sum > 32767.0) {
            out[outPos] = 32767.0f;
            ++clip;
        } else if ((double)sum < -32768.0) {
            out[outPos] = -32768.0f;
            ++clip;
        } else {
            out[outPos] = (int)(sum > 0.0f ? (double)sum + 0.5 : (double)sum - 0.5);
        }
        return clip;
    }

    private void writeSampleUnclipped(float sum, float[] out, int outPos) {
        out[outPos] = sum;
    }

    int synth1to1mono(MPGLib.mpstr_tag mp, float[] bandPtr, int bandPos, float[] out, MPGLib.ProcessedBytes pnt) {
        float[] samples = new float[64];
        int clip = this.synth_1to1(mp, bandPtr, bandPos, 0, samples, new MPGLib.ProcessedBytes());
        for (int i = 0; i < samples.length; i += 2) {
            out[pnt.pb++] = samples[i];
        }
        return clip;
    }

    void synth1to1monoUnclipped(MPGLib.mpstr_tag mp, float[] bandPtr, int bandPos, float[] out, MPGLib.ProcessedBytes pnt) {
        float[] samples = new float[64];
        this.synth_1to1_unclipped(mp, bandPtr, bandPos, 0, samples, new MPGLib.ProcessedBytes());
        for (int i = 0; i < samples.length; i += 2) {
            out[pnt.pb++] = samples[i];
        }
    }

    int synth_1to1(MPGLib.mpstr_tag mp, float[] bandPtr, int bandPos, int ch, float[] out, MPGLib.ProcessedBytes pnt) {
        float sum;
        float[] bufs;
        int bo1;
        float[] b0;
        int clip = 0;
        if (0 == ch) {
            --mp.synth_bo;
            mp.synth_bo &= 0xF;
        } else {
            ++pnt.pb;
        }
        if ((mp.synth_bo & 1) != 0) {
            b0 = mp.synth_buffs[ch][0];
            bo1 = mp.synth_bo;
            bufs = new float[64];
            this.dct64.dct64_1(mp.synth_buffs[ch][1], mp.synth_bo + 1 & 0xF, mp.synth_buffs[ch][0], mp.synth_bo, bufs, 32, bandPtr, bandPos, this.tab.pnts);
        } else {
            b0 = mp.synth_buffs[ch][1];
            bo1 = mp.synth_bo + 1;
            bufs = new float[64];
            this.dct64.dct64_1(mp.synth_buffs[ch][0], mp.synth_bo, mp.synth_buffs[ch][1], mp.synth_bo + 1, bufs, 32, bandPtr, bandPos, this.tab.pnts);
        }
        int window = 16 - bo1;
        int b0Pos = 0;
        int j = 16;
        while (j != 0) {
            sum = this.tab.decwin[window + 0] * b0[b0Pos + 0];
            sum -= this.tab.decwin[window + 1] * b0[b0Pos + 1];
            sum += this.tab.decwin[window + 2] * b0[b0Pos + 2];
            sum -= this.tab.decwin[window + 3] * b0[b0Pos + 3];
            sum += this.tab.decwin[window + 4] * b0[b0Pos + 4];
            sum -= this.tab.decwin[window + 5] * b0[b0Pos + 5];
            sum += this.tab.decwin[window + 6] * b0[b0Pos + 6];
            sum -= this.tab.decwin[window + 7] * b0[b0Pos + 7];
            sum += this.tab.decwin[window + 8] * b0[b0Pos + 8];
            sum -= this.tab.decwin[window + 9] * b0[b0Pos + 9];
            sum += this.tab.decwin[window + 10] * b0[b0Pos + 10];
            sum -= this.tab.decwin[window + 11] * b0[b0Pos + 11];
            sum += this.tab.decwin[window + 12] * b0[b0Pos + 12];
            sum -= this.tab.decwin[window + 13] * b0[b0Pos + 13];
            sum += this.tab.decwin[window + 14] * b0[b0Pos + 14];
            clip = this.writeSampleClipped(sum -= this.tab.decwin[window + 15] * b0[b0Pos + 15], clip, out, pnt.pb);
            --j;
            b0Pos += 16;
            window += 32;
            pnt.pb += 2;
        }
        float sum2 = this.tab.decwin[window + 0] * b0[b0Pos + 0];
        sum2 += this.tab.decwin[window + 2] * b0[b0Pos + 2];
        sum2 += this.tab.decwin[window + 4] * b0[b0Pos + 4];
        sum2 += this.tab.decwin[window + 6] * b0[b0Pos + 6];
        sum2 += this.tab.decwin[window + 8] * b0[b0Pos + 8];
        sum2 += this.tab.decwin[window + 10] * b0[b0Pos + 10];
        sum2 += this.tab.decwin[window + 12] * b0[b0Pos + 12];
        clip = this.writeSampleClipped(sum2 += this.tab.decwin[window + 14] * b0[b0Pos + 14], clip, out, pnt.pb);
        b0Pos -= 16;
        window -= 32;
        pnt.pb += 2;
        window += bo1 << 1;
        j = 15;
        while (j != 0) {
            sum = -this.tab.decwin[window + -1] * b0[b0Pos + 0];
            sum -= this.tab.decwin[window + -2] * b0[b0Pos + 1];
            sum -= this.tab.decwin[window + -3] * b0[b0Pos + 2];
            sum -= this.tab.decwin[window + -4] * b0[b0Pos + 3];
            sum -= this.tab.decwin[window + -5] * b0[b0Pos + 4];
            sum -= this.tab.decwin[window + -6] * b0[b0Pos + 5];
            sum -= this.tab.decwin[window + -7] * b0[b0Pos + 6];
            sum -= this.tab.decwin[window + -8] * b0[b0Pos + 7];
            sum -= this.tab.decwin[window + -9] * b0[b0Pos + 8];
            sum -= this.tab.decwin[window + -10] * b0[b0Pos + 9];
            sum -= this.tab.decwin[window + -11] * b0[b0Pos + 10];
            sum -= this.tab.decwin[window + -12] * b0[b0Pos + 11];
            sum -= this.tab.decwin[window + -13] * b0[b0Pos + 12];
            sum -= this.tab.decwin[window + -14] * b0[b0Pos + 13];
            sum -= this.tab.decwin[window + -15] * b0[b0Pos + 14];
            clip = this.writeSampleClipped(sum -= this.tab.decwin[window + 0] * b0[b0Pos + 15], clip, out, pnt.pb);
            --j;
            b0Pos -= 16;
            window -= 32;
            pnt.pb += 2;
        }
        if (ch == 1) {
            --pnt.pb;
        }
        return clip;
    }

    void synth_1to1_unclipped(MPGLib.mpstr_tag mp, float[] bandPtr, int bandPos, int ch, float[] out, MPGLib.ProcessedBytes pnt) {
        float sum;
        float[] bufs;
        int bo1;
        float[] b0;
        if (0 == ch) {
            --mp.synth_bo;
            mp.synth_bo &= 0xF;
        } else {
            ++pnt.pb;
        }
        if ((mp.synth_bo & 1) != 0) {
            b0 = mp.synth_buffs[ch][0];
            bo1 = mp.synth_bo;
            bufs = new float[64];
            this.dct64.dct64_1(mp.synth_buffs[ch][1], mp.synth_bo + 1 & 0xF, mp.synth_buffs[ch][0], mp.synth_bo, bufs, 32, bandPtr, bandPos, this.tab.pnts);
        } else {
            b0 = mp.synth_buffs[ch][1];
            bo1 = mp.synth_bo + 1;
            bufs = new float[64];
            this.dct64.dct64_1(mp.synth_buffs[ch][0], mp.synth_bo, mp.synth_buffs[ch][1], mp.synth_bo + 1, bufs, 32, bandPtr, bandPos, this.tab.pnts);
        }
        int window = 16 - bo1;
        int b0Pos = 0;
        int j = 16;
        while (j != 0) {
            sum = this.tab.decwin[window + 0] * b0[b0Pos + 0];
            sum -= this.tab.decwin[window + 1] * b0[b0Pos + 1];
            sum += this.tab.decwin[window + 2] * b0[b0Pos + 2];
            sum -= this.tab.decwin[window + 3] * b0[b0Pos + 3];
            sum += this.tab.decwin[window + 4] * b0[b0Pos + 4];
            sum -= this.tab.decwin[window + 5] * b0[b0Pos + 5];
            sum += this.tab.decwin[window + 6] * b0[b0Pos + 6];
            sum -= this.tab.decwin[window + 7] * b0[b0Pos + 7];
            sum += this.tab.decwin[window + 8] * b0[b0Pos + 8];
            sum -= this.tab.decwin[window + 9] * b0[b0Pos + 9];
            sum += this.tab.decwin[window + 10] * b0[b0Pos + 10];
            sum -= this.tab.decwin[window + 11] * b0[b0Pos + 11];
            sum += this.tab.decwin[window + 12] * b0[b0Pos + 12];
            sum -= this.tab.decwin[window + 13] * b0[b0Pos + 13];
            sum += this.tab.decwin[window + 14] * b0[b0Pos + 14];
            this.writeSampleUnclipped(sum -= this.tab.decwin[window + 15] * b0[b0Pos + 15], out, pnt.pb);
            --j;
            b0Pos += 16;
            window += 32;
            pnt.pb += 2;
        }
        float sum2 = this.tab.decwin[window + 0] * b0[b0Pos + 0];
        sum2 += this.tab.decwin[window + 2] * b0[b0Pos + 2];
        sum2 += this.tab.decwin[window + 4] * b0[b0Pos + 4];
        sum2 += this.tab.decwin[window + 6] * b0[b0Pos + 6];
        sum2 += this.tab.decwin[window + 8] * b0[b0Pos + 8];
        sum2 += this.tab.decwin[window + 10] * b0[b0Pos + 10];
        sum2 += this.tab.decwin[window + 12] * b0[b0Pos + 12];
        this.writeSampleUnclipped(sum2 += this.tab.decwin[window + 14] * b0[b0Pos + 14], out, pnt.pb);
        b0Pos -= 16;
        window -= 32;
        pnt.pb += 2;
        window += bo1 << 1;
        j = 15;
        while (j != 0) {
            sum = -this.tab.decwin[window + -1] * b0[b0Pos + 0];
            sum -= this.tab.decwin[window + -2] * b0[b0Pos + 1];
            sum -= this.tab.decwin[window + -3] * b0[b0Pos + 2];
            sum -= this.tab.decwin[window + -4] * b0[b0Pos + 3];
            sum -= this.tab.decwin[window + -5] * b0[b0Pos + 4];
            sum -= this.tab.decwin[window + -6] * b0[b0Pos + 5];
            sum -= this.tab.decwin[window + -7] * b0[b0Pos + 6];
            sum -= this.tab.decwin[window + -8] * b0[b0Pos + 7];
            sum -= this.tab.decwin[window + -9] * b0[b0Pos + 8];
            sum -= this.tab.decwin[window + -10] * b0[b0Pos + 9];
            sum -= this.tab.decwin[window + -11] * b0[b0Pos + 10];
            sum -= this.tab.decwin[window + -12] * b0[b0Pos + 11];
            sum -= this.tab.decwin[window + -13] * b0[b0Pos + 12];
            sum -= this.tab.decwin[window + -14] * b0[b0Pos + 13];
            sum -= this.tab.decwin[window + -15] * b0[b0Pos + 14];
            this.writeSampleUnclipped(sum -= this.tab.decwin[window + 0] * b0[b0Pos + 15], out, pnt.pb);
            --j;
            b0Pos -= 16;
            window -= 32;
            pnt.pb += 2;
        }
        if (ch == 1) {
            --pnt.pb;
        }
    }
}

