/*
 * Decompiled with CFR 0.152.
 */
package client.teavm.common;

import client.teavm.common.ILogger;
import java.util.Arrays;
import java.util.ListIterator;

public class MainArgs {
    private boolean shared;
    private int verbose;
    private boolean quiet;
    private boolean debug;

    public boolean isShared() {
        return this.shared;
    }

    public void setShared(boolean shared) {
        this.shared = shared;
    }

    public int getVerbose() {
        return this.verbose;
    }

    public void setVerbose(int verbose) {
        this.verbose = verbose;
    }

    public boolean isQuiet() {
        return this.quiet;
    }

    public void setQuiet(boolean quiet) {
        this.quiet = quiet;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public MainArgs(ILogger LOG, String[] args) {
        try {
            ListIterator<String> argsIt = Arrays.asList(args).listIterator();
            block16: while (argsIt.hasNext()) {
                String arg;
                switch (arg = argsIt.next()) {
                    case "--shared": {
                        this.setShared(Boolean.parseBoolean(argsIt.next()));
                        continue block16;
                    }
                    case "--verbose": {
                        this.setVerbose(Integer.parseInt(argsIt.next()));
                        continue block16;
                    }
                    case "--quiet": {
                        this.setQuiet(Boolean.parseBoolean(argsIt.next()));
                        continue block16;
                    }
                    case "--debug": {
                        this.setDebug(Boolean.parseBoolean(argsIt.next()));
                        continue block16;
                    }
                    case "--help": {
                        throw new IllegalArgumentException((String)null);
                    }
                }
                throw new IllegalArgumentException("Error! Illegal argument: " + arg);
            }
        }
        catch (Exception e) {
            if (e.getMessage() != null) {
                LOG.severe(e.getMessage());
                LOG.severe("");
            }
            LOG.info("Usage:");
            LOG.info("--help\t\t\t\t: Display usage");
            LOG.info("--verbose\t0..2\t\t: Verbosity (level=0,1,2)");
            LOG.info("--quiet\ttrue | false\t\t: Quiet (no output)");
            LOG.info("--debug\ttrue | false\t\t: Enable/Disable additional debug messages");
        }
    }
}

