/*
 * Decompiled with CFR 0.152.
 */
package mp3;

import mp3.GrInfo;
import mp3.IIISideInfo;
import mp3.III_psy_ratio;
import mp3.IIterationLoop;
import mp3.LameGlobalFlags;
import mp3.LameInternalFlags;
import mp3.MeanBits;
import mp3.Quantize;

public final class ABRIterationLoop
implements IIterationLoop {
    private final Quantize quantize;

    ABRIterationLoop(Quantize quantize) {
        this.quantize = quantize;
    }

    @Override
    public final void iteration_loop(LameGlobalFlags gfp, float[][] pe, float[] ms_ener_ratio, III_psy_ratio[][] ratio) {
        LameInternalFlags gfc = gfp.internal_flags;
        float[] l3_xmin = new float[39];
        float[] xrpow = new float[576];
        int[][] targ_bits = new int[2][2];
        int[] max_frame_bits = new int[1];
        int[] analog_silence_bits = new int[1];
        IIISideInfo l3_side = gfc.l3_side;
        int mean_bits = 0;
        this.quantize.calc_target_bits(gfp, pe, ms_ener_ratio, targ_bits, analog_silence_bits, max_frame_bits);
        for (int gr = 0; gr < gfc.mode_gr; ++gr) {
            if (gfc.mode_ext == 2) {
                this.quantize.ms_convert(gfc.l3_side, gr);
            }
            for (int ch = 0; ch < gfc.channels_out; ++ch) {
                float masking_lower_db;
                float adjust;
                GrInfo cod_info = l3_side.tt[gr][ch];
                if (cod_info.block_type != 2) {
                    adjust = 0.0f;
                    masking_lower_db = gfc.PSY.mask_adjust - adjust;
                } else {
                    adjust = 0.0f;
                    masking_lower_db = gfc.PSY.mask_adjust_short - adjust;
                }
                gfc.masking_lower = (float)Math.pow(10.0, (double)masking_lower_db * 0.1);
                this.quantize.init_outer_loop(gfc, cod_info);
                if (this.quantize.init_xrpow(gfc, cod_info, xrpow)) {
                    int ath_over = this.quantize.qupvt.calc_xmin(gfp, ratio[gr][ch], cod_info, l3_xmin);
                    if (0 == ath_over) {
                        targ_bits[gr][ch] = analog_silence_bits[0];
                    }
                    this.quantize.outer_loop(gfp, cod_info, l3_xmin, xrpow, ch, targ_bits[gr][ch]);
                }
                this.quantize.iteration_finish_one(gfc, gr, ch);
            }
        }
        gfc.bitrate_index = gfc.VBR_min_bitrate;
        while (gfc.bitrate_index <= gfc.VBR_max_bitrate) {
            MeanBits mb = new MeanBits(mean_bits);
            int rc = this.quantize.rv.ResvFrameBegin(gfp, mb);
            mean_bits = mb.bits;
            if (rc >= 0) break;
            ++gfc.bitrate_index;
        }
        assert (gfc.bitrate_index <= gfc.VBR_max_bitrate);
        this.quantize.rv.ResvFrameEnd(gfc, mean_bits);
    }
}

