/*
 * Decompiled with CFR 0.152.
 */
package kickass.pass.asmnode.metanodes;

import java.util.List;
import kickass.common.exceptions.ShouldNotBeHereException;
import kickass.nonasm.tools.tuples.Triple;
import kickass.parsing.sourcelocation.SourceRange;
import kickass.pass.asmnode.AsmNode;
import kickass.pass.asmnode.output.reciever.IOutputReciever;
import kickass.pass.asmnode.output.reciever.OutputStreamType;
import kickass.pass.expressions.expr.ExprNode;
import kickass.pass.valueholder.IValueHolder;
import kickass.pass.values.Value;
import kickass.state.EvaluationState;
import kickass.state.FunctionSideOutput;
import kickass.state.namespace.Namespace;
import kickass.state.scope.symboltable.ISymbolPageIdx;
import kickass.state.scope.symboltable.SymbolTable;

public class MacroInstanceRootNode
extends AsmNode {
    private AsmNode body;
    private SymbolTable symbolTable;
    private ISymbolPageIdx[] argSymbolIdxs;
    private List<ExprNode> argumentExprs;
    private Namespace definitionNamespace;
    private Value defaultArgValue;
    private SourceRange callRange;
    private IValueHolder[] symbolPage;
    private Value[] argumentValues;
    private FunctionSideOutput[] sideOutput;

    public MacroInstanceRootNode(AsmNode asmNode, SymbolTable symbolTable, ISymbolPageIdx[] iSymbolPageIdxArray, IValueHolder[] iValueHolderArray, Namespace namespace, List<ExprNode> list, Value value, SourceRange sourceRange) {
        this.body = asmNode;
        this.symbolTable = symbolTable;
        this.argSymbolIdxs = iSymbolPageIdxArray;
        this.argumentExprs = list;
        this.defaultArgValue = value;
        this.symbolPage = iValueHolderArray;
        this.definitionNamespace = namespace;
        this.callRange = sourceRange;
        this.argumentValues = new Value[iSymbolPageIdxArray.length];
        this.sideOutput = new FunctionSideOutput[iSymbolPageIdxArray.length];
    }

    public void setArgumentValues(Value[] valueArray) {
        this.argumentValues = valueArray;
    }

    public IValueHolder[] getPage() {
        return this.symbolPage;
    }

    @Override
    public AsmNode copy() {
        throw new ShouldNotBeHereException();
    }

    @Override
    public AsmNode executeMetaRegistrations(EvaluationState evaluationState) {
        throw new ShouldNotBeHereException();
    }

    @Override
    public AsmNode executePrepass(EvaluationState evaluationState) {
        throw new ShouldNotBeHereException();
    }

    @Override
    public AsmNode executePass(EvaluationState evaluationState) {
        IValueHolder[] iValueHolderArray = this.symbolTable.getCurrentPage();
        for (int i = 0; i < this.argSymbolIdxs.length; ++i) {
            Value value = this.argumentValues[i];
            if (value != null) {
                this.parseSideOutput(this.sideOutput[i], evaluationState);
            } else {
                boolean bl;
                evaluationState.sideeffectMgr.clearFunctionSideOutput();
                value = this.argumentExprs.size() <= i ? this.defaultArgValue : this.argumentExprs.get(i).evaluate(evaluationState);
                boolean bl2 = bl = !evaluationState.sideeffectMgr.getErrorOrInvalidSideEffectsDuringFunctionEvaluation();
                if (bl && value.isLocked() && !value.isInvalidOrInvalidContent()) {
                    this.argumentValues[i] = value;
                    this.sideOutput[i] = evaluationState.sideeffectMgr.getFunctionSideOutput();
                }
            }
            this.argSymbolIdxs[i].getValueHolder(this.symbolPage).setWithoutSideEffect(value);
        }
        evaluationState.callStack.push(this.callRange);
        Namespace namespace = evaluationState.namespaceMgr.replaceCurrentNamespace(this.definitionNamespace);
        this.symbolTable.replaceCurrentPage(this.symbolPage);
        this.body = this.body.executePass(evaluationState);
        this.symbolTable.setCurrentPage(iValueHolderArray);
        evaluationState.namespaceMgr.setCurrentNamespace(namespace);
        evaluationState.callStack.pop();
        return this;
    }

    @Override
    public void deliverOutput(IOutputReciever iOutputReciever) {
        for (int i = 0; i < this.sideOutput.length; ++i) {
            FunctionSideOutput functionSideOutput = this.sideOutput[i];
            if (functionSideOutput == null) continue;
            for (Triple<OutputStreamType, String, Object> triple : functionSideOutput.getStreamOutput()) {
                iOutputReciever.addToStream(triple.getA(), triple.getB(), triple.getC());
            }
        }
        this.body.deliverOutput(iOutputReciever);
    }

    @Override
    public boolean isFinished() {
        return this.body.isFinished();
    }
}

