/*
 * Decompiled with CFR 0.152.
 */
package server.restful.common.text2speech;

import java.io.File;
import java.io.IOException;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.gcardone.junidecode.Junidecode;
import server.restful.common.processor.ExternalProcess;
import server.restful.common.text2speech.EspeakParameters;
import server.restful.common.text2speech.PicoToWavParameters;
import server.restful.common.text2speech.TextToSpeechBean;

public enum TextToSpeechType {
    NONE,
    PICO2WAVE,
    ESPEAK;


    public Process createProcess(TextToSpeechBean textToSpeechBean, File wavFile) throws IOException {
        int volume = this.getVolume(textToSpeechBean.getVolume());
        String baseSsml = this.createSsmlParagraph(textToSpeechBean);
        Locale textToSpeechLocale = textToSpeechBean.getTextToSpeechLocale();
        switch (this.ordinal()) {
            case 1: {
                String lang = this.createPicoToWaveLanguage(textToSpeechLocale);
                String ssml = String.format("<volume level=\"%d\"><pitch level=\"140\">%s</pitch></volume>", volume, baseSsml);
                return new ExternalProcess().execute(new PicoToWavParameters(lang, ssml, wavFile));
            }
            case 2: {
                String lang = this.createEspeakLanguage(textToSpeechLocale);
                String ssml = String.format("<speak><voice language=\"%s\" gender=\"female\">%s</voice></speak>", lang, baseSsml);
                return new ExternalProcess().execute(new EspeakParameters(volume, ssml, wavFile));
            }
        }
        throw new IOException(String.format("TextToSpeechType unknown: ", new Object[]{this}));
    }

    private String createPicoToWaveLanguage(Locale textToSpeechLocale) {
        if (Locale.GERMAN.getLanguage().equals(textToSpeechLocale.getLanguage())) {
            return Locale.GERMANY.toLanguageTag();
        }
        return Locale.UK.toLanguageTag();
    }

    private String createEspeakLanguage(Locale textToSpeechLocale) {
        if (Locale.ROOT.equals(textToSpeechLocale)) {
            return Locale.ENGLISH.getLanguage();
        }
        return textToSpeechLocale.getLanguage();
    }

    private int getVolume(double volume) {
        return (int)(40.0 + 5.0 * volume);
    }

    private String createSsmlParagraph(TextToSpeechBean textToSpeechBean) {
        ResourceBundle resourceBundle = ResourceBundle.getBundle(TextToSpeechType.class.getName(), textToSpeechBean.getTextToSpeechLocale());
        textToSpeechBean.determineText2Speak(resourceBundle);
        String text = "<p>" + (textToSpeechBean.getTitle() != null ? "<s>" + resourceBundle.getString("NOW_PLAYING") + ": " + this.replaceSpecials(textToSpeechBean.getTitle(), resourceBundle) + (textToSpeechBean.getSongNo() != null ? "<break time=\"250ms\"/>" + resourceBundle.getString("SONG_NO") + " " + textToSpeechBean.getSongNo() : "") + (textToSpeechBean.getName() != null ? "<break time=\"250ms\"/>" + resourceBundle.getString("NAME") + " " + this.replaceSpecials(this.removeBraces(textToSpeechBean.getName()), resourceBundle) : "") + "</s>" : "") + (textToSpeechBean.getAuthor() != null ? "<s>" + resourceBundle.getString("AUTHOR") + " " + this.replaceSpecials(this.replaceAliasName(textToSpeechBean.getAuthor(), resourceBundle), resourceBundle) + "</s>" : "") + (textToSpeechBean.getReleased() != null ? "<s>" + resourceBundle.getString("RELEASED") + " " + this.replaceSpecials(this.replaceUnknownDecade(this.replaceUnknownDate(this.replaceDateRange(textToSpeechBean.getReleased(), resourceBundle), resourceBundle), resourceBundle), resourceBundle) + "</s>" : "") + (textToSpeechBean.getBasedOnTitle() != null ? "<s>" + resourceBundle.getString("BASED_ON_TITLE") + " " + this.replaceSpecials(this.removeBraces(textToSpeechBean.getBasedOnTitle()), resourceBundle) + "</s>" : "") + (textToSpeechBean.getBasedOnArtist() != null ? "<s>" + resourceBundle.getString("BASED_ON_ARTIST") + " " + this.replaceSpecials(textToSpeechBean.getBasedOnArtist(), resourceBundle) + (textToSpeechBean.isAndMore() ? "<break time=\"250ms\"/>" + resourceBundle.getString("AND_MORE") + " " : "") + "</s>" : "") + "</p>";
        return text;
    }

    private String replaceSpecials(String string, ResourceBundle resourceBundle) {
        return Junidecode.unidecode((String)string).replaceAll("[/\\\\-\\\\-+_()]", "<break time=\"250ms\"/>").replace("&", " " + resourceBundle.getString("AND") + " ");
    }

    private String replaceAliasName(String string, ResourceBundle resourceBundle) {
        Pattern pattern = Pattern.compile("([^(]*)[(]([^)]*)[)]");
        Matcher matcher = pattern.matcher(string);
        if (matcher.matches()) {
            return matcher.group(1) + "(" + resourceBundle.getString("ALIAS") + " " + matcher.group(2) + ")";
        }
        return string;
    }

    private String replaceUnknownDate(String string, ResourceBundle resourceBundle) {
        Pattern pattern = Pattern.compile("19[?][?](.*)");
        Matcher matcher = pattern.matcher(string);
        if (matcher.matches()) {
            return resourceBundle.getString("IN_80_OR_90") + " / " + matcher.group(1);
        }
        return string;
    }

    private String replaceUnknownDecade(String string, ResourceBundle resourceBundle) {
        Pattern pattern = Pattern.compile("19([89])[?](.*)");
        Matcher matcher = pattern.matcher(string);
        if (matcher.matches()) {
            return String.format(resourceBundle.getString("IN_DECADE"), matcher.group(1) + "0") + " / " + matcher.group(2);
        }
        return string;
    }

    private String replaceDateRange(String string, ResourceBundle resourceBundle) {
        Pattern pattern = Pattern.compile("([0-9]{4})-([0-9]{2})(?!-)(.*)");
        Matcher matcher = pattern.matcher(string);
        if (matcher.matches()) {
            return String.format(resourceBundle.getString("FROM_TO"), matcher.group(1), matcher.group(1).substring(0, 2) + matcher.group(2)) + " / " + matcher.group(3);
        }
        return string;
    }

    private String removeBraces(String string) {
        return string.replaceAll("\\s*\\([^\\)]*\\)\\s*", "").replaceAll("\\[|\\]", "");
    }
}

