/*
 * Decompiled with CFR 0.152.
 */
package ui.entities.config;

import com.fasterxml.jackson.annotation.JsonIgnore;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javax.persistence.Access;
import javax.persistence.AccessType;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.metamodel.SingularAttribute;
import javax.xml.bind.annotation.XmlTransient;
import sidplay.ini.converter.BeanToStringConverter;
import ui.common.properties.ShadowField;

@Entity
@Access(value=AccessType.PROPERTY)
public class FavoriteColumn {
    private Integer id;
    private ShadowField<StringProperty, String> column = new ShadowField<StringProperty, Object>(SimpleStringProperty::new, null);
    private ShadowField<DoubleProperty, Number> width = new ShadowField<DoubleProperty, Integer>(number -> new SimpleDoubleProperty((double)number.floatValue()), 0);

    public FavoriteColumn() {
    }

    public FavoriteColumn(FavoriteColumn column) {
        this.setColumnProperty(column.getColumnProperty());
        this.setWidth(column.getWidth());
    }

    public FavoriteColumn(SingularAttribute<?, ?> attribute) {
        this.setColumnProperty(attribute.getName());
    }

    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE)
    @XmlTransient
    @JsonIgnore
    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public String getColumnProperty() {
        return this.column.get();
    }

    public void setColumnProperty(String columnProperty) {
        this.column.set(columnProperty);
    }

    public final StringProperty columnProperty() {
        return this.column.property();
    }

    public double getWidth() {
        return this.width.get().doubleValue();
    }

    public void setWidth(double width) {
        this.width.set(width);
    }

    public final DoubleProperty widthProperty() {
        return this.width.property();
    }

    public final String toString() {
        return BeanToStringConverter.toString(this);
    }
}

