/*
 * Decompiled with CFR 0.152.
 */
package net.java.truecommons.io;

import java.io.IOException;
import java.io.InputStream;
import javax.annotation.concurrent.NotThreadSafe;
import net.java.truecommons.io.ClosedInputException;
import net.java.truecommons.io.DecoratingInputStream;

@NotThreadSafe
public abstract class DisconnectingInputStream
extends DecoratingInputStream {
    protected DisconnectingInputStream() {
    }

    protected DisconnectingInputStream(InputStream in) {
        super(in);
    }

    public abstract boolean isOpen();

    protected final void checkOpen() throws ClosedInputException {
        if (!this.isOpen()) {
            throw new ClosedInputException();
        }
    }

    @Override
    public int read() throws IOException {
        this.checkOpen();
        return this.in.read();
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        this.checkOpen();
        return this.in.read(b, off, len);
    }

    @Override
    public long skip(long n) throws IOException {
        this.checkOpen();
        return this.in.skip(n);
    }

    @Override
    public int available() throws IOException {
        this.checkOpen();
        return this.in.available();
    }

    @Override
    public void mark(int readlimit) {
        if (this.isOpen()) {
            this.in.mark(readlimit);
        }
    }

    @Override
    public void reset() throws IOException {
        this.checkOpen();
        this.in.reset();
    }

    @Override
    public abstract void close() throws IOException;
}

