/*
 * Decompiled with CFR 0.152.
 */
package kickass.parsing.mainparse.tailparsers;

import java.io.IOException;
import kickass.common.diagnostics.AsmError;
import kickass.nonasm.util.functions.Func4;
import kickass.parsing.baselang.TokenType;
import kickass.parsing.baselang.tokens.IToken;
import kickass.parsing.baselang.tokenstreams.ITokenStream;
import kickass.parsing.mainparse.IDirectiveParser;
import kickass.parsing.mainparse.tailparsers.ITailParser;
import kickass.parsing.script.ExprParser;
import kickass.parsing.sourcelocation.SourceRange;
import kickass.pass.expressions.expr.ExprNode;
import kickass.state.EvaluationState;

public class IfTailParser<NODE>
implements ITailParser<NODE> {
    private IDirectiveParser<NODE> subParser;
    private Func4<ExprNode, NODE, NODE, SourceRange, NODE> nodeCreator;

    public IfTailParser(IDirectiveParser<NODE> iDirectiveParser, Func4<ExprNode, NODE, NODE, SourceRange, NODE> func4) {
        this.nodeCreator = func4;
        this.subParser = iDirectiveParser;
    }

    @Override
    public NODE parse(IToken iToken, SourceRange sourceRange, ITokenStream iTokenStream, EvaluationState evaluationState) throws IOException {
        IToken iToken2 = iTokenStream.expectTypeSkipWs(TokenType.ParanthesisRange, evaluationState);
        if (iToken2 == null) {
            return null;
        }
        ExprNode exprNode = ExprParser.parse(iToken2.getChildStream(), evaluationState);
        if (exprNode == null) {
            return null;
        }
        NODE NODE = this.subParser.parse(iTokenStream, evaluationState);
        if (NODE == null) {
            evaluationState.diagnosticMgr.add(new AsmError("If without body", sourceRange));
            return null;
        }
        Object T3 = null;
        iTokenStream.skipWsAndNl();
        boolean bl = iTokenStream.peek().isId("else");
        if (bl) {
            iTokenStream.next();
            T3 = this.subParser.parse(iTokenStream, evaluationState);
            if (T3 == null) {
                evaluationState.diagnosticMgr.add(new AsmError("Else without body", sourceRange));
                return null;
            }
        }
        return this.nodeCreator.apply(exprNode, NODE, T3, sourceRange);
    }
}

