/*
 * Decompiled with CFR 0.152.
 */
package ui.asm;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Scanner;
import javafx.beans.property.ObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.transformation.SortedList;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextArea;
import javafx.scene.control.cell.TextFieldTableCell;
import javafx.scene.input.KeyCode;
import kickass.common.diagnostics.IDiagnostic;
import kickass.common.exceptions.AsmErrorException;
import libsidplay.sidtune.SidTune;
import libsidplay.sidtune.SidTuneError;
import libsidutils.IOUtils;
import libsidutils.assembler.KickAssembler;
import sidplay.Player;
import ui.asm.Variable;
import ui.common.C64VBox;
import ui.common.C64Window;
import ui.common.UIPart;
import ui.common.util.DesktopUtil;

public class Asm
extends C64VBox
implements UIPart {
    public static final String ID = "ASM";
    private static final String HOMEPAGE_URL = "http://www.theweb.dk/KickAssembler/";
    private static final String ASM_RESOURCE = "asm";
    private static final String ASM_EXAMPLE = "/ui/asm/Asm.asm";
    @FXML
    private TextArea contents;
    @FXML
    private TableView<Variable> variablesTable;
    @FXML
    private TableColumn<Variable, String> varNameColumn;
    @FXML
    private TableColumn<Variable, String> varValueColumn;
    @FXML
    private Label status;
    private ObservableList<Variable> variables;

    public Asm() {
    }

    public Asm(C64Window window, Player player) {
        super(window, player);
    }

    @Override
    @FXML
    protected void initialize() {
        this.status.setPrefHeight(Double.MAX_VALUE);
        InputStream is = Asm.class.getResourceAsStream(ASM_EXAMPLE);
        this.contents.setText(IOUtils.convertStreamToString(is, StandardCharsets.ISO_8859_1));
        this.varNameColumn.setCellFactory(TextFieldTableCell.forTableColumn());
        this.varNameColumn.setOnEditCommit(evt -> ((Variable)evt.getTableView().getItems().get(evt.getTablePosition().getRow())).setName((String)evt.getNewValue()));
        this.varValueColumn.setCellFactory(TextFieldTableCell.forTableColumn());
        this.varValueColumn.setOnEditCommit(evt -> ((Variable)evt.getTableView().getItems().get(evt.getTablePosition().getRow())).setValue((String)evt.getNewValue()));
        this.variables = FXCollections.observableArrayList();
        SortedList sortedList = new SortedList(this.variables);
        sortedList.comparatorProperty().bind((ObservableValue)this.variablesTable.comparatorProperty());
        this.variablesTable.setItems((ObservableList)sortedList);
        this.varNameColumn.prefWidthProperty().bind((ObservableValue)this.variablesTable.widthProperty().multiply(0.4));
        this.varValueColumn.prefWidthProperty().bind((ObservableValue)this.variablesTable.widthProperty().multiply(0.6));
        this.contents.setOnKeyPressed(event -> {
            if (event.getCode() == KeyCode.Z && event.isControlDown()) {
                this.contents.undo();
                event.consume();
            }
            if (event.getCode() == KeyCode.Y && event.isControlDown()) {
                this.contents.redo();
                event.consume();
            }
        });
    }

    @FXML
    private void gotoHomepage() {
        DesktopUtil.browse(HOMEPAGE_URL);
    }

    @FXML
    private void addVariable() {
        Variable variable = new Variable();
        variable.setName("test");
        variable.setValue("1");
        this.variables.add((Object)variable);
    }

    @FXML
    private void removeVariable() {
        Variable selectedItem = (Variable)this.variablesTable.getSelectionModel().getSelectedItem();
        if (selectedItem != null) {
            this.variables.remove((Object)selectedItem);
        }
    }

    @FXML
    private void compile() {
        try {
            HashMap<String, String> globals = new HashMap<String, String>();
            this.variables.stream().forEach(var -> globals.put(var.getName(), var.getValue()));
            ByteArrayInputStream asm = new ByteArrayInputStream(this.contents.getText().getBytes(StandardCharsets.UTF_8.name()));
            byte[] assembly = KickAssembler.assemble(ASM_RESOURCE, asm, globals).getData();
            ByteArrayInputStream is = new ByteArrayInputStream(assembly);
            SidTune tune = SidTune.load("assembly.prg", is);
            this.status.setText("");
            this.util.setPlayingTab((Node)this, new ObjectProperty[0]);
            this.util.getPlayer().play(tune);
        }
        catch (AsmErrorException e) {
            if (e.getError() != null) {
                this.highlightError(e.getError());
            }
            this.status.setText(e.getMessage());
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (IOException | SidTuneError e) {
            e.printStackTrace();
        }
    }

    private void highlightError(IDiagnostic e) {
        int pos = 0;
        if (e.getRange() != null) {
            try (Scanner s = new Scanner(this.contents.getText());){
                s.useDelimiter("\n");
                for (int line = 0; s.hasNext() && line < e.getRange().getStartLineNo() - 1; ++line) {
                    pos += s.next().length() + 1;
                }
            }
            this.contents.positionCaret(pos + e.getRange().getStartLinePos() - 1);
        }
        this.contents.selectNextWord();
    }
}

