/*
 * Decompiled with CFR 0.152.
 */
package server.restful.common.processor;

import client.teavm.common.parameter.StringBuilderConsole;
import com.beust.jcommander.IUsageFormatter;
import com.beust.jcommander.JCommander;
import com.beust.jcommander.internal.Console;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import libsidutils.IOUtils;
import server.restful.common.processor.ProcessCommandUsageFormatter;

public class ExternalProcess {
    private List<String> arguments;

    public Process execute(Object parameterObject) throws IOException {
        JCommander jCommander = JCommander.newBuilder().addObject(new Object()).addCommand(parameterObject).programName(parameterObject.getClass().getName()).console((Console)new NoConsole()).build();
        if (jCommander.getCommands().isEmpty()) {
            throw new IOException(String.format("%s is missing a command!", parameterObject.getClass()));
        }
        StringBuilder usageMessage = new StringBuilder();
        Iterator it = jCommander.getCommands().keySet().iterator();
        while (it.hasNext()) {
            String command = (String)it.next();
            JCommander jCommand = (JCommander)jCommander.getCommands().get(command);
            ProcessCommandUsageFormatter usageFormatter = new ProcessCommandUsageFormatter(jCommand);
            jCommand.setUsageFormatter((IUsageFormatter)usageFormatter);
            jCommand.usage();
            try {
                this.arguments = usageFormatter.getArguments();
                usageMessage.append("\n").append(this.arguments.stream().collect(Collectors.joining(" ")));
                Process process = new ProcessBuilder(this.arguments).start();
                process.waitFor();
                if (process.exitValue() != 0 && !it.hasNext()) {
                    usageMessage.append(this.getStdout(process));
                    usageMessage.append(this.getStdErr(process));
                    throw new IOException(String.format("%s failed with exitValue: %d\n%s", command, process.exitValue(), usageMessage.toString()));
                }
                return process;
            }
            catch (IOException | InterruptedException e) {
            }
        }
        JCommander.newBuilder().programName("").addObject(new Object()).addCommand(parameterObject).console((Console)new StringBuilderConsole(usageMessage.append("\n"))).columnSize(Integer.MAX_VALUE).build().usage();
        throw new IOException(usageMessage.toString());
    }

    private String getStdErr(Process process) throws IOException {
        try (InputStream is = process.getErrorStream();){
            String string = IOUtils.convertStreamToString(is, StandardCharsets.UTF_8);
            return string;
        }
    }

    private String getStdout(Process process) throws IOException {
        try (InputStream is = process.getInputStream();){
            String string = IOUtils.convertStreamToString(is, StandardCharsets.UTF_8);
            return string;
        }
    }

    public List<String> getArguments() {
        return this.arguments;
    }

    private static class NoConsole
    implements Console {
        private NoConsole() {
        }

        public void print(String msg) {
        }

        public void println(String msg) {
        }

        public char[] readPassword(boolean echoInput) {
            throw new RuntimeException("readPassword not supported!");
        }
    }
}

