/*
 * Decompiled with CFR 0.152.
 */
package net.java.truecommons.shed;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public abstract class FilteringIterator<T>
implements Iterator<T> {
    private final Iterator<T> it;
    @Nullable
    private Boolean hasNext;
    @Nullable
    private T next;

    protected FilteringIterator(Iterable<T> iterable) {
        this(iterable.iterator());
    }

    protected FilteringIterator(Iterator<T> iterator) {
        this.it = Objects.requireNonNull(iterator);
    }

    protected abstract boolean accept(@Nullable T var1);

    @Override
    public boolean hasNext() {
        if (null != this.hasNext) {
            return this.hasNext;
        }
        while (this.it.hasNext()) {
            this.next = this.it.next();
            if (!this.accept(this.next)) continue;
            this.hasNext = true;
            return this.hasNext;
        }
        this.hasNext = false;
        return this.hasNext;
    }

    @Override
    @Nullable
    public T next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        this.hasNext = null;
        return this.next;
    }

    @Override
    public void remove() {
        this.it.remove();
    }
}

