/*
 * Decompiled with CFR 0.152.
 */
package mp3;

import java.util.Arrays;
import mp3.ReplayGain;

public class GainAnalysis {
    private static final float PINK_REF = 64.82f;
    private static final int YULE_ORDER = 10;
    private static final float RMS_PERCENTILE = 0.95f;
    private static final int MAX_SAMP_FREQ = 48000;
    private static final int RMS_WINDOW_TIME_NUMERATOR = 1;
    private static final int RMS_WINDOW_TIME_DENOMINATOR = 20;
    static final float STEPS_per_dB = 100.0f;
    static final float MAX_dB = 120.0f;
    public static final int GAIN_NOT_ENOUGH_SAMPLES = -24601;
    public static final int GAIN_ANALYSIS_ERROR = 0;
    public static final int GAIN_ANALYSIS_OK = 1;
    public static final int INIT_GAIN_ANALYSIS_ERROR = 0;
    public static final int INIT_GAIN_ANALYSIS_OK = 1;
    static final int MAX_ORDER = 10;
    static final int MAX_SAMPLES_PER_WINDOW = 2401;
    private static final float[][] ABYule = new float[][]{{0.038575996f, -3.846646f, -0.021603672f, 7.8150167f, -0.0012339532f, -11.341703f, -9.291678E-5f, 13.055042f, -0.016552603f, -12.287599f, 0.021615269f, 9.482938f, -0.020740451f, -5.8725786f, 0.0059429808f, 2.7546587f, 0.0030642801f, -0.8698438f, 1.2025322E-4f, 0.13919315f, 0.0028846369f}, {0.054186564f, -3.4784596f, -0.029110078f, 6.363178f, -0.008487094f, -8.547515f, -0.008511657f, 9.476936f, -0.008349909f, -8.814987f, 0.022452932f, 6.8540154f, -0.025963385f, -4.39471f, 0.016248649f, 2.196117f, -0.0024087904f, -0.751043f, 0.006746137f, 0.13149318f, -0.0018776378f}, {0.154573f, -2.3789883f, -0.09331049f, 2.8486814f, -0.062478803f, -2.6457717f, 0.021635419f, 2.2369766f, -0.055883933f, -1.6714815f, 0.047814768f, 1.0059595f, 0.002223126f, -0.4595346f, 0.031740926f, 0.16378164f, -0.013905894f, -0.050320778f, 0.0065142065f, 0.023478974f, -0.008813627f}, {0.30296907f, -1.6127317f, -0.22613989f, 1.079775f, -0.08587324f, -0.2565626f, 0.032829303f, -0.16276719f, -0.009157029f, -0.22638893f, -0.023641411f, 0.391208f, -0.0058445605f, -0.2213814f, 0.062761016f, 0.045002352f, -8.280867E-6f, 0.020058518f, 0.002058619f, 0.003024391f, -0.02950135f}, {0.33642304f, -1.4985898f, -0.2557224f, 0.87350273f, -0.1182857f, 0.122050226f, 0.11921149f, -0.80774945f, -0.0783449f, 0.47854796f, -0.004699779f, -0.124534585f, -0.0058950023f, -0.040675104f, 0.05724228f, 0.08333755f, 0.00832044f, -0.04237348f, -0.016353814f, 0.029772073f, -0.017601766f}, {0.44915256f, -0.6282062f, -0.14351757f, 0.29661784f, -0.22784394f, -0.37256372f, -0.014191401f, 0.0021376787f, 0.040782627f, -0.4202982f, -0.12398163f, 0.2219965f, 0.040975653f, 0.0061342437f, 0.10478503f, 0.067476206f, -0.018638877f, 0.057848204f, -0.031934284f, 0.032227542f, 0.0054190774f}, {0.5661947f, -1.0480033f, -0.7546446f, 0.29156312f, 0.16242138f, -0.26806f, 0.16744244f, 0.008199996f, -0.18901604f, 0.45054734f, 0.30931783f, -0.33032402f, -0.2756296f, 0.06739368f, 0.006473107f, -0.047842544f, 0.08647504f, 0.016399078f, -0.037889846f, 0.018073643f, -0.005882154f}, {0.581005f, -0.51035327f, -0.53174907f, -0.31863564f, -0.142898f, -0.20256414f, 0.17520705f, 0.14728154f, 0.023779452f, 0.3895264f, 0.15558448f, -0.23313272f, -0.2534479f, -0.05246019f, 0.016284624f, -0.025059618f, 0.06920468f, 0.024423573f, -0.037216116f, 0.01818801f, -0.007496188f}, {0.5364879f, -0.2504987f, -0.42163035f, -0.43193942f, -0.002759536f, -0.03424681f, 0.042678423f, -0.046783287f, -0.102148645f, 0.264083f, 0.14590773f, 0.1511313f, -0.024598649f, -0.17556493f, -0.11202315f, -0.1882301f, -0.04060034f, 0.054777205f, 0.047886655f, 0.0470441f, -0.022179369f}};
    private static final float[][] ABButter = new float[][]{{0.9862119f, -1.9722338f, -1.9724238f, 0.972614f, 0.9862119f}, {0.98500174f, -1.9697785f, -1.9700035f, 0.9702285f, 0.98500174f}, {0.9793893f, -1.9583538f, -1.9587786f, 0.9592035f, 0.9793893f}, {0.97531843f, -1.9500276f, -1.9506369f, 0.95124614f, 0.97531843f}, {0.9731652f, -1.9456103f, -1.9463304f, 0.9470507f, 0.9731652f}, {0.96454513f, -1.9278328f, -1.9290903f, 0.93034774f, 0.96454513f}, {0.9600914f, -1.9185895f, -1.9201828f, 0.9217762f, 0.9600914f}, {0.95856917f, -1.9154211f, -1.9171383f, 0.9188556f, 0.95856917f}, {0.94597685f, -1.8890331f, -1.8919537f, 0.89487433f, 0.94597685f}};

    private void filterYule(float[] input, int inputPos, float[] output, int outputPos, int nSamples, float[] kernel) {
        while (nSamples-- != 0) {
            output[outputPos] = 1.0E-10f + input[inputPos + 0] * kernel[0] - output[outputPos - 1] * kernel[1] + input[inputPos - 1] * kernel[2] - output[outputPos - 2] * kernel[3] + input[inputPos - 2] * kernel[4] - output[outputPos - 3] * kernel[5] + input[inputPos - 3] * kernel[6] - output[outputPos - 4] * kernel[7] + input[inputPos - 4] * kernel[8] - output[outputPos - 5] * kernel[9] + input[inputPos - 5] * kernel[10] - output[outputPos - 6] * kernel[11] + input[inputPos - 6] * kernel[12] - output[outputPos - 7] * kernel[13] + input[inputPos - 7] * kernel[14] - output[outputPos - 8] * kernel[15] + input[inputPos - 8] * kernel[16] - output[outputPos - 9] * kernel[17] + input[inputPos - 9] * kernel[18] - output[outputPos - 10] * kernel[19] + input[inputPos - 10] * kernel[20];
            ++outputPos;
            ++inputPos;
        }
    }

    private void filterButter(float[] input, int inputPos, float[] output, int outputPos, int nSamples, float[] kernel) {
        while (nSamples-- != 0) {
            output[outputPos] = input[inputPos + 0] * kernel[0] - output[outputPos - 1] * kernel[1] + input[inputPos - 1] * kernel[2] - output[outputPos - 2] * kernel[3] + input[inputPos - 2] * kernel[4];
            ++outputPos;
            ++inputPos;
        }
    }

    private int ResetSampleFrequency(ReplayGain rgData, long samplefreq) {
        for (int i = 0; i < 10; ++i) {
            rgData.routbuf[i] = 0.0f;
            rgData.rstepbuf[i] = 0.0f;
            rgData.rinprebuf[i] = 0.0f;
            rgData.loutbuf[i] = 0.0f;
            rgData.lstepbuf[i] = 0.0f;
            rgData.linprebuf[i] = 0.0f;
        }
        switch ((int)samplefreq) {
            case 48000: {
                rgData.freqindex = 0;
                break;
            }
            case 44100: {
                rgData.freqindex = 1;
                break;
            }
            case 32000: {
                rgData.freqindex = 2;
                break;
            }
            case 24000: {
                rgData.freqindex = 3;
                break;
            }
            case 22050: {
                rgData.freqindex = 4;
                break;
            }
            case 16000: {
                rgData.freqindex = 5;
                break;
            }
            case 12000: {
                rgData.freqindex = 6;
                break;
            }
            case 11025: {
                rgData.freqindex = 7;
                break;
            }
            case 8000: {
                rgData.freqindex = 8;
                break;
            }
            default: {
                return 0;
            }
        }
        rgData.sampleWindow = (int)((samplefreq * 1L + 20L - 1L) / 20L);
        rgData.lsum = 0.0;
        rgData.rsum = 0.0;
        rgData.totsamp = 0;
        Arrays.fill(rgData.A, 0);
        return 1;
    }

    public final int InitGainAnalysis(ReplayGain rgData, long samplefreq) {
        if (this.ResetSampleFrequency(rgData, samplefreq) != 1) {
            return 0;
        }
        rgData.linpre = 10;
        rgData.rinpre = 10;
        rgData.lstep = 10;
        rgData.rstep = 10;
        rgData.lout = 10;
        rgData.rout = 10;
        Arrays.fill(rgData.B, 0);
        return 1;
    }

    private double fsqr(double d) {
        return d * d;
    }

    public final int AnalyzeSamples(ReplayGain rgData, float[] left_samples, int left_samplesPos, float[] right_samples, int right_samplesPos, int num_samples, int num_channels) {
        if (num_samples == 0) {
            return 1;
        }
        int cursamplepos = 0;
        int batchsamples = num_samples;
        switch (num_channels) {
            case 1: {
                right_samples = left_samples;
                right_samplesPos = left_samplesPos;
                break;
            }
            case 2: {
                break;
            }
            default: {
                return 0;
            }
        }
        if (num_samples < 10) {
            System.arraycopy(left_samples, left_samplesPos, rgData.linprebuf, 10, num_samples);
            System.arraycopy(right_samples, right_samplesPos, rgData.rinprebuf, 10, num_samples);
        } else {
            System.arraycopy(left_samples, left_samplesPos, rgData.linprebuf, 10, 10);
            System.arraycopy(right_samples, right_samplesPos, rgData.rinprebuf, 10, 10);
        }
        while (batchsamples > 0) {
            float[] currightBase;
            int curright;
            float[] curleftBase;
            int curleft;
            int cursamples;
            int n = cursamples = batchsamples > rgData.sampleWindow - rgData.totsamp ? rgData.sampleWindow - rgData.totsamp : batchsamples;
            if (cursamplepos < 10) {
                curleft = rgData.linpre + cursamplepos;
                curleftBase = rgData.linprebuf;
                curright = rgData.rinpre + cursamplepos;
                currightBase = rgData.rinprebuf;
                if (cursamples > 10 - cursamplepos) {
                    cursamples = 10 - cursamplepos;
                }
            } else {
                curleft = left_samplesPos + cursamplepos;
                curleftBase = left_samples;
                curright = right_samplesPos + cursamplepos;
                currightBase = right_samples;
            }
            this.filterYule(curleftBase, curleft, rgData.lstepbuf, rgData.lstep + rgData.totsamp, cursamples, ABYule[rgData.freqindex]);
            this.filterYule(currightBase, curright, rgData.rstepbuf, rgData.rstep + rgData.totsamp, cursamples, ABYule[rgData.freqindex]);
            this.filterButter(rgData.lstepbuf, rgData.lstep + rgData.totsamp, rgData.loutbuf, rgData.lout + rgData.totsamp, cursamples, ABButter[rgData.freqindex]);
            this.filterButter(rgData.rstepbuf, rgData.rstep + rgData.totsamp, rgData.routbuf, rgData.rout + rgData.totsamp, cursamples, ABButter[rgData.freqindex]);
            curleft = rgData.lout + rgData.totsamp;
            curleftBase = rgData.loutbuf;
            curright = rgData.rout + rgData.totsamp;
            currightBase = rgData.routbuf;
            int i = cursamples % 8;
            while (i-- != 0) {
                rgData.lsum += this.fsqr(curleftBase[curleft++]);
                rgData.rsum += this.fsqr(currightBase[curright++]);
            }
            i = cursamples / 8;
            while (i-- != 0) {
                rgData.lsum += this.fsqr(curleftBase[curleft + 0]) + this.fsqr(curleftBase[curleft + 1]) + this.fsqr(curleftBase[curleft + 2]) + this.fsqr(curleftBase[curleft + 3]) + this.fsqr(curleftBase[curleft + 4]) + this.fsqr(curleftBase[curleft + 5]) + this.fsqr(curleftBase[curleft + 6]) + this.fsqr(curleftBase[curleft + 7]);
                curleft += 8;
                rgData.rsum += this.fsqr(currightBase[curright + 0]) + this.fsqr(currightBase[curright + 1]) + this.fsqr(currightBase[curright + 2]) + this.fsqr(currightBase[curright + 3]) + this.fsqr(currightBase[curright + 4]) + this.fsqr(currightBase[curright + 5]) + this.fsqr(currightBase[curright + 6]) + this.fsqr(currightBase[curright + 7]);
                curright += 8;
            }
            batchsamples -= cursamples;
            cursamplepos += cursamples;
            rgData.totsamp += cursamples;
            if (rgData.totsamp == rgData.sampleWindow) {
                int ival;
                double val = 1000.0 * Math.log10((rgData.lsum + rgData.rsum) / (double)rgData.totsamp * 0.5 + 1.0E-37);
                int n2 = ival = val <= 0.0 ? 0 : (int)val;
                if (ival >= rgData.A.length) {
                    ival = rgData.A.length - 1;
                }
                int n3 = ival;
                rgData.A[n3] = rgData.A[n3] + 1;
                rgData.rsum = 0.0;
                rgData.lsum = 0.0;
                System.arraycopy(rgData.loutbuf, rgData.totsamp, rgData.loutbuf, 0, 10);
                System.arraycopy(rgData.routbuf, rgData.totsamp, rgData.routbuf, 0, 10);
                System.arraycopy(rgData.lstepbuf, rgData.totsamp, rgData.lstepbuf, 0, 10);
                System.arraycopy(rgData.rstepbuf, rgData.totsamp, rgData.rstepbuf, 0, 10);
                rgData.totsamp = 0;
            }
            if (rgData.totsamp <= rgData.sampleWindow) continue;
            return 0;
        }
        if (num_samples < 10) {
            System.arraycopy(rgData.linprebuf, num_samples, rgData.linprebuf, 0, 10 - num_samples);
            System.arraycopy(rgData.rinprebuf, num_samples, rgData.rinprebuf, 0, 10 - num_samples);
            System.arraycopy(left_samples, left_samplesPos, rgData.linprebuf, 10 - num_samples, num_samples);
            System.arraycopy(right_samples, right_samplesPos, rgData.rinprebuf, 10 - num_samples, num_samples);
        } else {
            System.arraycopy(left_samples, left_samplesPos + num_samples - 10, rgData.linprebuf, 0, 10);
            System.arraycopy(right_samples, right_samplesPos + num_samples - 10, rgData.rinprebuf, 0, 10);
        }
        return 1;
    }

    private float analyzeResult(int[] Array, int len) {
        int i;
        int elems = 0;
        for (i = 0; i < len; ++i) {
            elems += Array[i];
        }
        if (elems == 0) {
            return -24601.0f;
        }
        int upper = (int)Math.ceil((double)elems * 0.050000011920928955);
        i = len;
        while (i-- > 0 && (upper -= Array[i]) > 0) {
        }
        return 64.82f - (float)i / 100.0f;
    }

    public final float GetTitleGain(ReplayGain rgData) {
        int i;
        float retval = this.analyzeResult(rgData.A, rgData.A.length);
        for (i = 0; i < rgData.A.length; ++i) {
            int n = i;
            rgData.B[n] = rgData.B[n] + rgData.A[i];
            rgData.A[i] = 0;
        }
        for (i = 0; i < 10; ++i) {
            rgData.routbuf[i] = 0.0f;
            rgData.rstepbuf[i] = 0.0f;
            rgData.rinprebuf[i] = 0.0f;
            rgData.loutbuf[i] = 0.0f;
            rgData.lstepbuf[i] = 0.0f;
            rgData.linprebuf[i] = 0.0f;
        }
        rgData.totsamp = 0;
        rgData.rsum = 0.0;
        rgData.lsum = 0.0;
        return retval;
    }
}

