/*
 * Decompiled with CFR 0.152.
 */
package builder.jexsid;

import builder.jexsid.AudioOp;
import builder.jexsid.ChipSelect;
import builder.jexsid.ClockSelect;
import builder.jexsid.JExSIDBuilder;
import builder.resid.residfp.ReSIDfp;
import exsid.ExSID;
import java.util.List;
import java.util.Objects;
import libsidplay.common.CPUClock;
import libsidplay.common.ChipModel;
import libsidplay.common.Event;
import libsidplay.common.EventScheduler;
import libsidplay.config.IEmulationSection;
import libsidplay.config.ISidPlay2SystemProperties;

public class ExSIDEmu
extends ReSIDfp {
    private final EventScheduler context;
    private final JExSIDBuilder jExSIDBuilder;
    private final Event event;
    private final ExSID exSID;
    private final byte deviceID;
    private String deviceName;
    private int sidNum;
    private final ChipModel chipModel;
    private boolean[] voiceMute = new boolean[4];
    private boolean[] filterDisable = new boolean[ISidPlay2SystemProperties.MAX_SIDS];

    public ExSIDEmu(JExSIDBuilder jExSIDBuilder, EventScheduler context, CPUClock cpuClock, ExSID exSID, byte deviceId, int sidNum, ChipModel model, ChipModel defaultSidModel, boolean stereo) {
        super(context);
        this.jExSIDBuilder = jExSIDBuilder;
        this.context = context;
        this.exSID = exSID;
        this.deviceID = deviceId;
        this.sidNum = sidNum;
        this.chipModel = model;
        this.event = Event.of("ExSID Delay", event -> context.schedule((Event)event, jExSIDBuilder.eventuallyDelay(), Event.Phase.PHI2));
        super.setChipModel(model);
        super.setClockFrequency(cpuClock.getCpuFrequency());
        if (sidNum == 0) {
            exSID.exSID_audio_op(AudioOp.XS_AU_MUTE.getAudioOp());
            exSID.exSID_clockselect(cpuClock == CPUClock.PAL ? ClockSelect.XS_CL_PAL.getClockSelect() : ClockSelect.XS_CL_NTSC.getClockSelect());
            if (stereo) {
                exSID.exSID_audio_op(model == ChipModel.MOS6581 ? AudioOp.XS_AU_6581_8580.getAudioOp() : AudioOp.XS_AU_8580_6581.getAudioOp());
            } else {
                exSID.exSID_audio_op(model == ChipModel.MOS6581 ? AudioOp.XS_AU_6581_6581.getAudioOp() : AudioOp.XS_AU_8580_8580.getAudioOp());
            }
            exSID.exSID_audio_op(AudioOp.XS_AU_UNMUTE.getAudioOp());
        }
    }

    @Override
    public void write(int addr, byte data) {
        switch (addr & 0x1F) {
            case 4: 
            case 11: 
            case 18: {
                if (this.voiceMute[(addr - 4) / 7]) {
                    data = (byte)(data & 0xFE);
                }
                super.write(addr, data);
                break;
            }
            case 23: {
                if (this.filterDisable[this.sidNum]) {
                    data = (byte)(data & 0xF0);
                }
                super.write(addr, data);
                break;
            }
            case 24: {
                if (this.voiceMute[3] && (data & 0xF) < (this.readInternalRegister(addr) & 0xF)) {
                    return;
                }
                super.write(addr, data);
                break;
            }
            default: {
                super.write(addr, data);
            }
        }
        byte dataByte = data;
        if (addr > 24) {
            return;
        }
        this.doWriteDelayed(() -> {
            if (!Objects.equals(this.jExSIDBuilder.lastSidNum, this.sidNum)) {
                this.exSID.exSID_chipselect(this.chipModel == ChipModel.MOS8580 ? ChipSelect.XS_CS_CHIP1.getChipSelect() : ChipSelect.XS_CS_CHIP0.getChipSelect());
                this.jExSIDBuilder.lastSidNum = this.sidNum;
            }
            this.exSID.exSID_clkdwrite(0L, (byte)addr, dataByte);
        });
    }

    @Override
    public void clock() {
        super.clock();
        short clocksSinceLastAccess = (short)this.jExSIDBuilder.clocksSinceLastAccess();
        this.doWriteDelayed(() -> this.exSID.exSID_delay((long)clocksSinceLastAccess));
    }

    private void doWriteDelayed(Runnable runnable) {
        if (this.jExSIDBuilder.getDelay(this.sidNum) > 0) {
            this.context.schedule(Event.of("Delayed SID output", event -> runnable.run()), this.jExSIDBuilder.getDelay(this.sidNum));
        } else {
            runnable.run();
        }
    }

    protected boolean lock() {
        this.exSID.exSID_reset((byte)15);
        try {
            Thread.sleep(50L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        this.reset((byte)15);
        this.context.schedule(this.event, 0L, Event.Phase.PHI2);
        return true;
    }

    protected void unlock() {
        this.exSID.exSID_reset((byte)0);
        try {
            Thread.sleep(50L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        this.reset((byte)0);
        this.context.cancel(this.event);
    }

    @Override
    public void setVoiceMute(int num, boolean mute) {
        super.setVoiceMute(num, mute);
        if (num < 4) {
            this.voiceMute[num] = mute;
        }
    }

    @Override
    public void setFilterEnable(IEmulationSection emulation, int sidNum) {
        super.setFilterEnable(emulation, sidNum);
        this.filterDisable[sidNum] = !emulation.isFilterEnable(sidNum);
    }

    public byte getDeviceId() {
        return this.deviceID;
    }

    public String getDeviceName() {
        return this.deviceName;
    }

    public void setDeviceName(String deviceName) {
        this.deviceName = deviceName;
    }

    protected ChipModel getChipModel() {
        return this.chipModel;
    }

    public static final String credits() {
        StringBuffer credits = new StringBuffer();
        credits.append("ExSID Java version by Ken H\u00e4ndel <kschwiersch@yahoo.de> Copyright (\u00a9) 2021\n");
        credits.append("\tHardware and driver code by Thibaut Thezan\n");
        credits.append("\thttp://hacks.slashdirt.org/hw/exsid/\n");
        return credits.toString();
    }

    public static class FakeStereo
    extends ExSIDEmu {
        private final IEmulationSection emulationSection;
        private final int prevNum;
        private final List<ExSIDEmu> sids;

        public FakeStereo(JExSIDBuilder jExSIDBuilder, EventScheduler context, CPUClock cpuClock, ExSID hardSID, byte deviceId, int sidNum, ChipModel model, ChipModel defaultChipModel, boolean stereo, List<ExSIDEmu> sids, IEmulationSection emulationSection) {
            super(jExSIDBuilder, context, cpuClock, hardSID, deviceId, sidNum, model, defaultChipModel, stereo);
            this.prevNum = sidNum - 1;
            this.sids = sids;
            this.emulationSection = emulationSection;
        }

        @Override
        public byte read(int addr) {
            if (this.emulationSection.getSidToRead().getSidNum() <= this.prevNum) {
                return this.sids.get(this.prevNum).read(addr);
            }
            return super.read(addr);
        }

        @Override
        public byte readInternalRegister(int addr) {
            if (this.emulationSection.getSidToRead().getSidNum() <= this.prevNum) {
                return this.sids.get(this.prevNum).readInternalRegister(addr);
            }
            return super.readInternalRegister(addr);
        }

        @Override
        public void write(int addr, byte data) {
            super.write(addr, data);
            this.sids.get(this.prevNum).write(addr, data);
        }
    }
}

