/*
 * Decompiled with CFR 0.152.
 */
package builder.jusbsid;

import builder.jusbsid.JUSBSIDBuilder;
import builder.resid.residfp.ReSIDfp;
import java.util.List;
import java.util.Objects;
import libsidplay.common.CPUClock;
import libsidplay.common.ChipModel;
import libsidplay.common.Event;
import libsidplay.common.EventScheduler;
import libsidplay.config.IEmulationSection;
import libsidplay.config.ISidPlay2SystemProperties;
import usbsid.USBSID;

public class USBSIDEmu
extends ReSIDfp {
    private final EventScheduler context;
    private final JUSBSIDBuilder jusbsidBuilder;
    private final Event frame_event;
    private short raster_rate;
    private static long usid_main_clk;
    private static long usid_alarm_clk;
    private double us_systemClock;
    private int us_cyclesPerFrame;
    private short us_writecycles;
    private final USBSID usbsid;
    private final byte deviceID;
    private String deviceName;
    private int sidNum;
    private final ChipModel chipModel;
    private boolean[] voiceMute = new boolean[4];
    private boolean[] filterDisable = new boolean[ISidPlay2SystemProperties.MAX_SIDS];

    public USBSIDEmu(JUSBSIDBuilder jusbsidBuilder, EventScheduler context, CPUClock cpuClock, USBSID usbsid, byte deviceId, int sidNum, ChipModel model, ChipModel defaultSidModel, boolean stereo) {
        super(context);
        this.jusbsidBuilder = jusbsidBuilder;
        this.context = context;
        this.usbsid = usbsid;
        this.deviceID = deviceId;
        this.sidNum = sidNum;
        this.chipModel = model;
        this.frame_event = Event.of("USBSID Flush buffer", frame_event -> context.schedule((Event)frame_event, this.usbsid_alarm_handler(), Event.Phase.PHI2));
        super.setChipModel(model);
        super.setClockFrequency(cpuClock.getCpuFrequency());
        this.us_systemClock = cpuClock.getCpuFrequency();
        this.us_cyclesPerFrame = cpuClock.getCyclesPerFrame();
        this.us_writecycles = 0;
        if (sidNum == 0) {
            this.raster_rate = (short)this.us_cyclesPerFrame;
            System.out.printf("[USBSID] raster_rate set to: %d\n", this.raster_rate);
            usbsid.USBSID_setclock(this.us_systemClock);
            usid_main_clk = context.getTime(Event.Phase.PHI2);
        }
    }

    private int us_delay() {
        int cycles;
        long now = this.context.getTime(Event.Phase.PHI2);
        if (now < usid_main_clk) {
            usid_main_clk = now;
            return 0;
        }
        int ff = this.jusbsidBuilder.ff();
        for (cycles = (int)(now - usid_main_clk); cycles > 65535; cycles -= 65535) {
            this.usbsid.USBSID_delay((short)(65535 >> ff));
        }
        usid_main_clk = now;
        this.usbsid.USBSID_delay((short)(cycles >> ff));
        return cycles >> ff;
    }

    long usbsid_alarm_handler() {
        long now = this.context.getTime(Event.Phase.PHI2);
        int cycles = this.raster_rate - this.us_writecycles;
        int ff = this.jusbsidBuilder.ff();
        if (cycles > 0 && cycles <= this.raster_rate) {
            this.usbsid.USBSID_delay((short)(cycles >> ff));
        }
        this.usbsid.USBSID_setflush();
        usid_main_clk = now;
        this.us_writecycles = 0;
        return this.raster_rate;
    }

    @Override
    public void write(int addr, byte data) {
        switch (addr & 0x1F) {
            case 4: 
            case 11: 
            case 18: {
                if (this.voiceMute[(addr - 4) / 7]) {
                    data = (byte)(data & 0xFFFFFFFE);
                }
                super.write(addr, data);
                break;
            }
            case 23: {
                if (this.filterDisable[this.sidNum]) {
                    data = (byte)(data & 0xFFFFFFF0);
                }
                super.write(addr, data);
                break;
            }
            case 24: {
                if (this.voiceMute[3] && (data & 0xF) < (this.readInternalRegister(addr) & 0xF)) {
                    return;
                }
                super.write(addr, data);
                break;
            }
            default: {
                super.write(addr, data);
            }
        }
        byte dataByte = data;
        if (addr > 24) {
            return;
        }
        this.doWriteDelayed(() -> {
            if (!Objects.equals(this.jusbsidBuilder.lastSidNum, this.sidNum)) {
                this.jusbsidBuilder.lastSidNum = this.sidNum;
            }
            short cycles = (short)this.us_delay();
            this.usbsid.USBSID_writeclkdbuffer((byte)(this.sidNum * 32 + addr & 0xFF), (byte)(dataByte & 0xFF), cycles);
            this.us_writecycles = (short)(this.us_writecycles + cycles);
        });
    }

    private void doWriteDelayed(Runnable runnable) {
        if (this.jusbsidBuilder.getDelay(this.sidNum) > 0) {
            this.context.schedule(Event.of("Delayed SID output", event -> runnable.run()), this.jusbsidBuilder.getDelay(this.sidNum));
        } else {
            runnable.run();
        }
    }

    protected boolean lock() {
        this.usbsid.USBSID_reset((byte)15);
        try {
            Thread.sleep(50L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        this.reset((byte)15);
        this.raster_rate = (short)this.us_cyclesPerFrame;
        usid_main_clk = this.context.getTime(Event.Phase.PHI2);
        usid_alarm_clk = this.raster_rate;
        this.context.schedule(this.frame_event, 0L, Event.Phase.PHI2);
        return true;
    }

    protected void unlock() {
        this.usbsid.USBSID_reset((byte)0);
        try {
            Thread.sleep(50L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        usid_main_clk = 0L;
        usid_alarm_clk = 0L;
        this.reset((byte)0);
        this.context.cancel(this.frame_event);
    }

    @Override
    public void setVoiceMute(int num, boolean mute) {
        super.setVoiceMute(num, mute);
        if (num < 4) {
            this.voiceMute[num] = mute;
        }
    }

    @Override
    public void setFilterEnable(IEmulationSection emulation, int sidNum) {
        super.setFilterEnable(emulation, sidNum);
        this.filterDisable[sidNum] = !emulation.isFilterEnable(sidNum);
    }

    public byte getDeviceId() {
        return this.deviceID;
    }

    public String getDeviceName() {
        return this.deviceName;
    }

    public void setDeviceName(String deviceName) {
        this.deviceName = deviceName;
    }

    protected ChipModel getChipModel() {
        return this.chipModel;
    }

    public static final String credits() {
        StringBuffer credits = new StringBuffer();
        credits.append("Original Java code by Ken H\u00e4ndel <kschwiersch@yahoo.de> Copyright (\u00a9) 2021\n");
        credits.append("USBSID code implementation, hardware and driver code by LouD\n");
        credits.append("\thttp://github.com/LouDnl/USBSID-Pico\n");
        return credits.toString();
    }

    public static class FakeStereo
    extends USBSIDEmu {
        private final IEmulationSection emulationSection;
        private final int prevNum;
        private final List<USBSIDEmu> sids;

        public FakeStereo(JUSBSIDBuilder jusbsidBuilder, EventScheduler context, CPUClock cpuClock, USBSID usbsid, byte deviceId, int sidNum, ChipModel model, ChipModel defaultChipModel, boolean stereo, List<USBSIDEmu> sids, IEmulationSection emulationSection) {
            super(jusbsidBuilder, context, cpuClock, usbsid, deviceId, sidNum, model, defaultChipModel, stereo);
            this.prevNum = sidNum - 1;
            this.sids = sids;
            this.emulationSection = emulationSection;
        }

        @Override
        public byte read(int addr) {
            if (this.emulationSection.getSidToRead().getSidNum() <= this.prevNum) {
                return this.sids.get(this.prevNum).read(addr);
            }
            return super.read(addr);
        }

        @Override
        public byte readInternalRegister(int addr) {
            if (this.emulationSection.getSidToRead().getSidNum() <= this.prevNum) {
                return this.sids.get(this.prevNum).readInternalRegister(addr);
            }
            return super.readInternalRegister(addr);
        }

        @Override
        public void write(int addr, byte data) {
            super.write(addr, data);
            this.sids.get(this.prevNum).write(addr, data);
        }
    }
}

