/*
 * Decompiled with CFR 0.152.
 */
package client.teavm;

import client.teavm.common.IImportedApi;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import libsidplay.components.printer.IPaper;

public class ImportedApiWav
implements IImportedApi {
    private DataOutputStream out;

    public ImportedApiWav(DataOutputStream out, int sampleRate, int numSamples) {
        try {
            this.out = out;
            int numChannels = 2;
            int bitsPerSample = 16;
            int byteRate = sampleRate * numChannels * bitsPerSample / 8;
            int blockAlign = numChannels * bitsPerSample / 8;
            int dataSize = numSamples * blockAlign;
            out.writeBytes("RIFF");
            out.writeInt(Integer.reverseBytes(36 + dataSize));
            out.writeBytes("WAVE");
            out.writeBytes("fmt ");
            out.writeInt(Integer.reverseBytes(16));
            out.writeShort(Short.reverseBytes((short)1));
            out.writeShort(Short.reverseBytes((short)numChannels));
            out.writeInt(Integer.reverseBytes(sampleRate));
            out.writeInt(Integer.reverseBytes(byteRate));
            out.writeShort(Short.reverseBytes((short)blockAlign));
            out.writeShort(Short.reverseBytes((short)bitsPerSample));
            out.writeBytes("data");
            out.writeInt(Integer.reverseBytes(dataSize));
        }
        catch (IOException e) {
            throw new RuntimeException("Error writing WAV audio stream", e);
        }
    }

    @Override
    public void initControlBuffer() {
    }

    @Override
    public ByteBuffer initSampleBuffer(int chunkFrames, int channels) {
        return ByteBuffer.allocate(chunkFrames * 2 * channels).order(ByteOrder.LITTLE_ENDIAN);
    }

    @Override
    public ByteBuffer initPixelBuffer(int maxWidth, int maxHeight) {
        return null;
    }

    @Override
    public ByteBuffer initGaugeBuffer(String type, int chipNum, int pathLength) {
        return null;
    }

    @Override
    public void processSamples(ByteBuffer sampleBuffer, float[] lookupTable) {
        try {
            ((Buffer)sampleBuffer).flip();
            int remaining = sampleBuffer.remaining() >> 2;
            for (int i = 0; i < remaining; ++i) {
                this.out.writeShort(Short.reverseBytes(sampleBuffer.getShort()));
                this.out.writeShort(Short.reverseBytes(sampleBuffer.getShort()));
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Error writing WAV audio stream", e);
        }
    }

    @Override
    public void processPixels(ByteBuffer pixels) {
    }

    @Override
    public void processOsc(int sidNum, ByteBuffer wav0, String wav0Txt, ByteBuffer wav1, String wav1Txt, ByteBuffer wav2, String wav2Txt, ByteBuffer env0, String env0Txt, ByteBuffer env1, String env1Txt, ByteBuffer env2, String env2Txt, ByteBuffer fre0, String frq0Txt, ByteBuffer frq1, String frq1Txt, ByteBuffer frq2, String frq2Txt, ByteBuffer vol, String volTxt, ByteBuffer res, String resTxt, ByteBuffer fil, String filTxt) {
    }

    @Override
    public void processSidWrite(long absTime, int relTime, int addr, int value) {
    }

    @Override
    public void processTimerEnd(double end) {
    }

    @Override
    public void processPrinter(IPaper.Outputs output) {
    }

    @Override
    public void whatsSid(byte[] array) {
    }
}

