/*
 * Decompiled with CFR 0.152.
 */
package client.teavm.common.oscilloscope;

import builder.resid.ReSIDBase;
import client.teavm.common.oscilloscope.Gauge;
import java.nio.ByteBuffer;
import java.util.function.Function;
import java.util.function.Supplier;
import libsidplay.common.SIDEmu;

public class EnvelopeGauge
extends Gauge {
    private int voice;

    public EnvelopeGauge(int width, int height, int voice, Function<String, String> localizer, Supplier<ByteBuffer> initGaugeBuffer) {
        super(width, height, initGaugeBuffer);
        this.voice = voice;
        this.text = localizer.apply("ENVELOPE");
    }

    public Gauge sample(SIDEmu sidemu) {
        if (sidemu instanceof ReSIDBase) {
            this.accumulate(this.getValue(((ReSIDBase)sidemu).readENV(this.voice)));
        } else {
            this.accumulate(0.0f);
        }
        return this;
    }

    private float getValue(byte envOutput) {
        float value = -48.0f;
        if (envOutput != 0) {
            value = (float)(Math.log((float)(envOutput & 0xFF) / 255.0f) / Math.log(10.0) * 20.0);
        }
        return 1.0f + value / 48.0f;
    }
}

