/*
 * Decompiled with CFR 0.152.
 */
package client.teavm.common.video;

import client.teavm.common.IImportedApi;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import libsidplay.common.CPUClock;
import libsidplay.components.mos656x.IPALEmulation;
import libsidplay.components.mos656x.IPalette;

public class PALEmulationTeaVM
implements IPALEmulation {
    private final int[] vicPaletteNoPal = new int[]{255, -1, 1748446207, 1889841919, 1866303231, 1485652991, 891845119, -1194889217, 1867458047, 1127809279, -1704502785, 0x444444FF, 0x6C6C6CFF, -1697479425, 1818146303, -1785358849};
    private final int nthFrame;
    private final int[] combinedLinesEven;
    private final int[] combinedLinesOdd;
    private final byte[] linePaletteEven;
    private final byte[] linePaletteOdd;
    private final byte[] previousLineDecodedColor = new byte[520];
    private int[] combinedLinesCurrent;
    private byte[] linePaletteCurrent;
    private int previousLineIndex;
    private int oldGraphicsData;
    private int n;
    private ByteBuffer pixels;
    private boolean palEmulationEnable;

    public PALEmulationTeaVM(IImportedApi importedApi, int nthFrame, CPUClock cpuClock, int[] combinedLinesEven, int[] combinedLinesOdd, byte[] linePaletteEven, byte[] linePaletteOdd) {
        this.nthFrame = nthFrame;
        this.combinedLinesEven = combinedLinesEven;
        this.combinedLinesOdd = combinedLinesOdd;
        this.linePaletteEven = linePaletteEven;
        this.linePaletteOdd = linePaletteOdd;
        this.combinedLinesCurrent = combinedLinesEven;
        this.linePaletteCurrent = linePaletteEven;
        this.pixels = importedApi.initPixelBuffer(384, cpuClock == CPUClock.PAL ? 285 : 263);
    }

    @Override
    public void determineCurrentPalette(int rasterY, boolean isFrameStart) {
        if (isFrameStart && ++this.n == this.nthFrame) {
            ((Buffer)this.pixels).clear();
            this.n = 0;
            if (this.palEmulationEnable) {
                this.linePaletteCurrent = (rasterY & 1) != 0 ? this.linePaletteEven : this.linePaletteOdd;
                this.combinedLinesCurrent = (rasterY & 1) != 0 ? this.combinedLinesEven : this.combinedLinesOdd;
                for (int i = 0; i < this.previousLineDecodedColor.length; ++i) {
                    this.previousLineDecodedColor[i] = this.linePaletteCurrent[0];
                }
            }
        }
        if (this.palEmulationEnable && this.n == 0) {
            this.linePaletteCurrent = this.linePaletteCurrent == this.linePaletteOdd ? this.linePaletteEven : this.linePaletteOdd;
            this.combinedLinesCurrent = this.combinedLinesCurrent == this.combinedLinesOdd ? this.combinedLinesEven : this.combinedLinesOdd;
            this.oldGraphicsData = 0;
            this.previousLineIndex = 0;
        }
    }

    @Override
    public void drawPixels(int graphicsDataBuffer) {
        block5: {
            block4: {
                if (!this.palEmulationEnable || this.n != 0) break block4;
                for (int j = 0; j < 2; ++j) {
                    this.oldGraphicsData |= graphicsDataBuffer >>> 16;
                    for (int i = 0; i < 4; ++i) {
                        this.oldGraphicsData <<= 4;
                        byte lineColor = this.linePaletteCurrent[this.oldGraphicsData >>> 16];
                        byte previousLineColor = this.previousLineDecodedColor[this.previousLineIndex];
                        this.previousLineDecodedColor[this.previousLineIndex++] = lineColor;
                        this.pixels.putInt(this.combinedLinesCurrent[lineColor & 0xFF | previousLineColor << 8 & 0xFF00] << 8 | 0xFF);
                    }
                    graphicsDataBuffer <<= 16;
                }
                break block5;
            }
            if (this.n != 0) break block5;
            for (int j = 0; j < 2; ++j) {
                this.oldGraphicsData |= graphicsDataBuffer >>> 16;
                for (int i = 0; i < 4; ++i) {
                    this.oldGraphicsData <<= 4;
                    this.pixels.putInt(this.vicPaletteNoPal[this.oldGraphicsData >>> 16 & 0xF]);
                }
                graphicsDataBuffer <<= 16;
            }
        }
    }

    @Override
    public void updatePalette() {
    }

    @Override
    public void setPalEmulationEnable(boolean palEmulationEnable) {
        this.palEmulationEnable = palEmulationEnable;
    }

    @Override
    public void setVicPaletteNoPal(int[] vicPaletteNoPal) {
        assert (vicPaletteNoPal.length == 16);
        System.arraycopy(vicPaletteNoPal, 0, this.vicPaletteNoPal, 0, vicPaletteNoPal.length);
    }

    @Override
    public IPalette getPalette() {
        return new IPalette(){

            @Override
            public void setTint(float tint) {
            }

            @Override
            public void setSaturation(float saturation) {
            }

            @Override
            public void setPhaseShift(float phaseShift) {
            }

            @Override
            public void setOffset(float offset) {
            }

            @Override
            public void setLuminanceC(float luminanceC) {
            }

            @Override
            public void setGamma(float gamma) {
            }

            @Override
            public void setDotCreep(float dotCreep) {
            }

            @Override
            public void setContrast(float contrast) {
            }

            @Override
            public void setBrightness(float brightness) {
            }
        };
    }

    @Override
    public ByteBuffer getPixels() {
        return this.pixels;
    }

    @Override
    public void reset() {
        ((Buffer)this.pixels).clear();
        for (int i = 0; i < this.pixels.capacity() >> 2; ++i) {
            this.pixels.putInt(255);
        }
        ((Buffer)this.pixels).clear();
    }
}

