/*
 * Decompiled with CFR 0.152.
 */
package libsidplay.components.cart.supported;

import java.io.DataInputStream;
import java.io.IOException;
import libsidplay.components.cart.Cartridge;
import libsidplay.components.pla.Bank;
import libsidplay.components.pla.PLA;

public class Expert
extends Cartridge {
    protected final byte[] ram;
    protected boolean ultimaxHackOn;
    private final Bank io1Bank = new Bank(){

        @Override
        public byte read(int address) {
            Expert.this.ultimaxHackOn = false;
            Expert.this.pla.setGameExrom(true, true);
            return 0;
        }

        @Override
        public void write(int address, byte value) {
            Expert.this.ultimaxHackOn = false;
            Expert.this.pla.setGameExrom(true, true);
        }
    };
    private final Bank romlBank = new Bank(){

        @Override
        public byte read(int address) {
            return Expert.this.ram[address & 0x1FFF];
        }

        @Override
        public void write(int address, byte value) {
            Expert.this.ram[address & 0x1FFF] = value;
        }
    };
    private final Bank romhBank = new Bank(){

        @Override
        public byte read(int address) {
            return Expert.this.ram[address & 0x1FFF];
        }

        @Override
        public void write(int address, byte value) {
        }
    };

    @Override
    public void changedNMI(boolean state) {
        if (state) {
            this.ultimaxHackOn = true;
            this.pla.setGameExrom(true, true);
        }
    }

    public Expert(DataInputStream dis, PLA pla) throws IOException {
        super(pla);
        byte[] chipHeader = new byte[16];
        dis.readFully(chipHeader);
        int bankLen = (chipHeader[14] & 0xFF) << 8;
        this.ram = new byte[bankLen];
        dis.readFully(this.ram);
    }

    @Override
    public Bank getRoml() {
        return this.romlBank;
    }

    @Override
    public Bank getRomh() {
        return this.romhBank;
    }

    @Override
    public void installBankHooks(Bank[] cpuReadMap, Bank[] cpuWriteMap) {
        if (!this.ultimaxHackOn) {
            return;
        }
        cpuReadMap[8] = cpuWriteMap[8] = this.romlBank;
        cpuReadMap[9] = cpuWriteMap[9] = this.romlBank;
        cpuReadMap[14] = cpuWriteMap[14] = this.romhBank;
        cpuReadMap[15] = cpuWriteMap[15] = this.romhBank;
    }

    @Override
    public Bank getIO1() {
        return this.io1Bank;
    }

    @Override
    public void reset() {
        super.reset();
        this.ultimaxHackOn = false;
        this.pla.setGameExrom(true, true);
    }
}

