/*
 * Decompiled with CFR 0.152.
 */
package libsidplay.sidtune;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collection;
import libsidplay.common.CPUClock;
import libsidplay.common.ChipModel;
import libsidplay.config.IEmulationSection;
import libsidplay.config.ISidPlay2SystemProperties;
import libsidplay.sidtune.MD5Method;
import libsidplay.sidtune.MP3Tune;
import libsidplay.sidtune.Mus;
import libsidplay.sidtune.P00;
import libsidplay.sidtune.PSid;
import libsidplay.sidtune.Prg;
import libsidplay.sidtune.SidTuneError;
import libsidplay.sidtune.SidTuneInfo;
import libsidplay.sidtune.T64;
import libsidutils.ZipFileUtils;
import libsidutils.sidid.SidIdInfo;

public abstract class SidTune {
    public static final SidTune RESET = null;
    public static final int RESET_INIT_DELAY = 2500000;
    public static boolean USE_KICKASSEMBLER;
    private static final int MAX_MEM_64K = 65536;
    protected SidTuneInfo info = new SidTuneInfo();

    public static SidTune load(File file) throws IOException, SidTuneError {
        try {
            return MP3Tune.load(file);
        }
        catch (SidTuneError mp3Error) {
            byte[] fileContents = SidTune.getContents(file);
            try {
                return SidTune.load(file.getName(), fileContents);
            }
            catch (SidTuneError commonError) {
                try {
                    return Mus.load(file, fileContents);
                }
                catch (SidTuneError musError) {
                    throw (SidTuneError)mp3Error.initCause(musError.initCause(commonError));
                }
            }
        }
    }

    public static SidTune load(String url, InputStream stream) throws IOException, SidTuneError {
        return SidTune.load(url, SidTune.getContents(stream));
    }

    protected static SidTune load(String name, byte[] fileContents) throws SidTuneError {
        try {
            return PSid.load(name, fileContents);
        }
        catch (SidTuneError psidError) {
            try {
                return Prg.load(name, fileContents);
            }
            catch (SidTuneError prgError) {
                try {
                    return P00.load(name, fileContents);
                }
                catch (SidTuneError p00Error) {
                    try {
                        return T64.load(name, fileContents);
                    }
                    catch (SidTuneError t64Error) {
                        throw (SidTuneError)t64Error.initCause(p00Error.initCause(prgError.initCause(psidError)));
                    }
                }
            }
        }
    }

    public byte[] getPSidHeader() {
        return null;
    }

    protected static final byte[] getContents(File file) throws IOException {
        try (InputStream is = ZipFileUtils.newFileInputStream(file);){
            byte[] byArray = SidTune.getContents(is);
            return byArray;
        }
    }

    private static byte[] getContents(InputStream stream) throws IOException {
        int len;
        int count;
        byte[] fileBuf = new byte[65536];
        for (len = 0; len < 65536 && (count = stream.read(fileBuf, len, 65536 - len)) >= 0; len += count) {
        }
        return Arrays.copyOf(fileBuf, len);
    }

    public final SidTuneInfo getInfo() {
        return this.info;
    }

    public Speed getSongSpeed(int selected) {
        return Speed.CIA_1A;
    }

    public int getSongSpeedWord() {
        return -1;
    }

    public static boolean isFakeStereoSid(IEmulationSection emulation, SidTune tune, int sidNum) {
        return sidNum > 0 && SidTune.getSIDAddress(emulation, tune, sidNum - 1) == SidTune.getSIDAddress(emulation, tune, sidNum);
    }

    public static boolean isSIDUsed(IEmulationSection emulation, SidTune tune, int sidNum) {
        return SidTune.getSIDAddress(emulation, tune, sidNum) != 0;
    }

    public static int getSIDAddress(IEmulationSection emulation, SidTune tune, int sidNum) {
        int tuneChipBase;
        int forcedSidBase;
        boolean forcedStereoTune = emulation.isForceStereo(sidNum);
        int overrideSidBase = emulation.getOverrideSection().getSidBase()[sidNum];
        switch (sidNum) {
            case 0: {
                return 54272;
            }
            case 1: {
                forcedSidBase = emulation.getDualSidBase();
                int n = tuneChipBase = tune != RESET ? tune.getInfo().getSIDChipBase(sidNum) : 0;
                if (tuneChipBase != 0 || forcedStereoTune || !emulation.isFakeStereo()) break;
                return 54272;
            }
            case 2: {
                forcedSidBase = emulation.getThirdSIDBase();
                tuneChipBase = tune != RESET ? tune.getInfo().getSIDChipBase(sidNum) : 0;
                break;
            }
            default: {
                if (sidNum < ISidPlay2SystemProperties.MAX_SIDS) {
                    forcedSidBase = 0;
                    tuneChipBase = tune != RESET ? tune.getInfo().getSIDChipBase(sidNum) : 0;
                    break;
                }
                throw new RuntimeException("Maximum supported SIDS exceeded!");
            }
        }
        return forcedStereoTune ? forcedSidBase : (overrideSidBase != 0 ? overrideSidBase : tuneChipBase);
    }

    public abstract Integer placeProgramInMemory(byte[] var1);

    public abstract Integer placeProgramInMemory(byte[] var1, byte[] var2);

    public abstract void save(String var1) throws IOException;

    public abstract Collection<String> identify();

    public abstract Collection<String> identify(byte[] var1);

    public abstract SidIdInfo.PlayerInfoSection getPlayerInfo(String var1);

    public abstract SidIdInfo.PlayerInfoSection getPlayerInfo(String var1, byte[] var2);

    public abstract String getMD5Digest(MD5Method var1);

    protected abstract long getInitDelay();

    public static long getInitDelay(SidTune tune) {
        return tune != RESET ? tune.getInitDelay() : 2500000L;
    }

    public void prepare() {
    }

    public static enum Speed {
        VBI(0),
        CIA_1A(60);

        private int speed;

        private Speed(int speed) {
            this.speed = speed;
        }

        public int speedValue() {
            return this.speed;
        }
    }

    public static enum Compatibility {
        PSIDv1,
        PSIDv2,
        PSIDv3,
        PSIDv4,
        PSIDv4E,
        RSID_BASIC,
        RSIDv2,
        RSIDv3,
        RSIDv4E;

    }

    public static enum Model {
        UNKNOWN(null),
        MOS6581(ChipModel.MOS6581),
        MOS8580(ChipModel.MOS8580),
        ANY(null);

        private ChipModel chipModel;

        private Model(ChipModel chipModel) {
            this.chipModel = chipModel;
        }

        public ChipModel asChipModel() {
            return this.chipModel;
        }
    }

    public static enum Clock {
        UNKNOWN(null),
        PAL(CPUClock.PAL),
        NTSC(CPUClock.NTSC),
        ANY(null);

        private CPUClock cpuClock;

        private Clock(CPUClock cpuClock) {
            this.cpuClock = cpuClock;
        }

        public CPUClock asCPUClock() {
            return this.cpuClock;
        }
    }
}

