/*
 * Decompiled with CFR 0.152.
 */
package libsidutils.debug;

import java.util.logging.Level;
import java.util.logging.Logger;
import libsidplay.common.Event;
import libsidplay.common.EventScheduler;
import libsidplay.components.mos6510.MOS6510;
import libsidutils.disassembler.IMOS6510Disassembler;
import libsidutils.disassembler.SimpleDisassembler;

public class MOS6510Debug
extends MOS6510 {
    protected static final Logger MOS6510 = Logger.getLogger(MOS6510.class.getName());
    protected int instrStartPC;
    protected int instrOperand;
    protected IMOS6510Disassembler disassembler = SimpleDisassembler.getInstance();

    public MOS6510Debug(EventScheduler context) {
        super(context);
    }

    @Override
    protected void FetchHighAddr() {
        super.FetchHighAddr();
        this.instrOperand = this.Cycle_EffectiveAddress;
    }

    @Override
    protected void FetchLowPointer() {
        super.FetchLowPointer();
        this.instrOperand = this.Cycle_Pointer;
    }

    @Override
    protected void FetchHighPointer() {
        super.FetchHighPointer();
        this.instrOperand = this.Cycle_Pointer;
    }

    @Override
    protected void interrupt() {
        if (MOS6510.isLoggable(Level.FINE)) {
            long cycles = this.context.getTime(Event.Phase.PHI2);
            MOS6510.fine("****************************************************");
            MOS6510.fine(String.format(" interrupt (%d)", cycles));
            MOS6510.fine("****************************************************");
            this.dumpState(cycles, this);
        }
        super.interrupt();
    }

    @Override
    protected void interruptEnd() {
        if (MOS6510.isLoggable(Level.FINE)) {
            MOS6510.fine("****************************************************");
        }
        super.interruptEnd();
    }

    @Override
    protected void fetchNextOpcode() {
        if (MOS6510.isLoggable(Level.FINE)) {
            this.dumpState(this.context.getTime(Event.Phase.PHI2), this);
        }
        this.instrStartPC = this.Register_ProgramCounter;
        super.fetchNextOpcode();
    }

    protected void dumpState(long time, MOS6510 cpu) {
        String m_fdbg = this.getState(time);
        MOS6510.info(m_fdbg);
    }

    protected String getState(long time) {
        StringBuffer m_fdbg = new StringBuffer();
        m_fdbg.append(String.format(" PC  I  A  X  Y  SP  DR PR NV-BDIZC  Instruction (%d)\n", time));
        m_fdbg.append(String.format("%04x ", this.instrStartPC));
        m_fdbg.append(this.irqAssertedOnPin ? "t" : "f");
        m_fdbg.append(String.format("%02x ", this.Register_Accumulator & 0xFF));
        m_fdbg.append(String.format("%02x ", this.Register_X & 0xFF));
        m_fdbg.append(String.format("%02x ", this.Register_Y & 0xFF));
        m_fdbg.append(String.format("%02x%02x ", (byte)1, this.Register_StackPointer & 0xFF));
        m_fdbg.append(String.format("%02x ", this.cpuRead.apply(0)));
        m_fdbg.append(String.format("%02x ", this.cpuRead.apply(1)));
        m_fdbg.append(this.flagN ? "1" : "0");
        m_fdbg.append(this.flagV ? "1" : "0");
        m_fdbg.append(this.flagU ? "1" : "0");
        m_fdbg.append(this.flagB ? "1" : "0");
        m_fdbg.append(this.flagD ? "1" : "0");
        m_fdbg.append(this.flagI ? "1" : "0");
        m_fdbg.append(this.flagZ ? "1" : "0");
        m_fdbg.append(this.flagC ? "1" : "0");
        int opcode = this.cycleCount >> 3;
        m_fdbg.append(String.format("  %02x ", opcode));
        switch (opcode) {
            case 10: 
            case 42: 
            case 74: 
            case 106: {
                m_fdbg.append("      ");
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 132: 
            case 133: 
            case 134: 
            case 135: 
            case 164: 
            case 165: 
            case 166: 
            case 167: 
            case 196: 
            case 197: 
            case 198: 
            case 199: 
            case 228: 
            case 229: 
            case 230: 
            case 231: {
                m_fdbg.append(String.format("%02x    ", this.instrOperand));
                break;
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 148: 
            case 149: 
            case 180: 
            case 181: 
            case 212: 
            case 213: 
            case 214: 
            case 215: 
            case 244: 
            case 245: 
            case 246: 
            case 247: {
                m_fdbg.append(String.format("%02x    ", this.instrOperand & 0xFF));
                break;
            }
            case 150: 
            case 151: 
            case 182: 
            case 183: {
                m_fdbg.append(String.format("%02x    ", this.instrOperand));
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 32: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 109: 
            case 110: 
            case 111: 
            case 140: 
            case 141: 
            case 142: 
            case 143: 
            case 172: 
            case 173: 
            case 174: 
            case 175: 
            case 204: 
            case 205: 
            case 206: 
            case 207: 
            case 236: 
            case 237: 
            case 238: 
            case 239: {
                m_fdbg.append(String.format("%02x %02x ", this.instrOperand & 0xFF, this.instrOperand >> 8));
                break;
            }
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 124: 
            case 125: 
            case 126: 
            case 127: 
            case 156: 
            case 157: 
            case 188: 
            case 189: 
            case 220: 
            case 221: 
            case 222: 
            case 223: 
            case 252: 
            case 253: 
            case 254: 
            case 255: {
                m_fdbg.append(String.format("%02x %02x ", this.instrOperand & 0xFF, this.instrOperand >> 8));
                break;
            }
            case 25: 
            case 27: 
            case 57: 
            case 59: 
            case 89: 
            case 91: 
            case 121: 
            case 123: 
            case 153: 
            case 155: 
            case 158: 
            case 159: 
            case 185: 
            case 187: 
            case 190: 
            case 191: 
            case 217: 
            case 219: 
            case 249: 
            case 251: {
                m_fdbg.append(String.format("%02x %02x ", this.instrOperand & 0xFF, this.instrOperand >> 8));
                break;
            }
            case 9: 
            case 11: 
            case 16: 
            case 41: 
            case 43: 
            case 48: 
            case 73: 
            case 75: 
            case 80: 
            case 105: 
            case 107: 
            case 112: 
            case 128: 
            case 130: 
            case 137: 
            case 139: 
            case 144: 
            case 160: 
            case 162: 
            case 169: 
            case 171: 
            case 176: 
            case 192: 
            case 194: 
            case 201: 
            case 203: 
            case 208: 
            case 224: 
            case 226: 
            case 233: 
            case 235: 
            case 240: {
                m_fdbg.append(String.format("%02x    ", this.Cycle_Data & 0xFF));
                break;
            }
            case 108: {
                m_fdbg.append(String.format("%02x %02x ", this.instrOperand & 0xFF, this.instrOperand >> 8));
                break;
            }
            case 1: 
            case 3: 
            case 33: 
            case 35: 
            case 65: 
            case 67: 
            case 97: 
            case 99: 
            case 129: 
            case 131: 
            case 161: 
            case 163: 
            case 193: 
            case 195: 
            case 225: 
            case 227: {
                m_fdbg.append(String.format("%02x    ", this.instrOperand));
                break;
            }
            case 17: 
            case 19: 
            case 49: 
            case 51: 
            case 81: 
            case 83: 
            case 113: 
            case 115: 
            case 145: 
            case 147: 
            case 177: 
            case 179: 
            case 209: 
            case 211: 
            case 241: 
            case 243: {
                m_fdbg.append(String.format("%02x    ", this.instrOperand));
                break;
            }
            default: {
                m_fdbg.append("      ");
            }
        }
        m_fdbg.append(this.disassembler.disassemble(opcode, this.instrOperand, this.Cycle_EffectiveAddress));
        switch (opcode) {
            case 5: 
            case 6: 
            case 7: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 69: 
            case 70: 
            case 71: 
            case 101: 
            case 102: 
            case 103: 
            case 164: 
            case 165: 
            case 166: 
            case 167: 
            case 196: 
            case 197: 
            case 198: 
            case 199: 
            case 228: 
            case 229: 
            case 230: 
            case 231: {
                m_fdbg.append(String.format(" {%02x}", this.Cycle_Data));
                break;
            }
            case 21: 
            case 22: 
            case 23: 
            case 53: 
            case 54: 
            case 55: 
            case 85: 
            case 86: 
            case 87: 
            case 117: 
            case 118: 
            case 119: 
            case 180: 
            case 181: 
            case 213: 
            case 214: 
            case 215: 
            case 245: 
            case 246: 
            case 247: {
                m_fdbg.append(String.format(" [%04x]{%02x}", this.Cycle_EffectiveAddress, this.Cycle_Data));
                break;
            }
            case 20: 
            case 52: 
            case 84: 
            case 116: 
            case 148: 
            case 149: 
            case 212: 
            case 244: {
                m_fdbg.append(String.format(" [%04x]", this.Cycle_EffectiveAddress));
                break;
            }
            case 182: 
            case 183: {
                m_fdbg.append(String.format(" [%04x]{%02x}", this.Cycle_EffectiveAddress, this.Cycle_Data));
                break;
            }
            case 150: 
            case 151: {
                m_fdbg.append(String.format(" [%04x]", this.Cycle_EffectiveAddress));
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 77: 
            case 78: 
            case 79: 
            case 109: 
            case 110: 
            case 111: 
            case 172: 
            case 173: 
            case 174: 
            case 175: 
            case 204: 
            case 205: 
            case 206: 
            case 207: 
            case 236: 
            case 237: 
            case 238: 
            case 239: {
                m_fdbg.append(String.format(" {%02x}", this.Cycle_Data));
                break;
            }
            case 29: 
            case 30: 
            case 31: 
            case 61: 
            case 62: 
            case 63: 
            case 93: 
            case 94: 
            case 95: 
            case 125: 
            case 126: 
            case 127: 
            case 188: 
            case 189: 
            case 221: 
            case 222: 
            case 223: 
            case 253: 
            case 254: 
            case 255: {
                m_fdbg.append(String.format(" [%04x]{%02x}", this.Cycle_EffectiveAddress, this.Cycle_Data));
                break;
            }
            case 28: 
            case 60: 
            case 92: 
            case 124: 
            case 156: 
            case 157: 
            case 220: 
            case 252: {
                m_fdbg.append(String.format(" [%04x]", this.Cycle_EffectiveAddress));
                break;
            }
            case 25: 
            case 27: 
            case 57: 
            case 59: 
            case 89: 
            case 91: 
            case 121: 
            case 123: 
            case 155: 
            case 185: 
            case 187: 
            case 190: 
            case 191: 
            case 217: 
            case 219: 
            case 249: 
            case 251: {
                m_fdbg.append(String.format(" [%04x]{%02x}", this.Cycle_EffectiveAddress, this.Cycle_Data));
                break;
            }
            case 153: 
            case 158: 
            case 159: {
                m_fdbg.append(String.format(" [%04x]", this.Cycle_EffectiveAddress));
                break;
            }
            case 16: 
            case 48: 
            case 80: 
            case 112: 
            case 144: 
            case 176: 
            case 208: 
            case 240: {
                break;
            }
            case 108: {
                m_fdbg.append(String.format(" [%04x]", this.Cycle_EffectiveAddress));
                break;
            }
            case 1: 
            case 3: 
            case 33: 
            case 35: 
            case 65: 
            case 67: 
            case 97: 
            case 99: 
            case 161: 
            case 163: 
            case 193: 
            case 195: 
            case 225: 
            case 227: {
                m_fdbg.append(String.format(" [%04x]{%02x}", this.Cycle_EffectiveAddress, this.Cycle_Data));
                break;
            }
            case 129: 
            case 131: {
                m_fdbg.append(String.format(" [%04x]", this.Cycle_EffectiveAddress));
                break;
            }
            case 17: 
            case 19: 
            case 49: 
            case 51: 
            case 81: 
            case 83: 
            case 113: 
            case 115: 
            case 177: 
            case 179: 
            case 209: 
            case 211: 
            case 241: 
            case 243: {
                m_fdbg.append(String.format(" [%04x]{%02x}", this.Cycle_EffectiveAddress, this.Cycle_Data));
                break;
            }
            case 145: 
            case 147: {
                m_fdbg.append(String.format(" [%04x]", this.Cycle_EffectiveAddress));
                break;
            }
        }
        return m_fdbg.toString();
    }
}

