/*
 * Decompiled with CFR 0.152.
 */
package libsidutils.oscilloscope;

import java.util.Arrays;
import libsidplay.common.SIDEmu;

public abstract class GaugeUtil {
    private static final int ALPHA = -16777216;
    private static final int[] gaugeColors = new int[256];
    private int width;
    private int height;
    private float[] dataMin = new float[256];
    private float[] dataMax = new float[256];
    private int dataPos = 0;

    public GaugeUtil(int width, int height) {
        this.width = width;
        this.height = height;
    }

    public void accumulate(float value) {
        if (value < this.dataMin[this.dataPos]) {
            this.dataMin[this.dataPos] = value;
        }
        if (value > this.dataMax[this.dataPos]) {
            this.dataMax[this.dataPos] = value;
        }
    }

    public void advance() {
        float min = this.dataMin[this.dataPos];
        float max = this.dataMax[this.dataPos];
        this.dataPos = this.dataPos + 1 & this.dataMin.length - 1;
        this.dataMin[this.dataPos] = max;
        this.dataMax[this.dataPos] = min;
    }

    public void reset() {
        Arrays.fill(this.dataMin, 0.0f);
        Arrays.fill(this.dataMax, 0.0f);
        this.dataPos = 0;
    }

    public void draw(SIDEmu sidemu) {
        int shade = 255;
        for (int x = 0; x < this.width; ++x) {
            int intEndPos;
            int intStartPos;
            float endPos;
            int readPos = this.dataPos - this.width + x & this.dataMin.length - 1;
            float startPos = (1.0f - this.dataMax[readPos]) * (float)(this.height - 1);
            if (startPos < 0.0f) {
                startPos = 0.0f;
            }
            if ((endPos = (1.0f - this.dataMin[readPos]) * (float)(this.height - 1)) > (float)(this.height - 1)) {
                endPos = this.height - 1;
            }
            if ((intStartPos = (int)Math.floor(startPos)) == (intEndPos = (int)Math.ceil(endPos))) {
                this.drawLine(x, intStartPos, x, intStartPos, gaugeColors[255]);
                continue;
            }
            float firstPixel = startPos - (float)intStartPos;
            if ((firstPixel = 1.0f - firstPixel) < 0.0f) {
                firstPixel = 0.0f;
            }
            if (firstPixel > 1.0f) {
                firstPixel = 1.0f;
            }
            float lastPixel = (float)intEndPos - endPos;
            if ((lastPixel = 1.0f - lastPixel) < 0.0f) {
                lastPixel = 0.0f;
            }
            if (lastPixel > 1.0f) {
                lastPixel = 1.0f;
            }
            this.drawLine(x, intStartPos, x, intStartPos, gaugeColors[(int)(255.0f * firstPixel)]);
            this.drawLine(x, intEndPos, x, intEndPos, gaugeColors[(int)(255.0f * lastPixel)]);
            if (++intStartPos > --intEndPos) continue;
            this.drawLine(x, intStartPos, x, intEndPos, gaugeColors[255]);
        }
    }

    protected abstract void drawLine(int var1, int var2, int var3, int var4, int var5);

    static {
        for (int i = 0; i < gaugeColors.length; ++i) {
            int color = Math.round((float)Math.sqrt((float)i / 255.0f) * 255.0f);
            GaugeUtil.gaugeColors[i] = 0xFF000000 | (color & 0xFF) << 8 | color >> 8;
        }
    }
}

