/*
 * Decompiled with CFR 0.152.
 */
package server.netsiddev;

import server.netsiddev.InvalidCommandException;

public final class SIDWrite {
    private final int chip;
    private final byte reg;
    private final byte value;
    private final int cycles;
    private boolean pureDelay;
    private boolean end;

    public SIDWrite(int chip, byte reg, byte data, int cycles) throws InvalidCommandException {
        if (reg < 0 || reg > 31) {
            throw new InvalidCommandException("Register value is not between 0 .. 0x1f: " + reg);
        }
        if (cycles < 0) {
            throw new InvalidCommandException("Cycle interval must be >= 0: " + cycles);
        }
        this.chip = chip;
        this.reg = reg;
        this.value = data;
        this.cycles = cycles;
        this.pureDelay = false;
        this.end = false;
    }

    private SIDWrite(int chip, int cycles) throws InvalidCommandException {
        this(chip, 0, 0, cycles);
        this.pureDelay = true;
    }

    private SIDWrite() {
        this.chip = 0;
        this.reg = 0;
        this.value = 0;
        this.cycles = 0;
        this.pureDelay = false;
        this.end = true;
    }

    public static SIDWrite makePureDelay(int sid, int cycles) throws InvalidCommandException {
        return new SIDWrite(sid, cycles);
    }

    protected boolean isPureDelay() {
        return this.pureDelay;
    }

    public static SIDWrite makeEnd() {
        return new SIDWrite();
    }

    protected boolean isEnd() {
        return this.end;
    }

    protected int getChip() {
        return this.chip;
    }

    protected byte getRegister() {
        return this.reg;
    }

    protected byte getValue() {
        return this.value;
    }

    protected int getCycles() {
        return this.cycles;
    }
}

