/*
 * Decompiled with CFR 0.152.
 */
package server.restful.common.filters;

import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.UnavailableException;
import jakarta.servlet.annotation.WebFilter;
import jakarta.servlet.http.HttpFilter;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;

@WebFilter(filterName="TimeDistanceBasedRateLimiterFilter", displayName="TimeDistanceBasedRateLimiterFilter", servletNames={"StartPageServlet"}, description="Ensure a minimum time between requests (kind of DDOS protection)")
public final class TimeDistanceBasedRateLimiterFilter
extends HttpFilter {
    public static final String FILTER_PARAMETER_MIN_TIME_BETWEEN_REQUESTS = "minTimeBetweenRequests";
    private final Map<String, Long> remoteAddrMap = new ConcurrentHashMap<String, Long>();
    private int minTimeBetweenRequests;

    public void init() throws ServletException {
        this.minTimeBetweenRequests = Integer.parseInt(Optional.ofNullable(this.getFilterConfig().getInitParameter(FILTER_PARAMETER_MIN_TIME_BETWEEN_REQUESTS)).orElseThrow(() -> new UnavailableException(FILTER_PARAMETER_MIN_TIME_BETWEEN_REQUESTS)));
    }

    public void doFilter(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws IOException, ServletException {
        Long lastTime = Optional.ofNullable(this.remoteAddrMap.put(request.getRemoteAddr(), System.currentTimeMillis())).orElse(0L);
        if (System.currentTimeMillis() - lastTime > (long)this.minTimeBetweenRequests) {
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
        } else {
            response.sendError(429, "Too Many Requests");
        }
    }

    public void destroy() {
        this.remoteAddrMap.clear();
    }
}

