/*
 * Decompiled with CFR 0.152.
 */
package server.restful.common.parameter.requestpath.impl;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import libsidutils.IOUtils;
import libsidutils.ZipFileUtils;
import net.java.truevfs.access.TFile;
import server.restful.common.parameter.ServletParameterParser;
import server.restful.common.parameter.UsageParameter;
import ui.common.comparator.FileComparator;
import ui.common.filefilter.FilteredFileFilter;
import ui.entities.config.Configuration;
import ui.entities.config.SidPlay2Section;

public abstract class DirectoryRequestPathServletParametersImpl
extends UsageParameter {
    public List<String> fetchDirectory(Configuration configuration, Properties directoryProperties, ServletParameterParser parser, boolean hasAdminAccess) {
        SidPlay2Section sidplay2Section = configuration.getSidplay2Section();
        String path = this.getDirectoryPath();
        if (path == null) {
            return null;
        }
        File filePath = new File(path);
        if (path.equals("/")) {
            List<String> files = this.fetchRoot(directoryProperties, hasAdminAccess, sidplay2Section.getHvsc(), sidplay2Section.getCgsc());
            if (files != null) {
                return files;
            }
        } else if (path.startsWith("/C64Music")) {
            List<String> files = this.fetchCollectionFiles(sidplay2Section.getHvsc(), "/C64Music", filePath);
            if (files != null) {
                return files;
            }
        } else if (path.startsWith("/CGSC")) {
            List<String> files = this.fetchCollectionFiles(sidplay2Section.getCgsc(), "/CGSC", filePath);
            if (files != null) {
                return files;
            }
        } else {
            for (String directoryLogicalName : directoryProperties.stringPropertyNames()) {
                TFile root;
                List<String> files;
                boolean needToBeAdmin;
                String[] splitted = directoryProperties.getProperty(directoryLogicalName).split(",");
                String directoryValue = splitted.length > 0 ? splitted[0] : null;
                boolean bl = needToBeAdmin = splitted.length > 1 ? Boolean.parseBoolean(splitted[1]) : false;
                if (needToBeAdmin && !hasAdminAccess || !path.startsWith(directoryLogicalName) || directoryValue == null || (files = this.fetchCollectionFiles((File)(root = new TFile(directoryValue)), directoryLogicalName, filePath)) == null) continue;
                return files;
            }
        }
        parser.setException(new FileNotFoundException(path));
        return null;
    }

    private List<String> fetchRoot(Properties directoryProperties, boolean adminRole, File hvscRoot, File cgscRoot) {
        ArrayList<String> result = new ArrayList<String>();
        if (hvscRoot != null) {
            result.add("/C64Music/");
        }
        if (cgscRoot != null) {
            result.add("/CGSC/");
        }
        directoryProperties.stringPropertyNames().stream().sorted().forEach(directoryLogicalName -> {
            boolean needToBeAdmin;
            String[] splitted = directoryProperties.getProperty((String)directoryLogicalName).split(",");
            boolean bl = needToBeAdmin = splitted.length > 1 ? Boolean.parseBoolean(splitted[1]) : false;
            if (!needToBeAdmin || adminRole) {
                result.add(directoryLogicalName + "/");
            }
        });
        return result;
    }

    private List<String> fetchCollectionFiles(File rootFile, String virtualCollectionRoot, File filePath) {
        if (rootFile == null) {
            return null;
        }
        File parentFile = ZipFileUtils.newFile(rootFile, filePath.toString().substring(virtualCollectionRoot.length()));
        String virtualParentFile = virtualCollectionRoot + IOUtils.getCollectionName(rootFile, parentFile);
        return Stream.concat(Stream.of(virtualParentFile + "/../"), Arrays.stream(Optional.ofNullable(parentFile.listFiles(new FilteredFileFilter(this.getFilter()))).orElse(new File[0])).sorted(new FileComparator()).map(file -> new File(virtualParentFile, file.getName()).toString().replace("\\", "/") + (file.isDirectory() ? "/" : ""))).collect(Collectors.toList());
    }

    public abstract String getDirectoryPath();

    public abstract String getFilter();
}

