/*
 * Decompiled with CFR 0.152.
 */
package sidplay.audio;

import com.xuggle.xuggler.ICodec;
import java.util.Arrays;
import java.util.List;
import libsidplay.common.SamplingRate;
import libsidplay.config.IAudioSection;
import sidplay.audio.xuggle.XuggleVideoDriver;

public abstract class AVIDriver
extends XuggleVideoDriver {
    @Override
    protected List<SamplingRate> getSupportedSamplingRates() {
        return Arrays.asList(SamplingRate.VERY_LOW, SamplingRate.LOW, SamplingRate.MEDIUM);
    }

    @Override
    protected SamplingRate getDefaultSamplingRate() {
        return SamplingRate.LOW;
    }

    @Override
    protected ICodec.ID getVideoCodec() {
        return ICodec.ID.CODEC_ID_H264;
    }

    @Override
    protected ICodec.ID getAudioCodec() {
        return ICodec.ID.CODEC_ID_MP3;
    }

    @Override
    protected String getOutputFormatName() {
        return "avi";
    }

    @Override
    public String getExtension() {
        return ".avi";
    }

    public static class AVIFileDriver
    extends AVIDriver {
        @Override
        protected String getUrl(IAudioSection audioSection, String recordingFilename) {
            System.out.println("Recording, file=" + recordingFilename);
            return recordingFilename;
        }
    }
}

