/*
 * Decompiled with CFR 0.152.
 */
package sidplay.audio;

import libsidplay.common.OS;
import libsidplay.config.IAudioSection;

public class AudioConfig {
    private final int frameRate;
    private final int channels;
    private int audioBufferSize;
    private int bufferFrames;

    public AudioConfig(IAudioSection audioSection) {
        this(audioSection.getSamplingRate().getFrequency(), 2, audioSection.getAudioBufferSize());
    }

    public AudioConfig(int frameRate, int channels, Integer audioBufferSize) {
        this.frameRate = frameRate;
        this.channels = channels;
        this.bufferFrames = this.audioBufferSize = audioBufferSize.intValue();
    }

    public final int getFrameRate() {
        return this.frameRate;
    }

    public final int getChunkFrames() {
        return Math.min(this.audioBufferSize, this.bufferFrames);
    }

    public final int getBufferFrames() {
        return this.bufferFrames;
    }

    public final void setBufferFrames(int bufferFrames) {
        this.bufferFrames = bufferFrames;
    }

    public final void setAudioBufferSize(int audioBufferSize) {
        this.audioBufferSize = audioBufferSize;
    }

    public final int getChannels() {
        return this.channels;
    }

    public static final int getDefaultBufferSize() {
        if (OS.get() == OS.LINUX) {
            return 16384;
        }
        return 2048;
    }
}

