/*
 * Decompiled with CFR 0.152.
 */
package sidplay.audio;

import com.xuggle.xuggler.ICodec;
import java.util.Arrays;
import java.util.List;
import libsidplay.common.SamplingRate;
import libsidplay.config.IAudioSection;
import sidplay.audio.xuggle.XuggleVideoDriver;

public abstract class FLVDriver
extends XuggleVideoDriver {
    @Override
    protected List<SamplingRate> getSupportedSamplingRates() {
        return Arrays.asList(SamplingRate.LOW);
    }

    @Override
    protected SamplingRate getDefaultSamplingRate() {
        return SamplingRate.LOW;
    }

    @Override
    protected ICodec.ID getVideoCodec() {
        return ICodec.ID.CODEC_ID_H264;
    }

    @Override
    protected ICodec.ID getAudioCodec() {
        return ICodec.ID.CODEC_ID_AAC;
    }

    @Override
    protected String getOutputFormatName() {
        return "flv";
    }

    @Override
    public String getExtension() {
        return ".flv";
    }

    public static class FLVStreamDriver
    extends FLVDriver {
        private final String url;

        public FLVStreamDriver() {
            this(null);
        }

        public FLVStreamDriver(String url) {
            this.url = url;
        }

        @Override
        protected String getUrl(IAudioSection audioSection, String recordingFilename) {
            if (this.url != null) {
                return this.url;
            }
            return audioSection.getVideoStreamingUrl();
        }
    }

    public static class FLVFileDriver
    extends FLVDriver {
        @Override
        protected String getUrl(IAudioSection audioSection, String recordingFilename) {
            System.out.println("Recording, file=" + recordingFilename);
            return recordingFilename;
        }
    }
}

