/*
 * Decompiled with CFR 0.152.
 */
package sidplay.audio;

import com.xuggle.xuggler.ICodec;
import java.util.Arrays;
import java.util.List;
import libsidplay.common.SamplingRate;
import libsidplay.config.IAudioSection;
import sidplay.audio.xuggle.XuggleVideoDriver;

public abstract class MP4Driver
extends XuggleVideoDriver {
    @Override
    protected List<SamplingRate> getSupportedSamplingRates() {
        return Arrays.asList(SamplingRate.VERY_LOW, SamplingRate.LOW, SamplingRate.MEDIUM);
    }

    @Override
    protected SamplingRate getDefaultSamplingRate() {
        return SamplingRate.LOW;
    }

    @Override
    protected ICodec.ID getVideoCodec() {
        return ICodec.ID.CODEC_ID_H264;
    }

    @Override
    protected ICodec.ID getAudioCodec() {
        return ICodec.ID.CODEC_ID_AAC;
    }

    @Override
    protected String getOutputFormatName() {
        return "mpeg4";
    }

    @Override
    public String getExtension() {
        return ".mp4";
    }

    public static class MP4FileDriver
    extends MP4Driver {
        @Override
        protected String getUrl(IAudioSection audioSection, String recordingFilename) {
            System.out.println("Recording, file=" + recordingFilename);
            return recordingFilename;
        }
    }
}

