/*
 * Decompiled with CFR 0.152.
 */
package sidplay.audio.processors.delay;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import libsidplay.config.IAudioSection;
import libsidplay.config.IConfig;
import sidplay.audio.processors.AudioProcessor;

public class DelayProcessor
implements AudioProcessor {
    private short[] delayBuffer;
    private int readIndex;
    private int writeIndex;
    private int delayBufferSize;
    private int delayOffset;
    private Integer delayInMs;
    private IAudioSection audioSection;

    public DelayProcessor(IConfig config) {
        this.audioSection = config.getAudioSection();
    }

    @Override
    public void process(ByteBuffer sampleBuffer) {
        if (!this.audioSection.getDelayBypass() && this.audioSection.getDelay() > 0) {
            if (this.delayInMs == null || this.delayInMs.intValue() != this.audioSection.getDelay()) {
                this.delayInMs = this.audioSection.getDelay();
                this.delayOffset = this.delayInMs * this.audioSection.getSamplingRate().getFrequency() * 2 / 1000;
                this.delayBufferSize = (sampleBuffer.capacity() >> 1) + this.delayOffset;
                this.delayBuffer = new short[this.delayBufferSize];
                this.writeIndex = 0;
                this.readIndex = sampleBuffer.capacity() >> 1;
            }
            int len = sampleBuffer.position();
            ((Buffer)sampleBuffer).flip();
            ByteBuffer buffer = ByteBuffer.wrap(new byte[len]).order(sampleBuffer.order());
            for (int i = 0; i < len >> 1; ++i) {
                int inputSample = sampleBuffer.getShort();
                short delaySample = this.delayBuffer[this.readIndex++];
                int outputSample = inputSample * this.audioSection.getDelayDryLevel() / 100 + delaySample * this.audioSection.getDelayWetLevel() / 100;
                outputSample = Math.max(Math.min(outputSample, Short.MAX_VALUE), Short.MIN_VALUE);
                buffer.putShort((short)outputSample);
                inputSample += delaySample * this.audioSection.getDelayFeedbackLevel() / 100;
                inputSample = Math.max(Math.min(inputSample, Short.MAX_VALUE), Short.MIN_VALUE);
                this.delayBuffer[this.writeIndex++] = (short)inputSample;
                if (this.readIndex == this.delayBufferSize) {
                    this.readIndex = 0;
                }
                if (this.writeIndex != this.delayBufferSize) continue;
                this.writeIndex = 0;
            }
            ((Buffer)sampleBuffer).flip();
            ((Buffer)buffer).flip();
            sampleBuffer.put(buffer);
        }
    }
}

