/*
 * Decompiled with CFR 0.152.
 */
package ui.audiosettings;

import java.util.ResourceBundle;
import javafx.beans.property.Property;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.Slider;
import javafx.scene.control.TextField;
import javafx.util.StringConverter;
import javafx.util.converter.IntegerStringConverter;
import javafx.util.converter.NumberStringConverter;
import libsidplay.common.VideoCoderPreset;
import sidplay.Player;
import sidplay.ini.IniDefaults;
import ui.common.C64Window;
import ui.common.converter.EnumToStringConverter;
import ui.common.converter.NumberToStringConverter;
import ui.entities.config.AudioSection;
import ui.entities.config.EmulationSection;

public class AudioSettings
extends C64Window {
    @FXML
    private CheckBox bypassDelay;
    @FXML
    private CheckBox bypassReverb;
    @FXML
    private Slider delay;
    @FXML
    private Slider delayWetLevel;
    @FXML
    private Slider delayDryLevel;
    @FXML
    private Slider delayFeedbackLevel;
    @FXML
    private Slider reverbComb1Delay;
    @FXML
    private Slider reverbComb2Delay;
    @FXML
    private Slider reverbComb3Delay;
    @FXML
    private Slider reverbComb4Delay;
    @FXML
    private Slider reverbAllPass1Delay;
    @FXML
    private Slider reverbAllPass2Delay;
    @FXML
    private Slider reverbSustainDelay;
    @FXML
    private Slider reverbDryWetMix;
    @FXML
    private Label delayValue;
    @FXML
    private Label delayWetLevelValue;
    @FXML
    private Label delayDryLevelValue;
    @FXML
    private Label delayFeedbackLevelValue;
    @FXML
    private Label reverbComb1DelayValue;
    @FXML
    private Label reverbComb2DelayValue;
    @FXML
    private Label reverbComb3DelayValue;
    @FXML
    private Label reverbComb4DelayValue;
    @FXML
    private Label reverbAllPass1DelayValue;
    @FXML
    private Label reverbAllPass2DelayValue;
    @FXML
    private Label reverbSustainDelayValue;
    @FXML
    private Label reverbDryWetMixValue;
    @FXML
    private Label cbrLabel;
    @FXML
    private Label vbrQualityLabel;
    @FXML
    private Label audioCoderBitRateLabel;
    @FXML
    private Label audioCoderBitRateToleranceLabel;
    @FXML
    private Label videoCoderGOPLabel;
    @FXML
    private Label videoCoderBitRateLabel;
    @FXML
    private Label videoCoderBitRateToleranceLabel;
    @FXML
    private Label videoCoderGlobalQualityLabel;
    @FXML
    private Label videoCoderPresetNameLabel;
    @FXML
    private TextField cbr;
    @FXML
    private TextField vbrQuality;
    @FXML
    private TextField audioCoderBitRate;
    @FXML
    private TextField audioCoderBitRateTolerance;
    @FXML
    private TextField videoCoderGOP;
    @FXML
    private TextField videoCoderBitRate;
    @FXML
    private TextField videoCoderBitRateTolerance;
    @FXML
    private TextField videoCoderGlobalQuality;
    @FXML
    private ComboBox<VideoCoderPreset> videoCoderPreset;
    @FXML
    private CheckBox vbr;
    @FXML
    private CheckBox exsidFakeStereo;
    private ObservableList<VideoCoderPreset> videoCoderPresets;

    public AudioSettings() {
    }

    public AudioSettings(Player player) {
        super(player);
    }

    @Override
    @FXML
    protected void initialize() {
        ResourceBundle bundle = this.util.getBundle();
        AudioSection audioSection = this.util.getConfig().getAudioSection();
        EmulationSection emulationSection = this.util.getConfig().getEmulationSection();
        this.bypassDelay.selectedProperty().bindBidirectional((Property)audioSection.delayBypassProperty());
        this.delay.setLabelFormatter(new NumberToStringConverter(0));
        this.delay.valueProperty().bindBidirectional((Property)audioSection.delayProperty());
        this.delayValue.textProperty().bindBidirectional((Property)audioSection.delayProperty(), new NumberToStringConverter(0));
        this.delayWetLevel.setLabelFormatter(new NumberToStringConverter(0));
        this.delayWetLevel.valueProperty().bindBidirectional((Property)audioSection.delayWetLevelProperty());
        this.delayWetLevelValue.textProperty().bindBidirectional((Property)audioSection.delayWetLevelProperty(), new NumberToStringConverter(0));
        this.delayDryLevel.setLabelFormatter(new NumberToStringConverter(0));
        this.delayDryLevel.valueProperty().bindBidirectional((Property)audioSection.delayDryLevelProperty());
        this.delayDryLevelValue.textProperty().bindBidirectional((Property)audioSection.delayDryLevelProperty(), new NumberToStringConverter(0));
        this.delayFeedbackLevel.setLabelFormatter(new NumberToStringConverter(0));
        this.delayFeedbackLevel.valueProperty().bindBidirectional((Property)audioSection.delayFeedbackLevelProperty());
        this.delayFeedbackLevelValue.textProperty().bindBidirectional((Property)audioSection.delayFeedbackLevelProperty(), new NumberToStringConverter(0));
        this.bypassReverb.selectedProperty().bindBidirectional((Property)audioSection.reverbBypassProperty());
        this.reverbComb1Delay.setLabelFormatter(new NumberToStringConverter(1));
        this.reverbComb1Delay.valueProperty().bindBidirectional((Property)audioSection.reverbComb1DelayProperty());
        this.reverbComb1DelayValue.textProperty().bindBidirectional((Property)audioSection.reverbComb1DelayProperty(), new NumberToStringConverter(1));
        this.reverbComb2Delay.setLabelFormatter(new NumberToStringConverter(1));
        this.reverbComb2Delay.valueProperty().bindBidirectional((Property)audioSection.reverbComb2DelayProperty());
        this.reverbComb2DelayValue.textProperty().bindBidirectional((Property)audioSection.reverbComb2DelayProperty(), new NumberToStringConverter(1));
        this.reverbComb3Delay.setLabelFormatter(new NumberToStringConverter(1));
        this.reverbComb3Delay.valueProperty().bindBidirectional((Property)audioSection.reverbComb3DelayProperty());
        this.reverbComb3DelayValue.textProperty().bindBidirectional((Property)audioSection.reverbComb3DelayProperty(), new NumberToStringConverter(1));
        this.reverbComb4Delay.setLabelFormatter(new NumberToStringConverter(1));
        this.reverbComb4Delay.valueProperty().bindBidirectional((Property)audioSection.reverbComb4DelayProperty());
        this.reverbComb4DelayValue.textProperty().bindBidirectional((Property)audioSection.reverbComb4DelayProperty(), new NumberToStringConverter(1));
        this.reverbAllPass1Delay.setLabelFormatter(new NumberToStringConverter(1));
        this.reverbAllPass1Delay.valueProperty().bindBidirectional((Property)audioSection.reverbAllPass1DelayProperty());
        this.reverbAllPass1DelayValue.textProperty().bindBidirectional((Property)audioSection.reverbAllPass1DelayProperty(), new NumberToStringConverter(1));
        this.reverbAllPass2Delay.setLabelFormatter(new NumberToStringConverter(1));
        this.reverbAllPass2Delay.valueProperty().bindBidirectional((Property)audioSection.reverbAllPass2DelayProperty());
        this.reverbAllPass2DelayValue.textProperty().bindBidirectional((Property)audioSection.reverbAllPass2DelayProperty(), new NumberToStringConverter(1));
        this.reverbSustainDelay.setLabelFormatter(new NumberToStringConverter(0));
        this.reverbSustainDelay.valueProperty().bindBidirectional((Property)audioSection.reverbSustainDelayProperty());
        this.reverbSustainDelayValue.textProperty().bindBidirectional((Property)audioSection.reverbSustainDelayProperty(), new NumberToStringConverter(0));
        this.reverbDryWetMix.setLabelFormatter(new NumberToStringConverter(2));
        this.reverbDryWetMix.valueProperty().bindBidirectional((Property)audioSection.reverbDryWetMixProperty());
        this.reverbDryWetMixValue.textProperty().bindBidirectional((Property)audioSection.reverbDryWetMixProperty(), new NumberToStringConverter(2));
        this.cbr.textProperty().bindBidirectional(audioSection.cbrProperty(), (StringConverter)new IntegerStringConverter());
        this.vbr.selectedProperty().bindBidirectional((Property)audioSection.vbrProperty());
        this.vbrQuality.textProperty().bindBidirectional(audioSection.vbrQualityProperty(), (StringConverter)new IntegerStringConverter());
        this.audioCoderBitRate.textProperty().bindBidirectional((Property)audioSection.audioCoderBitRateProperty(), (StringConverter)new NumberStringConverter());
        this.audioCoderBitRateTolerance.textProperty().bindBidirectional((Property)audioSection.audioCoderBitRateToleranceProperty(), (StringConverter)new NumberStringConverter());
        this.videoCoderGOP.textProperty().bindBidirectional((Property)audioSection.videoCoderNumPicturesInGroupOfPicturesProperty(), (StringConverter)new NumberStringConverter());
        this.videoCoderBitRate.textProperty().bindBidirectional((Property)audioSection.videoCoderBitRateProperty(), (StringConverter)new NumberStringConverter());
        this.videoCoderBitRateTolerance.textProperty().bindBidirectional((Property)audioSection.videoCoderBitRateToleranceProperty(), (StringConverter)new NumberStringConverter());
        this.videoCoderGlobalQuality.textProperty().bindBidirectional((Property)audioSection.videoCoderGlobalQualityProperty(), (StringConverter)new NumberStringConverter());
        this.videoCoderPresets = FXCollections.observableArrayList((Object[])VideoCoderPreset.values());
        this.videoCoderPreset.setConverter(new EnumToStringConverter(bundle));
        this.videoCoderPreset.valueProperty().bindBidirectional(audioSection.sidVideoEncoderPresetProperty());
        this.videoCoderPreset.setItems(this.videoCoderPresets);
        this.exsidFakeStereo.selectedProperty().bindBidirectional((Property)emulationSection.exsidFakeStereoProperty());
    }

    @FXML
    private void restoreDefaults() {
        AudioSection audioSection = this.util.getConfig().getAudioSection();
        EmulationSection emulationSection = this.util.getConfig().getEmulationSection();
        audioSection.setDelayBypass(IniDefaults.DEFAULT_DELAY_BYPASS);
        audioSection.setDelay(IniDefaults.DEFAULT_DELAY);
        audioSection.setDelayWetLevel(IniDefaults.DEFAULT_DELAY_WET_LEVEL);
        audioSection.setDelayDryLevel(IniDefaults.DEFAULT_DELAY_DRY_LEVEL);
        audioSection.setDelayFeedbackLevel(IniDefaults.DEFAULT_DELAY_FEEDBACK_LEVEL);
        audioSection.setReverbBypass(IniDefaults.DEFAULT_REVERB_BYPASS);
        audioSection.setReverbComb1Delay(IniDefaults.DEFAULT_REVERB_COMB1_DELAY);
        audioSection.setReverbComb2Delay(IniDefaults.DEFAULT_REVERB_COMB2_DELAY);
        audioSection.setReverbComb3Delay(IniDefaults.DEFAULT_REVERB_COMB3_DELAY);
        audioSection.setReverbComb4Delay(IniDefaults.DEFAULT_REVERB_COMB4_DELAY);
        audioSection.setReverbAllPass1Delay(IniDefaults.DEFAULT_REVERB_ALL_PASS1_DELAY);
        audioSection.setReverbAllPass2Delay(IniDefaults.DEFAULT_REVERB_ALL_PASS2_DELAY);
        audioSection.setReverbSustainDelay(IniDefaults.DEFAULT_REVERB_SUSTAIN_DELAY);
        audioSection.setReverbDryWetMix(IniDefaults.DEFAULT_REVERB_DRY_WET_MIX);
        audioSection.setCbr(IniDefaults.DEFAULT_CBR);
        audioSection.setVbr(IniDefaults.DEFAULT_VBR);
        audioSection.setVbrQuality(IniDefaults.DEFAULT_VBR_QUALITY);
        audioSection.setAudioCoderBitRate(IniDefaults.DEFAULT_AUDIO_CODER_BIT_RATE);
        audioSection.setAudioCoderBitRateTolerance(IniDefaults.DEFAULT_AUDIO_CODER_BIT_RATE_TOLERANCE);
        audioSection.setVideoCoderNumPicturesInGroupOfPictures(IniDefaults.DEFAULT_VIDEO_CODER_GOP);
        audioSection.setVideoCoderBitRate(IniDefaults.DEFAULT_VIDEO_CODER_BIT_RATE);
        audioSection.setVideoCoderBitRateTolerance(IniDefaults.DEFAULT_VIDEO_CODER_BIT_RATE_TOLERANCE);
        audioSection.setVideoCoderGlobalQuality(IniDefaults.DEFAULT_VIDEO_CODER_GLOBAL_QUALITY);
        audioSection.setVideoCoderPreset(IniDefaults.DEFAULT_VIDEO_CODER_PRESET);
        emulationSection.setExsidFakeStereo(IniDefaults.DEFAULT_EXSID_FAKE_STEREO);
    }
}

