/*
 * Decompiled with CFR 0.152.
 */
package ui.common;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Arrays;
import java.util.ResourceBundle;
import java.util.function.BooleanSupplier;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.fxml.FXMLLoader;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.control.ProgressBar;
import javafx.scene.control.TabPane;
import javafx.scene.control.TextField;
import javafx.scene.control.Tooltip;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.util.BuilderFactory;
import sidplay.Player;
import ui.JSidPlay2Main;
import ui.common.C64Window;
import ui.common.UIBuilder;
import ui.common.UIPart;
import ui.entities.config.Configuration;

public class UIUtil {
    private static final String CELL_VALUE_OK = "cellValueOk";
    private static final String CELL_VALUE_ERROR = "cellValueError";
    private static final Image PLAYED_ICON = new Image(JSidPlay2Main.class.getResource("icons/play.png").toString());
    private final C64Window window;
    private final Player player;
    private ResourceBundle bundle;
    private final UIPart controller;
    private DoubleProperty progressProperty;
    private static ObjectProperty<?>[] currentlyPlayedObjectProperty;

    public UIUtil(C64Window window, Player player, UIPart controller) {
        this.window = window;
        this.player = player;
        this.controller = controller;
        this.bundle = ResourceBundle.getBundle(controller.getBundleName());
    }

    public Object parse() {
        return this.parse(null);
    }

    public Object parse(Object root) {
        Object object;
        block8: {
            URL fxml = this.controller.getFxml();
            FXMLLoader fxmlLoader = new FXMLLoader();
            fxmlLoader.setRoot(root);
            fxmlLoader.setLocation(fxml);
            fxmlLoader.setBuilderFactory((BuilderFactory)new UIBuilder(this.window, this.player));
            fxmlLoader.setResources(this.bundle);
            fxmlLoader.setController((Object)this.controller);
            InputStream is = fxml.openStream();
            try {
                object = fxmlLoader.load(is);
                if (is == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException("Unparsable View: " + fxml, e);
                }
            }
            is.close();
        }
        return object;
    }

    public final void setPlayingTab(Node node, ObjectProperty<?> ... newCurrentlyPlayedObjectProperty) {
        this.resetPlayingTab((Node)node.getScene().getRoot(), currentlyPlayedObjectProperty, newCurrentlyPlayedObjectProperty);
        currentlyPlayedObjectProperty = newCurrentlyPlayedObjectProperty;
        do {
            if (!(node instanceof UIPart) || !(node.getParent().getParent() instanceof TabPane)) continue;
            TabPane tabPane = (TabPane)node.getParent().getParent();
            Node theNode = node;
            tabPane.getTabs().stream().filter(tab -> tab.getContent().equals(theNode)).findFirst().ifPresent(tab -> tab.setGraphic((Node)new ImageView(PLAYED_ICON)));
        } while ((node = node.getParent()) != null);
    }

    private void resetPlayingTab(Node root, ObjectProperty<?>[] oldCurrentlyPlayedObjectProperty, ObjectProperty<?>[] newCurrentlyPlayedObjectProperty) {
        if (oldCurrentlyPlayedObjectProperty != null) {
            for (ObjectProperty<?> currently : oldCurrentlyPlayedObjectProperty) {
                if (Arrays.asList(newCurrentlyPlayedObjectProperty).contains(currently)) continue;
                currently.set(null);
            }
        }
        root.lookupAll(".tab-pane").forEach(tabPaneNode -> ((TabPane)tabPaneNode).getTabs().stream().forEach(tab -> tab.setGraphic(null)));
    }

    public void checkTextField(TextField textField, BooleanSupplier valueCheck, Runnable applyCorrectValue, String tipKey, String formatKey) {
        Tooltip tooltip = new Tooltip();
        try {
            textField.getStyleClass().removeAll((Object[])new String[]{CELL_VALUE_OK, CELL_VALUE_ERROR});
            if (!valueCheck.getAsBoolean()) {
                throw new NumberFormatException();
            }
            applyCorrectValue.run();
            tooltip.setText(this.bundle.getString(tipKey));
            textField.setTooltip(tooltip);
            textField.getStyleClass().add((Object)CELL_VALUE_OK);
        }
        catch (NumberFormatException e) {
            tooltip.setText(this.bundle.getString(formatKey));
            textField.setTooltip(tooltip);
            textField.getStyleClass().add((Object)CELL_VALUE_ERROR);
        }
    }

    public final DoubleProperty progressProperty(Scene scene) {
        ProgressBar progressBar;
        if (this.progressProperty == null && scene != null && (progressBar = (ProgressBar)scene.lookup("#progress")) != null) {
            this.progressProperty = progressBar.progressProperty();
        }
        return this.progressProperty;
    }

    public C64Window getWindow() {
        return this.window;
    }

    public final Player getPlayer() {
        return this.player;
    }

    public final Configuration getConfig() {
        return (Configuration)this.player.getConfig();
    }

    public final ResourceBundle getBundle() {
        return this.bundle;
    }

    void setBundle(ResourceBundle bundle) {
        this.bundle = bundle;
    }
}

