/*
 * Decompiled with CFR 0.152.
 */
package ui.common.download;

import java.io.File;
import javafx.application.Platform;
import javafx.scene.Scene;
import ui.common.UIUtil;
import ui.common.download.IDownloadListener;

public abstract class ProgressListener
implements IDownloadListener {
    protected UIUtil util;
    private Scene scene;

    public ProgressListener(UIUtil util, Scene scene) {
        this.util = util;
        this.scene = scene;
    }

    @Override
    public void downloadStep(int pct) {
        Platform.runLater(() -> this.util.progressProperty(this.scene).set((double)pct / 100.0));
    }

    @Override
    public void downloadStop(File downloadedFile) {
        if (downloadedFile == null) {
            Platform.runLater(() -> this.util.progressProperty(this.scene).set(0.0));
        }
        this.downloaded(downloadedFile);
    }

    public abstract void downloaded(File var1);
}

