/*
 * Decompiled with CFR 0.152.
 */
package ui.common.util;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URLConnection;
import java.util.Properties;
import ui.common.util.InternetUtil;
import ui.entities.config.SidPlay2Section;

public class VersionUtil {
    private static final String LOCAL_VERSION_RESOURCE = "/META-INF/maven/jsidplay2/jsidplay2/pom.properties";
    private static final String ONLINE_VERSION_RESOURCE = "http://sourceforge.net/p/jsidplay2/code/HEAD/tree/trunk/jsidplay2/latest.properties?format=raw";
    public static final String VERSION;

    public static String fetchRemoteVersion(SidPlay2Section sidplay2Section) {
        try {
            URLConnection connection = InternetUtil.openConnection(new URI(ONLINE_VERSION_RESOURCE).toURL(), sidplay2Section);
            return VersionUtil.getVersion(connection);
        }
        catch (Exception e) {
            return null;
        }
    }

    private static String getVersion(URLConnection connection) throws IOException {
        try (InputStream inputStream = connection.getInputStream();){
            Properties latestProperties = new Properties();
            latestProperties.load(inputStream);
            String string = latestProperties.getProperty("version");
            return string;
        }
    }

    static {
        String version;
        try {
            URLConnection connection = VersionUtil.class.getResource(LOCAL_VERSION_RESOURCE).openConnection();
            version = VersionUtil.getVersion(connection);
        }
        catch (Exception e) {
            version = "(beta)";
        }
        VERSION = version;
    }
}

