/*
 * Decompiled with CFR 0.152.
 */
package ui.directory;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Locale;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.input.KeyCode;
import javafx.scene.layout.Priority;
import libsidplay.sidtune.SidTuneError;
import libsidutils.C64FontUtils;
import libsidutils.directory.CartridgeDirectory;
import libsidutils.directory.DirEntry;
import libsidutils.directory.DiskDirectory;
import libsidutils.directory.T64Directory;
import libsidutils.directory.TuneDirectory;
import sidplay.Player;
import ui.common.C64VBox;
import ui.common.C64Window;
import ui.common.UIPart;
import ui.common.filefilter.DiskFileFilter;
import ui.common.filefilter.TuneFileFilter;
import ui.directory.DirectoryItem;
import ui.entities.config.SidPlay2Section;

public class Directory
extends C64VBox
implements UIPart {
    private static TuneFileFilter tuneFilter = new TuneFileFilter();
    private static DiskFileFilter diskFilter = new DiskFileFilter();
    @FXML
    protected TableView<DirectoryItem> directory;
    @FXML
    private TableColumn<DirectoryItem, String> dirColumn;
    @FXML
    private ContextMenu contentEntryContextMenu;
    @FXML
    private MenuItem startMenu;
    private ObservableList<DirectoryItem> directoryEntries;
    private ObjectProperty<String> autoStartFileProperty = new SimpleObjectProperty();
    private int fontSet = 57344;
    private int fontSetHeader = 57856;
    private File previewFile;

    public Directory() {
    }

    public Directory(C64Window window, Player player) {
        super(window, player);
    }

    @Override
    @FXML
    protected void initialize() {
        this.dirColumn.prefWidthProperty().bind((ObservableValue)this.directory.widthProperty());
        this.directoryEntries = FXCollections.observableArrayList();
        this.directory.setItems(this.directoryEntries);
        this.directory.setOnKeyPressed(event -> {
            DirectoryItem selectedItem = (DirectoryItem)this.directory.getSelectionModel().getSelectedItem();
            if (event.getCode() == KeyCode.ENTER && selectedItem != null) {
                this.autoStartProgram();
            }
        });
        this.directory.setOnMousePressed(event -> {
            if (event.isPrimaryButtonDown() && event.getClickCount() > 1) {
                this.autoStartProgram();
            }
        });
        this.contentEntryContextMenu.setOnShown(event -> {
            DirectoryItem directoryItem = (DirectoryItem)this.directory.getSelectionModel().getSelectedItem();
            this.startMenu.setDisable(directoryItem == null || directoryItem.getDirEntry() == null);
        });
        if (this.directory.getUserData() != null) {
            this.loadPreview(new File(this.directory.getUserData().toString()));
            this.doSwitchFont();
        }
        Directory.setVgrow(this.directory, (Priority)Priority.ALWAYS);
    }

    @FXML
    private void doSwitchFont() {
        this.fontSet = this.fontSet == 57344 ? 57600 : 57344;
        this.fontSetHeader = this.fontSetHeader == 57856 ? 58112 : 57856;
        this.loadPreview(this.previewFile);
    }

    @FXML
    private void autoStartProgram() {
        DirectoryItem dirItem = (DirectoryItem)this.directory.getSelectionModel().getSelectedItem();
        if (dirItem == null) {
            return;
        }
        DirEntry dirEntry = dirItem.getDirEntry();
        if (dirEntry != null) {
            this.autoStartFileProperty.set((Object)dirEntry.getDirectoryLine());
        }
    }

    public ObjectProperty<String> getAutoStartFileProperty() {
        return this.autoStartFileProperty;
    }

    public void loadPreview(File previewFile) {
        block6: {
            SidPlay2Section sidplay2Section = this.util.getConfig().getSidplay2Section();
            if (previewFile == null) {
                return;
            }
            this.previewFile = previewFile;
            this.directoryEntries.clear();
            try {
                libsidutils.directory.Directory dir = this.createDirectory(sidplay2Section.getHvsc(), previewFile);
                if (dir != null) {
                    DirectoryItem headerItem = new DirectoryItem();
                    headerItem.setText(C64FontUtils.petsciiToFont(dir.getTitle(), this.fontSetHeader));
                    this.directoryEntries.add((Object)headerItem);
                    Collection<DirEntry> dirEntries = dir.getDirEntries();
                    for (DirEntry dirEntry : dirEntries) {
                        DirectoryItem dirItem = new DirectoryItem();
                        dirItem.setText(C64FontUtils.petsciiToFont(dirEntry.getDirectoryLine(), this.fontSet));
                        dirItem.setDirEntry(dirEntry);
                        this.directoryEntries.add((Object)dirItem);
                    }
                    if (dir.getStatusLine() != null) {
                        DirectoryItem dirItem = new DirectoryItem();
                        dirItem.setText(C64FontUtils.petsciiToFont(dir.getStatusLine(), this.fontSet));
                        this.directoryEntries.add((Object)dirItem);
                    }
                    break block6;
                }
                throw new IOException();
            }
            catch (IOException | SidTuneError ioE) {
                DirectoryItem dirItem = new DirectoryItem();
                dirItem.setText(C64FontUtils.petsciiToFont("SORRY, NO PREVIEW AVAILABLE!", 57344));
                this.directoryEntries.add((Object)dirItem);
            }
        }
        DirectoryItem dirItem = new DirectoryItem();
        dirItem.setText(C64FontUtils.petsciiToFont("READY.", 57344));
        this.directoryEntries.add((Object)dirItem);
    }

    public void clear() {
        this.directoryEntries.clear();
    }

    private libsidutils.directory.Directory createDirectory(File hvscRoot, File file) throws IOException, SidTuneError {
        if (diskFilter.accept(file)) {
            return new DiskDirectory(file);
        }
        if (file.getName().toLowerCase(Locale.ENGLISH).endsWith(".t64")) {
            return new T64Directory(file);
        }
        if (file.getName().toLowerCase(Locale.ENGLISH).endsWith(".crt")) {
            return new CartridgeDirectory(file);
        }
        if (tuneFilter.accept(file)) {
            return new TuneDirectory(hvscRoot, file);
        }
        return null;
    }
}

