/*
 * Decompiled with CFR 0.152.
 */
package ui.emulationsettings;

import builder.netsiddev.commands.TrySetSidModel;
import builder.resid.residfp.FilterModelConfig;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.ResourceBundle;
import javafx.application.Platform;
import javafx.beans.property.Property;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.chart.LineChart;
import javafx.scene.chart.XYChart;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.Slider;
import javafx.scene.control.TextField;
import javafx.util.StringConverter;
import libsidplay.common.CPUClock;
import libsidplay.common.ChipModel;
import libsidplay.common.Emulation;
import libsidplay.common.Engine;
import libsidplay.common.SidReads;
import libsidplay.common.StereoMode;
import libsidplay.config.IFilterSection;
import libsidplay.sidtune.SidTune;
import sidplay.Player;
import sidplay.ini.IniDefaults;
import sidplay.player.State;
import ui.common.C64Window;
import ui.common.converter.EnumToStringConverter;
import ui.common.converter.HexNumberToStringConverter;
import ui.common.converter.NumberToStringConverter;
import ui.entities.config.AudioSection;
import ui.entities.config.EmulationSection;
import ui.entities.config.FilterSection;

public class EmulationSettings
extends C64Window {
    @FXML
    private CheckBox muteVoice1;
    @FXML
    private CheckBox muteVoice2;
    @FXML
    private CheckBox muteVoice3;
    @FXML
    private CheckBox muteVoice4;
    @FXML
    private CheckBox muteVoice5;
    @FXML
    private CheckBox muteVoice6;
    @FXML
    private CheckBox muteVoice7;
    @FXML
    private CheckBox muteVoice8;
    @FXML
    private CheckBox muteVoice9;
    @FXML
    private CheckBox muteVoice10;
    @FXML
    private CheckBox muteVoice11;
    @FXML
    private CheckBox muteVoice12;
    @FXML
    private ComboBox<CPUClock> defaultVideoStandard;
    @FXML
    private ComboBox<Emulation> sid1Emulation;
    @FXML
    private ComboBox<Emulation> sid2Emulation;
    @FXML
    private ComboBox<Emulation> sid3Emulation;
    @FXML
    private ComboBox<Emulation> defaultEmulation;
    @FXML
    private ComboBox<ChipModel> sid1Model;
    @FXML
    private ComboBox<ChipModel> sid2Model;
    @FXML
    private ComboBox<ChipModel> sid3Model;
    @FXML
    private ComboBox<ChipModel> defaultModel;
    @FXML
    private ComboBox<String> mainFilter;
    @FXML
    private ComboBox<String> secondFilter;
    @FXML
    private ComboBox<String> thirdFilter;
    @FXML
    private ComboBox<SidReads> sidToRead;
    @FXML
    private ComboBox<StereoMode> stereoMode;
    @FXML
    private TextField baseAddress;
    @FXML
    private TextField thirdAddress;
    @FXML
    private CheckBox boosted8580;
    @FXML
    private CheckBox fakeStereo;
    @FXML
    private CheckBox detectPSID64ChipModel;
    @FXML
    private CheckBox filter;
    @FXML
    private CheckBox stereoFilter;
    @FXML
    private CheckBox thirdSidFilter;
    @FXML
    private Slider mainVolume;
    @FXML
    private Slider secondVolume;
    @FXML
    private Slider thirdVolume;
    @FXML
    private Slider mainBalance;
    @FXML
    private Slider secondBalance;
    @FXML
    private Slider thirdBalance;
    @FXML
    private Slider mainDelay;
    @FXML
    private Slider secondDelay;
    @FXML
    private Slider thirdDelay;
    @FXML
    private Label mainVolumeValue;
    @FXML
    private Label secondVolumeValue;
    @FXML
    private Label thirdVolumeValue;
    @FXML
    private LineChart<Number, Number> mainFilterCurve;
    @FXML
    private LineChart<Number, Number> secondFilterCurve;
    @FXML
    private LineChart<Number, Number> thirdFilterCurve;
    @FXML
    private Button copy;
    private ObservableList<CPUClock> defaultVideoStandards;
    private ObservableList<Emulation> sid1Emulations;
    private ObservableList<Emulation> sid2Emulations;
    private ObservableList<Emulation> sid3Emulations;
    private ObservableList<Emulation> defaultEmulations;
    private ObservableList<ChipModel> sid1Models;
    private ObservableList<ChipModel> sid2Models;
    private ObservableList<ChipModel> sid3Models;
    private ObservableList<ChipModel> defaultModels;
    private ObservableList<String> mainFilters;
    private ObservableList<String> secondFilters;
    private ObservableList<String> thirdFilters;
    private ObservableList<SidReads> sidReads;
    private ObservableList<StereoMode> stereoModes;
    private PropertyChangeListener emulationChange;
    private boolean duringInitialization;

    public EmulationSettings() {
    }

    public EmulationSettings(Player player) {
        super(player);
    }

    @Override
    @FXML
    protected void initialize() {
        this.duringInitialization = true;
        ResourceBundle bundle = this.util.getBundle();
        AudioSection audioSection = this.util.getConfig().getAudioSection();
        EmulationSection emulationSection = this.util.getConfig().getEmulationSection();
        this.muteVoice1.selectedProperty().bindBidirectional((Property)emulationSection.muteVoice1Property());
        this.muteVoice1.selectedProperty().addListener((obj, o, n) -> this.util.getPlayer().configureSID(0, sid -> sid.setVoiceMute(0, (boolean)n)));
        this.muteVoice2.selectedProperty().bindBidirectional((Property)emulationSection.muteVoice2Property());
        this.muteVoice2.selectedProperty().addListener((obj, o, n) -> this.util.getPlayer().configureSID(0, sid -> sid.setVoiceMute(1, (boolean)n)));
        this.muteVoice3.selectedProperty().bindBidirectional((Property)emulationSection.muteVoice3Property());
        this.muteVoice3.selectedProperty().addListener((obj, o, n) -> this.util.getPlayer().configureSID(0, sid -> sid.setVoiceMute(2, (boolean)n)));
        this.muteVoice4.selectedProperty().bindBidirectional((Property)emulationSection.muteVoice4Property());
        this.muteVoice4.selectedProperty().addListener((obj, o, n) -> this.util.getPlayer().configureSID(0, sid -> sid.setVoiceMute(3, (boolean)n)));
        this.muteVoice5.selectedProperty().bindBidirectional((Property)emulationSection.muteStereoVoice1Property());
        this.muteVoice5.selectedProperty().addListener((obj, o, n) -> this.util.getPlayer().configureSID(1, sid -> sid.setVoiceMute(0, (boolean)n)));
        this.muteVoice6.selectedProperty().bindBidirectional((Property)emulationSection.muteStereoVoice2Property());
        this.muteVoice6.selectedProperty().addListener((obj, o, n) -> this.util.getPlayer().configureSID(1, sid -> sid.setVoiceMute(1, (boolean)n)));
        this.muteVoice7.selectedProperty().bindBidirectional((Property)emulationSection.muteStereoVoice3Property());
        this.muteVoice7.selectedProperty().addListener((obj, o, n) -> this.util.getPlayer().configureSID(1, sid -> sid.setVoiceMute(2, (boolean)n)));
        this.muteVoice8.selectedProperty().bindBidirectional((Property)emulationSection.muteStereoVoice4Property());
        this.muteVoice8.selectedProperty().addListener((obj, o, n) -> this.util.getPlayer().configureSID(1, sid -> sid.setVoiceMute(3, (boolean)n)));
        this.muteVoice9.selectedProperty().bindBidirectional((Property)emulationSection.muteThirdSIDVoice1Property());
        this.muteVoice9.selectedProperty().addListener((obj, o, n) -> this.util.getPlayer().configureSID(2, sid -> sid.setVoiceMute(0, (boolean)n)));
        this.muteVoice10.selectedProperty().bindBidirectional((Property)emulationSection.muteThirdSIDVoice2Property());
        this.muteVoice10.selectedProperty().addListener((obj, o, n) -> this.util.getPlayer().configureSID(2, sid -> sid.setVoiceMute(1, (boolean)n)));
        this.muteVoice11.selectedProperty().bindBidirectional((Property)emulationSection.muteThirdSIDVoice3Property());
        this.muteVoice11.selectedProperty().addListener((obj, o, n) -> this.util.getPlayer().configureSID(2, sid -> sid.setVoiceMute(2, (boolean)n)));
        this.muteVoice12.selectedProperty().bindBidirectional((Property)emulationSection.muteThirdSIDVoice4Property());
        this.muteVoice12.selectedProperty().addListener((obj, o, n) -> this.util.getPlayer().configureSID(2, sid -> sid.setVoiceMute(3, (boolean)n)));
        this.mainFilters = FXCollections.observableArrayList();
        this.mainFilter.valueProperty().addListener((obj, o, n) -> this.updateSIDChipConfiguration());
        this.mainFilter.setItems(this.mainFilters);
        this.secondFilters = FXCollections.observableArrayList();
        this.secondFilter.valueProperty().addListener((obj, o, n) -> this.updateSIDChipConfiguration());
        this.secondFilter.setItems(this.secondFilters);
        this.thirdFilters = FXCollections.observableArrayList();
        this.thirdFilter.valueProperty().addListener((obj, o, n) -> this.updateSIDChipConfiguration());
        this.thirdFilter.setItems(this.thirdFilters);
        this.mainBalance.setLabelFormatter(new NumberToStringConverter(1));
        this.mainBalance.valueProperty().bindBidirectional((Property)audioSection.mainBalanceProperty());
        this.mainBalance.valueProperty().addListener((obj, o, n) -> this.util.getPlayer().configureMixer(m -> m.setBalance(0, n.floatValue())));
        this.secondBalance.setLabelFormatter(new NumberToStringConverter(1));
        this.secondBalance.valueProperty().bindBidirectional((Property)audioSection.secondBalanceProperty());
        this.secondBalance.valueProperty().addListener((obj, o, n) -> this.util.getPlayer().configureMixer(m -> m.setBalance(1, n.floatValue())));
        this.thirdBalance.setLabelFormatter(new NumberToStringConverter(1));
        this.thirdBalance.valueProperty().bindBidirectional((Property)audioSection.thirdBalanceProperty());
        this.thirdBalance.valueProperty().addListener((obj, o, n) -> this.util.getPlayer().configureMixer(m -> m.setBalance(2, n.floatValue())));
        this.mainDelay.valueProperty().bindBidirectional((Property)audioSection.mainDelayProperty());
        this.mainDelay.valueProperty().addListener((obj, o, n) -> this.util.getPlayer().configureMixer(m -> m.setDelay(0, n.intValue())));
        this.secondDelay.valueProperty().bindBidirectional((Property)audioSection.secondDelayProperty());
        this.secondDelay.valueProperty().addListener((obj, o, n) -> this.util.getPlayer().configureMixer(m -> m.setDelay(1, n.intValue())));
        this.thirdDelay.valueProperty().bindBidirectional((Property)audioSection.thirdDelayProperty());
        this.thirdDelay.valueProperty().addListener((obj, o, n) -> this.util.getPlayer().configureMixer(m -> m.setDelay(2, n.intValue())));
        this.mainVolume.valueProperty().bindBidirectional((Property)audioSection.mainVolumeProperty());
        this.mainVolumeValue.textProperty().bindBidirectional((Property)audioSection.mainVolumeProperty(), new NumberToStringConverter(2));
        this.mainVolume.valueProperty().addListener((obj, o, n) -> this.util.getPlayer().configureMixer(m -> m.setVolume(0, n.floatValue())));
        this.secondVolume.valueProperty().bindBidirectional((Property)audioSection.secondVolumeProperty());
        this.secondVolumeValue.textProperty().bindBidirectional((Property)audioSection.secondVolumeProperty(), new NumberToStringConverter(2));
        this.secondVolume.valueProperty().addListener((obj, o, n) -> this.util.getPlayer().configureMixer(b -> b.setVolume(1, n.floatValue())));
        this.thirdVolume.valueProperty().bindBidirectional((Property)audioSection.thirdVolumeProperty());
        this.thirdVolumeValue.textProperty().bindBidirectional((Property)audioSection.thirdVolumeProperty(), new NumberToStringConverter(2));
        this.thirdVolume.valueProperty().addListener((obj, o, n) -> this.util.getPlayer().configureMixer(b -> b.setVolume(2, n.floatValue())));
        this.stereoModes = FXCollections.observableArrayList((Object[])StereoMode.values());
        this.stereoMode.setConverter(new EnumToStringConverter(bundle));
        this.stereoMode.valueProperty().addListener((obj, o, n) -> this.updateSIDChipConfiguration());
        this.stereoMode.setItems(this.stereoModes);
        this.baseAddress.textProperty().bindBidirectional((Property)emulationSection.dualSidBaseProperty(), (StringConverter)new HexNumberToStringConverter());
        this.baseAddress.textProperty().addListener((obj, o, n) -> this.updateSIDChipConfiguration());
        this.thirdAddress.textProperty().bindBidirectional((Property)emulationSection.thirdSIDBaseProperty(), (StringConverter)new HexNumberToStringConverter());
        this.thirdAddress.textProperty().addListener((obj, o, n) -> this.updateSIDChipConfiguration());
        this.sidReads = FXCollections.observableArrayList((Object[])SidReads.values());
        this.sidToRead.setConverter(new EnumToStringConverter(bundle));
        this.sidToRead.setItems(this.sidReads);
        this.sidToRead.valueProperty().bindBidirectional(emulationSection.sidToReadProperty());
        this.sid1Emulations = FXCollections.observableArrayList((Object[])Emulation.values());
        this.sid1Emulation.setConverter(new EnumToStringConverter(bundle));
        this.sid1Emulation.valueProperty().bindBidirectional(emulationSection.userEmulationProperty());
        this.sid1Emulation.valueProperty().addListener((obj, o, n) -> this.updateSIDChipConfiguration());
        this.sid1Emulation.setItems(this.sid1Emulations);
        this.sid2Emulations = FXCollections.observableArrayList((Object[])Emulation.values());
        this.sid2Emulation.setConverter(new EnumToStringConverter(bundle));
        this.sid2Emulation.valueProperty().bindBidirectional(emulationSection.stereoEmulationProperty());
        this.sid2Emulation.valueProperty().addListener((obj, o, n) -> this.updateSIDChipConfiguration());
        this.sid2Emulation.setItems(this.sid2Emulations);
        this.sid3Emulations = FXCollections.observableArrayList((Object[])Emulation.values());
        this.sid3Emulation.setConverter(new EnumToStringConverter(bundle));
        this.sid3Emulation.valueProperty().bindBidirectional(emulationSection.thirdEmulationProperty());
        this.sid3Emulation.valueProperty().addListener((obj, o, n) -> this.updateSIDChipConfiguration());
        this.sid3Emulation.setItems(this.sid3Emulations);
        this.sid1Models = FXCollections.observableArrayList((Object[])ChipModel.values());
        this.sid1Model.setConverter(new EnumToStringConverter(bundle));
        this.sid1Model.valueProperty().bindBidirectional(emulationSection.userSidModelProperty());
        this.sid1Model.valueProperty().addListener((obj, o, n) -> this.updateSIDChipConfiguration());
        this.sid1Model.setItems(this.sid1Models);
        this.sid2Models = FXCollections.observableArrayList((Object[])ChipModel.values());
        this.sid2Model.setConverter(new EnumToStringConverter(bundle));
        this.sid2Model.valueProperty().bindBidirectional(emulationSection.stereoSidModelProperty());
        this.sid2Model.valueProperty().addListener((obj, o, n) -> this.updateSIDChipConfiguration());
        this.sid2Model.setItems(this.sid2Models);
        this.sid3Models = FXCollections.observableArrayList((Object[])ChipModel.values());
        this.sid3Model.setConverter(new EnumToStringConverter(bundle));
        this.sid3Model.valueProperty().bindBidirectional(emulationSection.thirdSIDModelProperty());
        this.sid3Model.valueProperty().addListener((obj, o, n) -> this.updateSIDChipConfiguration());
        this.sid3Model.setItems(this.sid3Models);
        this.defaultModels = FXCollections.observableArrayList((Object[])new ChipModel[]{ChipModel.MOS6581, ChipModel.MOS8580});
        this.defaultModel.setConverter(new EnumToStringConverter(bundle));
        this.defaultModel.valueProperty().bindBidirectional(emulationSection.defaultSidModelProperty());
        this.defaultModel.valueProperty().addListener((obj, o, n) -> this.updateSIDChipConfiguration());
        this.defaultModel.setItems(this.defaultModels);
        this.defaultVideoStandards = FXCollections.observableArrayList((Object[])new CPUClock[]{CPUClock.PAL, CPUClock.NTSC});
        this.defaultVideoStandard.setConverter(new EnumToStringConverter(bundle));
        this.defaultVideoStandard.valueProperty().bindBidirectional(emulationSection.defaultClockSpeedProperty());
        this.defaultVideoStandard.valueProperty().addListener((obj, o, n) -> this.restart());
        this.defaultVideoStandard.setItems(this.defaultVideoStandards);
        this.defaultEmulations = FXCollections.observableArrayList((Object[])new Emulation[]{Emulation.RESID, Emulation.RESIDFP});
        this.defaultEmulation.setConverter(new EnumToStringConverter(bundle));
        this.defaultEmulation.valueProperty().bindBidirectional(emulationSection.defaultEmulationProperty());
        this.defaultEmulation.valueProperty().addListener((obj, o, n) -> this.updateSIDChipConfiguration());
        this.defaultEmulation.setItems(this.defaultEmulations);
        this.boosted8580.selectedProperty().bindBidirectional((Property)emulationSection.digiBoosted8580Property());
        this.boosted8580.selectedProperty().addListener((obj, o, n) -> this.util.getPlayer().configureSIDs((num, sid) -> sid.setDigiBoost(emulationSection.isDigiBoosted8580())));
        this.fakeStereo.selectedProperty().bindBidirectional((Property)emulationSection.fakeStereoProperty());
        this.fakeStereo.selectedProperty().addListener((obj, o, n) -> this.updateSIDChipConfiguration());
        this.filter.selectedProperty().bindBidirectional((Property)emulationSection.filterProperty());
        this.filter.selectedProperty().addListener((obj, o, n) -> this.util.getPlayer().configureSID(0, sid -> sid.setFilterEnable(emulationSection, 0)));
        this.stereoFilter.selectedProperty().bindBidirectional((Property)emulationSection.stereoFilterProperty());
        this.stereoFilter.selectedProperty().addListener((obj, o, n) -> this.util.getPlayer().configureSID(1, sid -> sid.setFilterEnable(emulationSection, 1)));
        this.thirdSidFilter.selectedProperty().bindBidirectional((Property)emulationSection.thirdSIDFilterProperty());
        this.thirdSidFilter.selectedProperty().addListener((obj, o, n) -> this.util.getPlayer().configureSID(2, sid -> sid.setFilterEnable(emulationSection, 2)));
        this.detectPSID64ChipModel.selectedProperty().bindBidirectional((Property)emulationSection.detectPSID64ChipModelProperty());
        this.emulationChange = new EmulationChange();
        this.util.getPlayer().stateProperty().addListener(this.emulationChange);
        Platform.runLater(() -> {
            this.updateSettingsForTune(this.util.getPlayer().getTune());
            this.duringInitialization = false;
        });
    }

    private void updateSettingsForTune(SidTune tune) {
        this.updateFilterList(tune, 0, this.mainFilters, this.mainFilter);
        this.updateFilterList(tune, 1, this.secondFilters, this.secondFilter);
        this.updateFilterList(tune, 2, this.thirdFilters, this.thirdFilter);
        this.enableStereoSettings(tune);
    }

    private void enableStereoSettings(SidTune tune) {
        EmulationSection emulationSection = this.util.getConfig().getEmulationSection();
        boolean hardwareBasedSid = emulationSection.getEngine() == Engine.HARDSID || emulationSection.getEngine() == Engine.HARDSID_DLL || emulationSection.getEngine() == Engine.SIDBLASTER || emulationSection.getEngine() == Engine.EXSID || emulationSection.getEngine() == Engine.USBSID;
        boolean second = SidTune.isSIDUsed(emulationSection, tune, 1);
        boolean third = SidTune.isSIDUsed(emulationSection, tune, 2);
        boolean isForcedStereo = emulationSection.isForceStereo(1);
        boolean isForced3Sid = emulationSection.isForceStereo(2);
        this.stereoMode.getSelectionModel().select((Object)emulationSection.getStereoMode());
        this.mainVolume.setDisable(hardwareBasedSid);
        this.sid1Emulation.setDisable(hardwareBasedSid);
        this.mainFilter.setDisable(hardwareBasedSid);
        this.mainFilterCurve.setDisable(hardwareBasedSid);
        this.copy.setDisable(hardwareBasedSid);
        this.secondVolume.setDisable(!second || hardwareBasedSid);
        this.mainBalance.setDisable(!second || hardwareBasedSid);
        this.mainDelay.setDisable(!second);
        this.secondBalance.setDisable(!second || hardwareBasedSid);
        this.secondDelay.setDisable(!second);
        this.sid2Emulation.setDisable(!second || hardwareBasedSid);
        this.sid2Model.setDisable(!second);
        this.secondFilter.setDisable(!second || hardwareBasedSid);
        this.secondFilterCurve.setDisable(!second || hardwareBasedSid);
        this.stereoFilter.setDisable(!second);
        this.muteVoice5.setDisable(!second);
        this.muteVoice6.setDisable(!second);
        this.muteVoice7.setDisable(!second);
        this.muteVoice8.setDisable(!second);
        this.thirdVolume.setDisable(!third || hardwareBasedSid);
        this.thirdBalance.setDisable(!third || hardwareBasedSid);
        this.thirdDelay.setDisable(!third);
        this.sid3Emulation.setDisable(!third || hardwareBasedSid);
        this.sid3Model.setDisable(!third);
        this.thirdFilter.setDisable(!third || hardwareBasedSid);
        this.thirdFilterCurve.setDisable(!third || hardwareBasedSid);
        this.thirdSidFilter.setDisable(!third);
        this.muteVoice9.setDisable(!third);
        this.muteVoice10.setDisable(!third);
        this.muteVoice11.setDisable(!third);
        this.muteVoice12.setDisable(!third);
        this.sidToRead.setDisable(!emulationSection.isFakeStereo());
        this.baseAddress.setDisable(!isForcedStereo && !isForced3Sid);
        this.thirdAddress.setDisable(!isForced3Sid);
        this.boosted8580.setDisable(hardwareBasedSid);
    }

    @Override
    public void doClose() {
        this.util.getPlayer().stateProperty().removeListener(this.emulationChange);
    }

    @FXML
    private void setSid1Emulation() {
        this.updateFilterList(this.util.getPlayer().getTune(), 0, this.mainFilters, this.mainFilter);
    }

    @FXML
    private void setSid2Emulation() {
        this.updateFilterList(this.util.getPlayer().getTune(), 1, this.secondFilters, this.secondFilter);
    }

    @FXML
    private void setSid3Emulation() {
        this.updateFilterList(this.util.getPlayer().getTune(), 2, this.thirdFilters, this.thirdFilter);
    }

    @FXML
    private void setDefaultEmulation() {
        this.updateFilterList(this.util.getPlayer().getTune(), 0, this.mainFilters, this.mainFilter);
        this.updateFilterList(this.util.getPlayer().getTune(), 1, this.secondFilters, this.secondFilter);
        this.updateFilterList(this.util.getPlayer().getTune(), 2, this.thirdFilters, this.thirdFilter);
    }

    @FXML
    private void setSid1Model() {
        this.updateFilterList(this.util.getPlayer().getTune(), 0, this.mainFilters, this.mainFilter);
        this.updateFilterList(this.util.getPlayer().getTune(), 1, this.secondFilters, this.secondFilter);
        this.updateFilterList(this.util.getPlayer().getTune(), 2, this.thirdFilters, this.thirdFilter);
    }

    @FXML
    private void setSid2Model() {
        this.updateFilterList(this.util.getPlayer().getTune(), 1, this.secondFilters, this.secondFilter);
    }

    @FXML
    private void setSid3Model() {
        this.updateFilterList(this.util.getPlayer().getTune(), 2, this.thirdFilters, this.thirdFilter);
    }

    @FXML
    private void setDefaultModel() {
        this.updateFilterList(this.util.getPlayer().getTune(), 0, this.mainFilters, this.mainFilter);
        this.updateFilterList(this.util.getPlayer().getTune(), 1, this.secondFilters, this.secondFilter);
        this.updateFilterList(this.util.getPlayer().getTune(), 2, this.thirdFilters, this.thirdFilter);
    }

    @FXML
    private void setBaseAddress() {
        this.enableStereoSettings(this.util.getPlayer().getTune());
    }

    @FXML
    private void setThirdAddress() {
        this.enableStereoSettings(this.util.getPlayer().getTune());
    }

    @FXML
    private void setFakeStereo() {
        this.enableStereoSettings(this.util.getPlayer().getTune());
        this.drawFilterCurve(this.util.getPlayer().getTune(), 0, this.mainFilter, this.mainFilterCurve);
        this.drawFilterCurve(this.util.getPlayer().getTune(), 1, this.secondFilter, this.secondFilterCurve);
    }

    @FXML
    private void setStereoMode() {
        this.util.getConfig().getEmulationSection().setStereoMode((StereoMode)((Object)this.stereoMode.getSelectionModel().getSelectedItem()));
        this.enableStereoSettings(this.util.getPlayer().getTune());
        this.drawFilterCurve(this.util.getPlayer().getTune(), 0, this.mainFilter, this.mainFilterCurve);
        this.drawFilterCurve(this.util.getPlayer().getTune(), 1, this.secondFilter, this.secondFilterCurve);
        this.drawFilterCurve(this.util.getPlayer().getTune(), 2, this.thirdFilter, this.thirdFilterCurve);
    }

    @FXML
    private void setSidToRead() {
    }

    @FXML
    private void setDigiBoost() {
    }

    @FXML
    private void setMainFilter() {
        this.drawFilterCurve(this.util.getPlayer().getTune(), 0, this.mainFilter, this.mainFilterCurve);
    }

    @FXML
    private void setSecondFilter() {
        this.drawFilterCurve(this.util.getPlayer().getTune(), 1, this.secondFilter, this.secondFilterCurve);
    }

    @FXML
    private void setThirdFilter() {
        this.drawFilterCurve(this.util.getPlayer().getTune(), 2, this.thirdFilter, this.thirdFilterCurve);
    }

    @FXML
    private void restoreDefaults() {
        EmulationSection emulationSection = this.util.getConfig().getEmulationSection();
        AudioSection audioSection = this.util.getConfig().getAudioSection();
        emulationSection.setMuteVoice(0, 0, IniDefaults.DEFAULT_MUTE_VOICE1);
        emulationSection.setMuteVoice(0, 1, IniDefaults.DEFAULT_MUTE_VOICE2);
        emulationSection.setMuteVoice(0, 2, IniDefaults.DEFAULT_MUTE_VOICE3);
        emulationSection.setMuteVoice(0, 3, IniDefaults.DEFAULT_MUTE_VOICE4);
        emulationSection.setMuteVoice(1, 0, IniDefaults.DEFAULT_MUTE_STEREO_VOICE1);
        emulationSection.setMuteVoice(1, 1, IniDefaults.DEFAULT_MUTE_STEREO_VOICE2);
        emulationSection.setMuteVoice(1, 2, IniDefaults.DEFAULT_MUTE_STEREO_VOICE3);
        emulationSection.setMuteVoice(1, 3, IniDefaults.DEFAULT_MUTE_STEREO_VOICE4);
        emulationSection.setMuteVoice(2, 0, IniDefaults.DEFAULT_MUTE_THIRDSID_VOICE1);
        emulationSection.setMuteVoice(2, 1, IniDefaults.DEFAULT_MUTE_THIRDSID_VOICE2);
        emulationSection.setMuteVoice(2, 2, IniDefaults.DEFAULT_MUTE_THIRDSID_VOICE3);
        emulationSection.setMuteVoice(2, 3, IniDefaults.DEFAULT_MUTE_THIRDSID_VOICE4);
        audioSection.setVolume(0, IniDefaults.DEFAULT_MAIN_VOLUME);
        audioSection.setVolume(1, IniDefaults.DEFAULT_SECOND_VOLUME);
        audioSection.setVolume(2, IniDefaults.DEFAULT_THIRD_VOLUME);
        audioSection.setBalance(0, IniDefaults.DEFAULT_MAIN_BALANCE);
        audioSection.setBalance(1, IniDefaults.DEFAULT_SECOND_BALANCE);
        audioSection.setBalance(2, IniDefaults.DEFAULT_THIRD_BALANCE);
        audioSection.setDelay(0, IniDefaults.DEFAULT_MAIN_DELAY);
        audioSection.setDelay(1, IniDefaults.DEFAULT_SECOND_DELAY);
        audioSection.setDelay(2, IniDefaults.DEFAULT_THIRD_DELAY);
        emulationSection.setForceStereo(1, IniDefaults.DEFAULT_FORCE_STEREO_TUNE);
        emulationSection.setForceStereo(2, IniDefaults.DEFAULT_FORCE_3SID_TUNE);
        emulationSection.setDualSidBase(IniDefaults.DEFAULT_DUAL_SID_BASE);
        emulationSection.setThirdSIDBase(IniDefaults.DEFAULT_THIRD_SID_BASE);
        emulationSection.setSidToRead(IniDefaults.DEFAULT_SID_TO_READ);
        emulationSection.setDefaultSidModel(IniDefaults.DEFAULT_SID_MODEL);
        emulationSection.setDefaultEmulation(IniDefaults.DEFAULT_EMULATION);
        emulationSection.setDigiBoosted8580(IniDefaults.DEFAULT_DIGI_BOOSTED_8580);
        emulationSection.setFakeStereo(IniDefaults.DEFAULT_FAKE_STEREO);
        emulationSection.setDetectPSID64ChipModel(true);
        emulationSection.setForcedEmulation(0, IniDefaults.DEFAULT_USER_EMULATION);
        emulationSection.setForcedEmulation(1, IniDefaults.DEFAULT_STEREO_EMULATION);
        emulationSection.setForcedEmulation(2, IniDefaults.DEFAULT_3SID_EMULATION);
        emulationSection.setForcedSidModel(0, IniDefaults.DEFAULT_USER_MODEL);
        emulationSection.setForcedSidModel(1, IniDefaults.DEFAULT_STEREO_MODEL);
        emulationSection.setForcedSidModel(2, IniDefaults.DEFAULT_3SID_MODEL);
        emulationSection.setFilter(IniDefaults.DEFAULT_USE_FILTER);
        emulationSection.setStereoFilter(IniDefaults.DEFAULT_USE_STEREO_FILTER);
        emulationSection.setThirdSIDFilter(IniDefaults.DEFAULT_USE_3SID_FILTER);
        emulationSection.setFilter6581(IniDefaults.DEFAULT_FILTER_6581);
        emulationSection.setFilter8580(IniDefaults.DEFAULT_FILTER_8580);
        emulationSection.setStereoFilter6581(IniDefaults.DEFAULT_STEREO_FILTER_6581);
        emulationSection.setStereoFilter8580(IniDefaults.DEFAULT_STEREO_FILTER_8580);
        emulationSection.setThirdSIDFilter6581(IniDefaults.DEFAULT_3SID_FILTER_6581);
        emulationSection.setThirdSIDFilter8580(IniDefaults.DEFAULT_3SID_FILTER_8580);
        emulationSection.setReSIDfpFilter6581(IniDefaults.DEFAULT_ReSIDfp_FILTER_6581);
        emulationSection.setReSIDfpFilter8580(IniDefaults.DEFAULT_ReSIDfp_FILTER_8580);
        emulationSection.setReSIDfpStereoFilter6581(IniDefaults.DEFAULT_ReSIDfp_STEREO_FILTER_6581);
        emulationSection.setReSIDfpStereoFilter8580(IniDefaults.DEFAULT_ReSIDfp_STEREO_FILTER_8580);
        emulationSection.setReSIDfpThirdSIDFilter6581(IniDefaults.DEFAULT_ReSIDfp_3SID_FILTER_6581);
        emulationSection.setReSIDfpThirdSIDFilter8580(IniDefaults.DEFAULT_ReSIDfp_3SID_FILTER_8580);
        emulationSection.setNetSIDFilter6581(IniDefaults.DEFAULT_NETSID_FILTER_6581);
        emulationSection.setNetSIDFilter8580(IniDefaults.DEFAULT_NETSID_FILTER_8580);
        emulationSection.setNetSIDStereoFilter6581(IniDefaults.DEFAULT_NETSID_STEREO_FILTER_6581);
        emulationSection.setNetSIDStereoFilter8580(IniDefaults.DEFAULT_NETSID_STEREO_FILTER_8580);
        emulationSection.setNetSIDThirdSIDFilter6581(IniDefaults.DEFAULT_NETSID_3SID_FILTER_6581);
        emulationSection.setNetSIDThirdSIDFilter8580(IniDefaults.DEFAULT_NETSID_3SID_FILTER_8580);
        this.updateSettingsForTune(this.util.getPlayer().getTune());
    }

    @FXML
    private void doCopy() {
        EmulationSection emulationSection = this.util.getConfig().getEmulationSection();
        emulationSection.setStereoEmulation(emulationSection.getUserEmulation());
        emulationSection.setThirdEmulation(emulationSection.getUserEmulation());
        emulationSection.setStereoSidModel(emulationSection.getUserSidModel());
        emulationSection.setThirdSIDModel(emulationSection.getUserSidModel());
        emulationSection.setStereoFilter(emulationSection.isFilter());
        emulationSection.setThirdSIDFilter(emulationSection.isFilter());
        emulationSection.setStereoFilter6581(emulationSection.getFilter6581());
        emulationSection.setThirdSIDFilter6581(emulationSection.getFilter6581());
        emulationSection.setStereoFilter8580(emulationSection.getFilter8580());
        emulationSection.setThirdSIDFilter8580(emulationSection.getFilter8580());
        emulationSection.setReSIDfpStereoFilter6581(emulationSection.getReSIDfpFilter6581());
        emulationSection.setReSIDfpThirdSIDFilter6581(emulationSection.getReSIDfpFilter6581());
        emulationSection.setReSIDfpStereoFilter8580(emulationSection.getReSIDfpFilter8580());
        emulationSection.setReSIDfpThirdSIDFilter8580(emulationSection.getReSIDfpFilter8580());
        emulationSection.setNetSIDStereoFilter6581(emulationSection.getNetSIDFilter6581());
        emulationSection.setNetSIDThirdSIDFilter6581(emulationSection.getNetSIDFilter6581());
        emulationSection.setNetSIDStereoFilter8580(emulationSection.getNetSIDFilter8580());
        emulationSection.setNetSIDThirdSIDFilter8580(emulationSection.getNetSIDFilter8580());
        this.updateFilterList(this.util.getPlayer().getTune(), 1, this.secondFilters, this.secondFilter);
        this.updateFilterList(this.util.getPlayer().getTune(), 2, this.thirdFilters, this.thirdFilter);
    }

    private void restart() {
        if (!this.duringInitialization && this.util.getPlayer().stateProperty().get() != State.RESTART) {
            this.util.getPlayer().play(this.util.getPlayer().getTune());
        }
    }

    private void updateSIDChipConfiguration() {
        if (!this.duringInitialization) {
            this.util.getPlayer().updateSIDChipConfiguration();
        }
    }

    private void updateFilterList(SidTune tune, int sidNum, ObservableList<String> filters, ComboBox<String> filter) {
        EmulationSection emulationSection = this.util.getConfig().getEmulationSection();
        List<FilterSection> filterSections = this.util.getConfig().getFilterSection();
        Engine engine = emulationSection.getEngine();
        Emulation emulation = Emulation.getEmulation(emulationSection, sidNum);
        ChipModel model = ChipModel.getChipModel(emulationSection, tune, sidNum);
        String filterName = emulationSection.getFilterName(sidNum, engine, emulation, model);
        boolean filterEnable = emulationSection.isFilterEnable(sidNum);
        filters.clear();
        if (engine == Engine.NETSID) {
            filters.addAll(TrySetSidModel.getFilterNames(model));
        } else {
            filters.add((Object)"");
            for (IFilterSection iFilterSection : filterSections) {
                switch (model) {
                    case MOS6581: {
                        if ((!emulation.equals((Object)Emulation.RESIDFP) || !iFilterSection.isReSIDfpFilter6581()) && (!emulation.equals((Object)Emulation.RESID) || !iFilterSection.isReSIDFilter6581())) break;
                        filters.add((Object)iFilterSection.getName());
                        break;
                    }
                    case MOS8580: {
                        if ((!emulation.equals((Object)Emulation.RESIDFP) || !iFilterSection.isReSIDfpFilter8580()) && (!emulation.equals((Object)Emulation.RESID) || !iFilterSection.isReSIDFilter8580())) break;
                        filters.add((Object)iFilterSection.getName());
                        break;
                    }
                }
            }
        }
        if (filterEnable) {
            filter.getSelectionModel().select((Object)filterName);
        } else {
            filter.getSelectionModel().select(0);
        }
    }

    private void drawFilterCurve(SidTune tune, int sidNum, ComboBox<String> filterBox, LineChart<Number, Number> filterCurve) {
        EmulationSection emulationSection = this.util.getConfig().getEmulationSection();
        List<FilterSection> filterSections = this.util.getConfig().getFilterSection();
        Engine engine = emulationSection.getEngine();
        Emulation emulation = Emulation.getEmulation(emulationSection, sidNum);
        ChipModel model = ChipModel.getChipModel(emulationSection, tune, sidNum);
        boolean second = SidTune.isSIDUsed(emulationSection, tune, 1);
        boolean third = SidTune.isSIDUsed(emulationSection, tune, 2);
        String filterName = (String)filterBox.getSelectionModel().getSelectedItem();
        boolean filterDisabled = filterName == null || filterName.isEmpty();
        emulationSection.setFilterEnable(sidNum, !filterDisabled);
        emulationSection.setFilterName(sidNum, engine, emulation, model, !filterDisabled ? filterName : null);
        ArrayList<XYChart.Data> dataList = new ArrayList<XYChart.Data>();
        Optional<FilterSection> optFilter = filterSections.stream().filter(f -> f.getName().equals(filterName)).findFirst();
        if (optFilter.isPresent()) {
            FilterSection filterSection = optFilter.get();
            if ((filterCurve != this.secondFilterCurve || second) && (filterCurve != this.thirdFilterCurve || third)) {
                for (int fc = 0; fc < 2048; ++fc) {
                    double data;
                    if (filterSection.isReSIDFilter6581() || filterSection.isReSIDFilter8580()) {
                        data = builder.resid.resid.FilterModelConfig.estimateFrequency(filterSection, fc);
                        dataList.add(new XYChart.Data((Object)fc, (Object)data));
                        continue;
                    }
                    if (!filterSection.isReSIDfpFilter6581() && !filterSection.isReSIDfpFilter8580()) continue;
                    data = FilterModelConfig.estimateFrequency(filterSection, fc);
                    dataList.add(new XYChart.Data((Object)fc, (Object)data));
                }
            }
        }
        if (dataList.isEmpty()) {
            dataList.add(new XYChart.Data((Object)0, (Object)0));
        }
        XYChart.Series series = new XYChart.Series();
        series.setData(FXCollections.observableArrayList(dataList));
        List<XYChart.Series> seriesList = Arrays.asList(series);
        filterCurve.setData(FXCollections.observableArrayList(seriesList));
    }

    protected final class EmulationChange
    implements PropertyChangeListener {
        protected EmulationChange() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent event) {
            if (event.getNewValue() == State.START) {
                Platform.runLater(() -> EmulationSettings.this.updateSettingsForTune(EmulationSettings.this.util.getPlayer().getTune()));
            }
        }
    }
}

