/*
 * Decompiled with CFR 0.152.
 */
package ui.entities;

public enum DatabaseType {
    HSQL_FILE("org.hsqldb.jdbc.JDBCDriver", "jdbc:hsqldb:file:${name};hsqldb.sqllog=0;hsqldb.applog=0;shutdown=true", "org.hibernate.dialect.HSQLDialect"),
    HSQL_MEM("org.hsqldb.jdbc.JDBCDriver", "jdbc:hsqldb:mem:${name};hsqldb.sqllog=0;hsqldb.applog=0;shutdown=true", "org.hibernate.dialect.HSQLDialect"),
    MSACCESS("net.ucanaccess.jdbc.UcanaccessDriver", "jdbc:ucanaccess://${name};", "org.hibernate.dialect.SQLServerDialect");

    private String jdbcDriver;
    private String jdbcUrl;
    private String sqlDialect;

    private DatabaseType(String driver, String url, String dialect) {
        this.jdbcDriver = driver;
        this.jdbcUrl = url;
        this.sqlDialect = dialect;
    }

    public String getJdbcDriver() {
        return this.jdbcDriver;
    }

    public String getJdbcUrl() {
        return this.jdbcUrl;
    }

    public String getSqlDialect() {
        return this.sqlDialect;
    }
}

