/*
 * Decompiled with CFR 0.152.
 */
package ui.tools.audio;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Iterator;
import javax.sound.sampled.LineUnavailableException;
import libsidplay.common.CPUClock;
import libsidplay.common.EventScheduler;
import libsidplay.config.IAudioSection;
import libsidplay.sidtune.SidTune;
import libsidutils.IOUtils;
import libsidutils.fingerprinting.IFingerprintInserter;
import libsidutils.fingerprinting.rest.beans.MusicInfoBean;
import libsidutils.fingerprinting.rest.beans.WAVBean;
import sidplay.audio.WAVDriver;
import sidplay.audio.exceptions.SongEndException;

public class WhatsSidDriver
extends WAVDriver.WAVFileDriver {
    private static final String TAG_UNKNOWN = "<???>";
    private String recordingFilename;
    private String collectionName;
    private SidTune tune;
    private IFingerprintInserter fingerprintInserter;

    @Override
    public void open(IAudioSection audioSection, String recordingFilename, CPUClock cpuClock, EventScheduler context) throws IOException, LineUnavailableException, InterruptedException {
        this.recordingFilename = recordingFilename;
        if (new File(recordingFilename).exists()) {
            throw new SongEndException();
        }
        super.open(audioSection, recordingFilename, cpuClock, context);
    }

    @Override
    public void close() {
        super.close();
        try {
            if (new File(this.recordingFilename).exists()) {
                int songNo = this.tune != SidTune.RESET ? this.tune.getInfo().getCurrentSong() : 1;
                System.out.printf("Insert Fingerprint for %s (%d)\n", this.collectionName, songNo);
                WAVBean wavBean = new WAVBean(Files.readAllBytes(Paths.get(this.recordingFilename, new String[0])));
                wavBean.setMaxSeconds(Long.MAX_VALUE);
                this.fingerprintInserter.insert(this.createMusicInfoBean(songNo), wavBean);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Error reading WAV audio stream", e);
        }
    }

    public void setTune(SidTune tune) {
        this.tune = tune;
    }

    public void setCollectionName(String collectionName) {
        this.collectionName = collectionName;
    }

    public void setFingerprintInserter(IFingerprintInserter fingerprintInserter) {
        this.fingerprintInserter = fingerprintInserter;
    }

    private MusicInfoBean createMusicInfoBean(int songNo) {
        String released;
        String author;
        String title;
        if (this.tune != SidTune.RESET) {
            Iterator<String> descriptionIt = this.tune.getInfo().getInfoString().iterator();
            title = descriptionIt.hasNext() ? descriptionIt.next() : TAG_UNKNOWN;
            author = descriptionIt.hasNext() ? descriptionIt.next() : TAG_UNKNOWN;
            released = descriptionIt.hasNext() ? descriptionIt.next() : TAG_UNKNOWN;
        } else {
            title = new File(IOUtils.getFilenameWithoutSuffix(this.collectionName)).getName();
            author = TAG_UNKNOWN;
            released = TAG_UNKNOWN;
        }
        return this.toMusicInfoBean(songNo, title, author, released);
    }

    private MusicInfoBean toMusicInfoBean(int songNo, String title, String author, String released) {
        MusicInfoBean musicInfoBean = new MusicInfoBean();
        musicInfoBean.setSongNo(songNo);
        musicInfoBean.setTitle(title);
        musicInfoBean.setArtist(author);
        musicInfoBean.setAlbum(released);
        musicInfoBean.setFileDir(this.recordingFilename);
        musicInfoBean.setInfoDir(this.collectionName);
        return musicInfoBean;
    }
}

