/*
 * Decompiled with CFR 0.152.
 */
package com.healthmarketscience.jackcess.impl.expr;

import com.healthmarketscience.jackcess.expr.LocaleContext;
import com.healthmarketscience.jackcess.expr.Value;
import com.healthmarketscience.jackcess.impl.expr.BaseNumericValue;
import com.healthmarketscience.jackcess.impl.expr.NumberFormatter;
import java.math.BigDecimal;

public class BigDecimalValue
extends BaseNumericValue {
    private final BigDecimal _val;

    public BigDecimalValue(BigDecimal val) {
        this._val = val;
    }

    @Override
    public Value.Type getType() {
        return Value.Type.BIG_DEC;
    }

    @Override
    public Object get() {
        return this._val;
    }

    @Override
    protected Number getNumber() {
        return this._val;
    }

    @Override
    public boolean getAsBoolean(LocaleContext ctx) {
        return (long)this._val.compareTo(BigDecimal.ZERO) != 0L;
    }

    @Override
    public String getAsString(LocaleContext ctx) {
        return NumberFormatter.format(this._val);
    }

    @Override
    public BigDecimal getAsBigDecimal(LocaleContext ctx) {
        return this._val;
    }
}

