/*
 * Decompiled with CFR 0.152.
 */
package net.java.truecommons.io;

import edu.umd.cs.findbugs.annotations.CleanupObligation;
import edu.umd.cs.findbugs.annotations.DischargesObligation;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.SeekableByteChannel;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.WillCloseWhenClosed;
import javax.annotation.concurrent.NotThreadSafe;

@CleanupObligation
@NotThreadSafe
public class ChannelInputStream
extends InputStream {
    private final ByteBuffer single = ByteBuffer.allocate(1);
    @Nullable
    protected SeekableByteChannel channel;
    private long mark = -1L;

    protected ChannelInputStream() {
    }

    public ChannelInputStream(@WillCloseWhenClosed SeekableByteChannel channel) {
        this.channel = Objects.requireNonNull(channel);
    }

    @Override
    public int read() throws IOException {
        this.single.rewind();
        return 1 == this.read(this.single) ? this.single.get(0) & 0xFF : -1;
    }

    @Override
    public final int read(byte[] b) throws IOException {
        return this.read(ByteBuffer.wrap(b));
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        return this.read(ByteBuffer.wrap(b, off, len));
    }

    private int read(ByteBuffer bb) throws IOException {
        int read;
        if (0 == bb.remaining()) {
            return 0;
        }
        while (0 == (read = this.channel.read(bb))) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
            }
        }
        return read;
    }

    @Override
    public long skip(long n) throws IOException {
        if (n <= 0L) {
            return 0L;
        }
        long pos = this.channel.position();
        long size = this.channel.size();
        long rem = size - pos;
        if (n > rem) {
            n = (int)rem;
        }
        this.channel.position(pos + n);
        return n;
    }

    @Override
    public int available() throws IOException {
        long avl = this.channel.size() - this.channel.position();
        return avl > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)avl;
    }

    @Override
    @DischargesObligation
    public void close() throws IOException {
        this.channel.close();
    }

    @Override
    public void mark(int readlimit) {
        try {
            this.mark = this.channel.position();
        }
        catch (IOException ex) {
            this.mark = -2L;
        }
    }

    @Override
    public void reset() throws IOException {
        if (0L > this.mark) {
            throw new IOException(-1L == this.mark ? "No mark set!" : "mark()/reset() not supported!");
        }
        this.channel.position(this.mark);
        this.mark = -1L;
    }

    @Override
    public boolean markSupported() {
        try {
            this.channel.position(this.channel.position());
            return true;
        }
        catch (IOException ex) {
            this.mark = -2L;
            return false;
        }
    }
}

