/*
 * Decompiled with CFR 0.152.
 */
package org.usb4java;

import java.nio.ByteBuffer;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.usb4java.BufferUtils;
import org.usb4java.DescriptorUtils;
import org.usb4java.DeviceHandle;
import org.usb4java.LibUsb;

public final class DeviceDescriptor {
    private long deviceDescriptorPointer;
    private final ByteBuffer deviceDescriptorBuffer = BufferUtils.allocateByteBuffer(LibUsb.deviceDescriptorStructSize());

    public long getPointer() {
        return this.deviceDescriptorPointer;
    }

    public ByteBuffer getBuffer() {
        return this.deviceDescriptorBuffer;
    }

    public native byte bLength();

    public native byte bDescriptorType();

    public native short bcdUSB();

    public native byte bDeviceClass();

    public native byte bDeviceSubClass();

    public native byte bDeviceProtocol();

    public native byte bMaxPacketSize0();

    public native short idVendor();

    public native short idProduct();

    public native short bcdDevice();

    public native byte iManufacturer();

    public native byte iProduct();

    public native byte iSerialNumber();

    public native byte bNumConfigurations();

    public String dump() {
        return this.dump(null);
    }

    public String dump(DeviceHandle handle) {
        String sManufacturer = LibUsb.getStringDescriptor(handle, this.iManufacturer());
        String sProduct = LibUsb.getStringDescriptor(handle, this.iProduct());
        String sSerialNumber = LibUsb.getStringDescriptor(handle, this.iSerialNumber());
        return DescriptorUtils.dump(this, sManufacturer, sProduct, sSerialNumber);
    }

    public int hashCode() {
        return new HashCodeBuilder().append(this.bLength()).append(this.bDescriptorType()).append(this.bcdUSB()).append(this.bDeviceClass()).append(this.bDeviceSubClass()).append(this.bDeviceProtocol()).append(this.bMaxPacketSize0()).append(this.idVendor()).append(this.idProduct()).append(this.bcdDevice()).append(this.iManufacturer()).append(this.iProduct()).append(this.iSerialNumber()).append(this.bNumConfigurations()).toHashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DeviceDescriptor other = (DeviceDescriptor)obj;
        return new EqualsBuilder().append(this.bLength(), other.bLength()).append(this.bDescriptorType(), other.bDescriptorType()).append(this.bcdUSB(), other.bcdUSB()).append(this.bDeviceClass(), other.bDeviceClass()).append(this.bDeviceSubClass(), other.bDeviceSubClass()).append(this.bDeviceProtocol(), other.bDeviceProtocol()).append(this.bMaxPacketSize0(), other.bMaxPacketSize0()).append(this.idVendor(), other.idVendor()).append(this.idProduct(), other.idProduct()).append(this.bcdDevice(), other.bcdDevice()).append(this.iManufacturer(), other.iManufacturer()).append(this.iProduct(), other.iProduct()).append(this.iSerialNumber(), other.iSerialNumber()).append(this.bNumConfigurations(), other.bNumConfigurations()).isEquals();
    }

    public String toString() {
        return this.dump();
    }
}

