/*
 * Decompiled with CFR 0.152.
 */
package net.java.truevfs.access;

import java.io.File;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;
import java.util.function.Supplier;
import javax.annotation.CheckForNull;
import javax.annotation.concurrent.Immutable;
import net.java.truecommons.services.Loader;
import net.java.truecommons.shed.CanonicalStringSet;
import net.java.truecommons.shed.ExtensionSet;
import net.java.truecommons.shed.HashMaps;
import net.java.truevfs.kernel.spec.FsAbstractCompositeDriver;
import net.java.truevfs.kernel.spec.FsDriver;
import net.java.truevfs.kernel.spec.FsScheme;
import net.java.truevfs.kernel.spec.sl.FsDriverMapLocator;

@Immutable
public final class TArchiveDetector
extends FsAbstractCompositeDriver {
    public static final TArchiveDetector NULL = new TArchiveDetector("");
    public static final TArchiveDetector ALL = new TArchiveDetector(null);
    private final ExtensionSet extensions;
    private final Map<FsScheme, FsDriver> drivers;

    private static ExtensionSet extensions(Supplier<Map<FsScheme, FsDriver>> provider) {
        if (provider instanceof TArchiveDetector) {
            return new ExtensionSet((Collection)((TArchiveDetector)((Object)provider)).extensions);
        }
        Map<FsScheme, FsDriver> map = provider.get();
        ExtensionSet set = new ExtensionSet();
        for (Map.Entry<FsScheme, FsDriver> entry : map.entrySet()) {
            if (!entry.getValue().isArchiveDriver()) continue;
            set.add(entry.getKey().toString());
        }
        return set;
    }

    private static Map<FsScheme, FsDriver> map(Object[][] config) {
        HashMap<FsScheme, FsDriver> drivers = new HashMap<FsScheme, FsDriver>(HashMaps.initialCapacity((int)config.length) * 2);
        for (Object[] param : config) {
            Collection<FsScheme> schemes = TArchiveDetector.schemes(param[0]);
            if (schemes.isEmpty()) {
                throw new IllegalArgumentException("No file system schemes!");
            }
            FsDriver driver = (FsDriver)Loader.promote((Object)param[1], FsDriver.class);
            for (FsScheme scheme : schemes) {
                drivers.put(scheme, driver);
            }
        }
        return Collections.unmodifiableMap(drivers);
    }

    private static Collection<FsScheme> schemes(Object o) {
        TreeSet<FsScheme> set = new TreeSet<FsScheme>();
        try {
            if (o instanceof Collection) {
                for (Object p : (Collection)o) {
                    if (p instanceof FsScheme) {
                        set.add((FsScheme)p);
                        continue;
                    }
                    for (String q : new ExtensionSet(p.toString())) {
                        set.add(new FsScheme(q));
                    }
                }
            } else if (o instanceof FsScheme) {
                set.add((FsScheme)o);
            } else {
                for (String p : new ExtensionSet(o.toString())) {
                    set.add(new FsScheme(p));
                }
            }
        }
        catch (URISyntaxException ex) {
            throw new IllegalArgumentException(ex);
        }
        return set;
    }

    public TArchiveDetector(@CheckForNull String extensions) {
        this((Supplier<Map<FsScheme, FsDriver>>)FsDriverMapLocator.SINGLETON, extensions);
    }

    public TArchiveDetector(Supplier<Map<FsScheme, FsDriver>> provider, @CheckForNull String extensions) {
        ExtensionSet accepted;
        ExtensionSet available = TArchiveDetector.extensions(provider);
        if (null == extensions) {
            accepted = available;
        } else {
            accepted = new ExtensionSet(extensions);
            if (accepted.retainAll((CanonicalStringSet)available)) {
                accepted = new ExtensionSet(extensions);
                accepted.removeAll((CanonicalStringSet)available);
                assert (!accepted.isEmpty());
                throw new IllegalArgumentException("\"" + accepted + "\" (no archive driver installed for these extensions)");
            }
        }
        this.extensions = accepted;
        this.drivers = provider.get();
    }

    public TArchiveDetector(String extensions, @CheckForNull FsDriver driver) {
        this((Supplier<Map<FsScheme, FsDriver>>)((Object)NULL), extensions, driver);
    }

    public TArchiveDetector(Supplier<Map<FsScheme, FsDriver>> provider, String extensions, @CheckForNull FsDriver driver) {
        this(provider, new Object[][]{{extensions, driver}});
    }

    public TArchiveDetector(Supplier<Map<FsScheme, FsDriver>> provider, Object[][] config) {
        this(provider, TArchiveDetector.map(config));
    }

    public TArchiveDetector(Supplier<Map<FsScheme, FsDriver>> provider, Map<FsScheme, FsDriver> config) {
        ExtensionSet extensions = TArchiveDetector.extensions(provider);
        Map<FsScheme, FsDriver> available = provider.get();
        HashMap<FsScheme, FsDriver> drivers = new HashMap<FsScheme, FsDriver>(HashMaps.initialCapacity((int)(available.size() + config.size())));
        drivers.putAll(available);
        for (Map.Entry<FsScheme, FsDriver> entry : config.entrySet()) {
            FsScheme scheme = entry.getKey();
            FsDriver driver = entry.getValue();
            if (null != driver) {
                extensions.add(scheme.toString());
                drivers.put(scheme, driver);
                continue;
            }
            extensions.remove((Object)scheme.toString());
        }
        this.extensions = extensions;
        this.drivers = Collections.unmodifiableMap(drivers);
    }

    public String getExtensions() {
        return this.extensions.toString();
    }

    public Map<FsScheme, FsDriver> getDrivers() {
        return this.drivers;
    }

    public Map<FsScheme, FsDriver> get() {
        return this.drivers;
    }

    @CheckForNull
    public FsScheme scheme(String path) {
        path = path.replace('/', File.separatorChar);
        int i = path.lastIndexOf(File.separatorChar) + 1;
        path = path.substring(i);
        int l = path.length();
        i = 0;
        while (0 < (i = path.indexOf(46, i) + 1) && i < l) {
            String scheme = path.substring(i);
            if (!this.extensions.contains((Object)scheme)) continue;
            try {
                return new FsScheme(scheme);
            }
            catch (URISyntaxException uRISyntaxException) {
            }
        }
        return null;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof TArchiveDetector)) {
            return false;
        }
        TArchiveDetector that = (TArchiveDetector)((Object)other);
        return this.extensions.equals((Object)that.extensions) && this.drivers.equals(that.drivers);
    }

    public int hashCode() {
        int hash = 3;
        hash = 59 * hash + this.extensions.hashCode();
        hash = 59 * hash + this.drivers.hashCode();
        return hash;
    }

    public String toString() {
        return String.format("%s[extensions=%s, drivers=%s]", ((Object)((Object)this)).getClass().getName(), this.extensions, this.drivers);
    }
}

